/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;

public class DiagramNodeAddShapeActionHandler
extends SapphireActionHandler {
    private static final String ID_BASE = "Sapphire.Add.";
    private DiagramNodePart nodePart;
    private ShapeFactoryPart factory;
    private ElementType type;

    public DiagramNodeAddShapeActionHandler(DiagramNodePart nodePart, ShapeFactoryPart factory, ElementType type) {
        this.nodePart = nodePart;
        this.factory = factory;
        this.type = type;
    }

    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID_BASE + this.type.getSimpleName());
        this.setLabel(this.type.getLabel(true, CapitalizationType.NO_CAPS, false));
        ImageData typeSpecificAddImage = this.type.image();
        if (typeSpecificAddImage != null) {
            this.addImage(typeSpecificAddImage);
        }
    }

    @Override
    protected Object run(Presentation context) {
        Element element = this.factory.getModelElementList().insert(this.type);
        ShapePart shapePart = this.factory.getShapePart(element);
        SapphireDiagramEditorPagePart diagramPart = this.nodePart.nearest(SapphireDiagramEditorPagePart.class);
        if (shapePart.isEditable()) {
            diagramPart.selectAndDirectEdit(shapePart);
        }
        return null;
    }
}

