/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.remote.console.actions.IConsoleActionFactory;
import org.eclipse.remote.internal.console.Activator;

public class TerminalConsoleExtensionManager {
    private static TerminalConsoleExtensionManager instance;
    private Map<String, List<String>> actions;
    private Map<String, IConsoleActionFactory> factories;
    private Map<String, IConfigurationElement> elements;

    private TerminalConsoleExtensionManager() {
    }

    public static TerminalConsoleExtensionManager getInstance() {
        if (instance == null) {
            instance = new TerminalConsoleExtensionManager();
        }
        return instance;
    }

    public List<String> getActionsForType(String id) {
        this.initialize();
        ArrayList list = this.actions.get(id);
        return list == null ? new ArrayList() : list;
    }

    public IConsoleActionFactory getFactory(String id) {
        return this.factories.get(id);
    }

    private void initialize() {
        if (this.actions == null) {
            this.actions = new LinkedHashMap<String, List<String>>();
            this.elements = new LinkedHashMap<String, IConfigurationElement>();
            this.factories = new HashMap<String, IConsoleActionFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".toolbar");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String id = element.getAttribute("id");
                    if (id != null) {
                        String connectionType;
                        this.elements.put(id, element);
                        IConsoleActionFactory factory = null;
                        try {
                            factory = (IConsoleActionFactory)element.createExecutableExtension("actionFactory");
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                        if (factory != null && (connectionType = element.getAttribute("connectionType")) != null) {
                            List<String> actionList = this.actions.get(connectionType);
                            if (actionList == null) {
                                actionList = new ArrayList<String>();
                            }
                            actionList.add(id);
                            this.actions.put(connectionType, actionList);
                            this.factories.put(id, factory);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

