/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.html;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.EclException;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaException;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoNode;
import org.eclipse.rcptt.tesla.core.info.JobEntry;
import org.eclipse.rcptt.tesla.core.info.NodeProperty;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfo;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.info.StackTraceEntry;

public class FullSingleTestHtmlRenderer {
    private final PrintWriter writer;
    private final NumberFormat durationFormat;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm");
    private final Function<Screenshot, String> imageStorage;
    private static final Predicate<Q7WaitInfo> isNotIgnored = new Predicate<Q7WaitInfo>(){

        public boolean apply(Q7WaitInfo input) {
            return SimpleReportGenerator.getType((Q7WaitInfo)input) != null;
        }
    };
    private final Map<Screenshot, String> cache = new HashMap<Screenshot, String>();
    private static final Function<Node, Iterable<Screenshot>> screenShots = new Function<Node, Iterable<Screenshot>>(){

        public Iterable<Screenshot> apply(Node input) {
            ArrayList<Screenshot> acc = new ArrayList<Screenshot>(0);
            for (Snaphot snapshot : input.getSnapshots()) {
                if (!(snapshot.getData() instanceof Screenshot)) continue;
                acc.add((Screenshot)snapshot.getData());
            }
            return acc;
        }
    };
    private static final Function<Node, Iterable<Node>> recursiveChildren = new Function<Node, Iterable<Node>>(){

        public Iterable<Node> apply(Node input) {
            Iterable children = Iterables.concat((Iterable)Collections2.transform((Collection)input.getChildren(), (Function)recursiveChildren));
            return Iterables.concat(Arrays.asList(input), (Iterable)children);
        }
    };

    public FullSingleTestHtmlRenderer(PrintWriter writer, NumberFormat durationFormat, Function<Screenshot, String> imageStorage) {
        this.writer = writer;
        this.durationFormat = durationFormat;
        this.imageStorage = imageStorage;
    }

    private void renderHeader(int level, String title, String classes) {
        if ((level += 2) > 6) {
            level = 6;
        }
        this.writer.println(String.format("<h%d class=\"%s\">%s</h%d>", level, classes, title, level));
    }

    public void render(Report report) {
        Node root = report.getRoot();
        if (root == null) {
            this.renderHeader(0, "Empty report", "failure");
            return;
        }
        this.renderHeader(0, root.getName(), this.toFailureClass(root));
        this.renderMain(root);
        this.openDetails(1, "Details", "");
        this.renderNode(root);
        this.closeDetails();
    }

    private void renderNode(Node node) {
        Q7Info info = ReportHelper.getInfo((Node)node);
        this.renderResult(info.getResult());
        EList children = node.getChildren();
        Q7WaitInfoRoot waitInfo = ReportHelper.getWaitInfo((Node)node, (boolean)false);
        if (waitInfo != null) {
            this.renderWaitInfo(waitInfo);
        }
        this.writer.println("<div class=\"childNode\">");
        for (Node child : children) {
            this.openDetails(2, child.getName(), this.toFailureClass(child));
            this.renderNode(child);
            this.closeDetails();
        }
        this.writer.println("</div>");
        this.renderEvents((Collection<Event>)node.getEvents());
        this.renderSnapshots((EList<Snaphot>)node.getSnapshots());
        StringBuilder logs = new StringBuilder();
        for (LoggingCategory logCategory : LoggingCategory.VALUES) {
            String logs2 = ReportBuilder.getLogs((Node)node, (LoggingCategory)logCategory);
            if (logs2 == null) continue;
            logs.append(logs2);
        }
        if (logs.length() > 2) {
            this.renderHeader(2, "Logs", "");
            this.writer.println("<pre>");
            this.writer.println(logs);
            this.writer.println("</pre>");
        }
    }

    private String toFailureClass(Q7Info info) {
        SimpleSeverity severity = SimpleSeverity.create((Q7Info)info);
        switch (severity) {
            case CANCEL: {
                return "skipped";
            }
            case ERROR: {
                return "failure";
            }
            case OK: {
                return "passed";
            }
        }
        return "";
    }

    private void renderSnapshots(EList<Snaphot> snapshots) {
        if (snapshots.isEmpty()) {
            return;
        }
        this.renderHeader(2, "Snapshot", "");
        for (Snaphot e : snapshots) {
            this.renderHeader(3, this.dateFormat.format(e.getTime()), "");
            this.renderEvent(e.getData());
        }
    }

    private void renderWaitInfo(Q7WaitInfoRoot root) {
        Collection nonIgnored = Collections2.filter((Collection)root.getInfos(), isNotIgnored);
        if (nonIgnored.isEmpty()) {
            return;
        }
        this.renderHeader(2, "Profile", "");
        this.writer.println("<table><tr>");
        this.writer.println("<th>Task type</th>");
        this.writer.println("<th>Class</th>");
        this.writer.println("<th>Time taken (ms)</th></tr>");
        for (Q7WaitInfo info : nonIgnored) {
            long duration = info.getDuration();
            String type = SimpleReportGenerator.getType((Q7WaitInfoRoot)root, (Q7WaitInfo)info);
            assert (type != null) : "Should be prefiltered";
            String className = SimpleReportGenerator.getClassName((Q7WaitInfoRoot)root, (Q7WaitInfo)info);
            if (!TeslaFeatures.isIncludeEclipseMethodsWaitDetails() && className.startsWith("org.eclipse")) continue;
            this.row(type, className, "" + duration);
        }
        this.writer.println("</table>");
    }

    private void renderEvents(Collection<Event> events) {
        if (events.isEmpty()) {
            return;
        }
        this.renderHeader(2, "Events", "");
        for (Event e : events) {
            if (e.getCount() == 1) {
                this.renderHeader(3, "Event at " + this.dateFormat.format(e.getTime()), "");
            } else {
                String header = "Event: " + e.getCount() + " times, first at " + this.dateFormat.format(e.getTime());
                this.renderHeader(3, header, "");
            }
            this.renderEvent(e.getData());
        }
    }

    private void renderEvent(EObject eObject) {
        if (eObject instanceof EclipseStatus) {
            this.renderResult(this.toResult((EclipseStatus)eObject));
        } else if (eObject instanceof Screenshot) {
            this.renderScreenShot((Screenshot)eObject, "");
        } else if (eObject instanceof AdvancedInformation) {
            this.renderAdvanced((AdvancedInformation)eObject);
        } else {
            this.writer.println(eObject.eClass().getName());
        }
    }

    public void renderAdvanced(AdvancedInformation info) {
        EList threads;
        EList nodes = info.getNodes();
        for (InfoNode infoNode : nodes) {
            this.renderNode(infoNode);
        }
        EList jobs = info.getJobs();
        if (!jobs.isEmpty()) {
            this.renderHeader(5, "Jobs information", "");
            for (JobEntry jobEntry : jobs) {
                this.writer.println(jobEntry.getName());
                this.writer.println(": class=" + jobEntry.getJobClass());
                this.writer.println(", state=" + jobEntry.getState());
                if (jobEntry.getRule() != null) {
                    this.writer.println("rule=" + jobEntry.getRule());
                }
                this.writer.println("<br>");
            }
        }
        if (!(threads = info.getThreads()).isEmpty()) {
            this.renderHeader(5, "Thread information", "");
            this.writer.println("<div class=\"childNode\">");
            for (StackTraceEntry trace : threads) {
                if (trace.getThreadClass().equals("org.eclipse.core.internal.jobs.Worker") && trace.getStackTrace().size() == 4) continue;
                this.renderHeader(5, trace.getThreadName(), "");
                this.writer.println("class=" + trace.getThreadClass());
                EList list = trace.getStackTrace();
                int i = 0;
                while (i < list.size()) {
                    this.writer.append(Integer.toString(list.size() - i - 1)).append(": ").append((CharSequence)list.get(i)).println("<br>");
                    ++i;
                }
            }
            this.writer.println("</div>");
        }
    }

    private void renderNode(InfoNode infoNode) {
        this.writer.println(infoNode.getName());
        EList list = infoNode.getProperties();
        EList childs = infoNode.getChildren();
        if (!list.isEmpty() || !childs.isEmpty()) {
            this.writer.println(" {");
            this.writer.println("<div class=\"childNode\">");
            if (list.size() != 0) {
                for (NodeProperty nodeProperty : list) {
                    this.writer.println(String.valueOf(nodeProperty.getName()) + "=" + nodeProperty.getValue() + " <br>");
                }
            }
            if (childs.size() != 0) {
                for (InfoNode child : childs) {
                    this.renderNode(child);
                }
            }
            this.writer.println("}");
            this.writer.println("</div>");
        }
    }

    private void renderScreenShot(Screenshot shot, String attributes) {
        String path = this.getOrCreateScreenshot(shot);
        this.writer.println(String.format("<a href=\"%s\">", path));
        if (!Strings.isNullOrEmpty((String)attributes)) {
            attributes = " " + attributes;
        }
        this.writer.println(String.format("<img src=\"%s\"" + attributes + "/>", path));
        this.writer.println("</a>");
    }

    private String getOrCreateScreenshot(Screenshot shot) {
        String rv = this.cache.get(shot);
        if (rv != null) {
            return rv;
        }
        rv = (String)this.imageStorage.apply((Object)shot);
        this.cache.put(shot, rv);
        return rv;
    }

    private ProcessStatus toResult(EclipseStatus input) {
        ProcessStatus rv = CoreFactory.eINSTANCE.createProcessStatus();
        rv.setSeverity(input.getSeverity());
        rv.setMessage(input.getMessage());
        rv.setException(this.toEclException(input.getException()));
        rv.setPluginId(input.getPlugin());
        for (EclipseStatus child : input.getChildren()) {
            rv.getChildren().add((Object)this.toResult(child));
        }
        return rv;
    }

    private EclException toEclException(JavaException input) {
        if (input == null) {
            return null;
        }
        EclException rv = CoreFactory.eINSTANCE.createEclException();
        rv.setCause(this.toEclException(input.getCause()));
        rv.setClassName(input.getClassName());
        rv.setMessage(input.getMessage());
        return rv;
    }

    private void openDetails(int level, String title, String classes) {
        this.writer.println("<details class=\"closed\">");
        this.writer.println("<summary>");
        this.renderHeader(level, title, classes);
        this.writer.println("</summary>");
        this.writer.println("<div class=\"detailsContent\">");
    }

    private void closeDetails() {
        this.writer.println("</div>");
        this.writer.println("</details>");
    }

    private void renderResult(ProcessStatus result) {
        if (result == null) {
            this.writer.println("Result is null");
        } else {
            this.writer.println(SimpleSeverity.create((ProcessStatus)result).toString());
            if (!Strings.isNullOrEmpty((String)result.getMessage())) {
                this.writer.println(", message: " + result.getMessage() + "<br>");
            }
            if (result.getException() != null) {
                this.openDetails(5, "Exception", "");
                this.renderException(result.getException());
                this.closeDetails();
            }
            this.writer.println("<div class=\"childNode\">");
            for (ProcessStatus child : result.getChildren()) {
                if (child.getSeverity() == 0) continue;
                this.renderResult(child);
            }
            this.writer.println("</div>");
        }
    }

    private void renderException(EclException exception) {
        Throwable throwable = exception.getThrowable();
        if (throwable == null) {
            this.writer.println(String.valueOf(exception.getClassName()) + ": " + exception.getMessage() + " <br>");
        } else {
            this.writer.println("<pre>");
            throwable.printStackTrace(this.writer);
            this.writer.println("</pre>");
        }
    }

    private void titledRow(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        if (value != null) {
            this.writer.println(String.format("<tr><th>%s</th><td>%s</td></tr>", key, value));
        }
    }

    private void row(String key, String value1, String value2) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value1);
        Preconditions.checkNotNull((Object)value2);
        this.writer.println(String.format("<tr><td>\"%s\"</td><td>%s</td><td>%s</td></tr>", key, value1, value2));
    }

    private void renderMain(Node root) {
        String message = ReportUtils.getFailMessage((Node)root);
        message = ReportUtils.replaceHtmlEntities((String)message);
        message = ReportUtils.replaceLineBreaks((String)message);
        this.writer.println("<table class=\"" + this.toFailureClass(root) + "\">");
        this.titledRow("Failure Reason", message);
        String tags = ReportUtils.getScenarioTags((Node)root);
        tags = ReportUtils.replaceLineBreaks((String)tags).trim();
        this.titledRow("Tags", Strings.emptyToNull((String)tags));
        this.titledRow("Duration", this.durationFormat.format(FullSingleTestHtmlRenderer.durationSeconds(root)));
        String desc = ReportUtils.getScenarioDescription((Node)root);
        desc = ReportUtils.replaceLineBreaks((String)desc);
        this.titledRow("Description", desc);
        this.writer.println("</table>");
        this.renderScreenShots(root);
    }

    private String toFailureClass(Node root) {
        return this.toFailureClass(ReportHelper.getInfo((Node)root));
    }

    private void renderScreenShots(Node root) {
        ArrayList screens = Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)((Iterable)recursiveChildren.apply((Object)root)), screenShots)));
        if (screens.isEmpty()) {
            return;
        }
        this.renderHeader(1, "Screenshots", "");
        for (Screenshot screen : screens) {
            this.renderScreenShot(screen, "width=\"100px\"");
        }
    }

    private static float durationSeconds(Node node) {
        long millseconds = node.getDuration();
        return (float)millseconds / 1000.0f;
    }
}

