/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AssociationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AttributeStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ClassStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.PropertyStatus;
import org.eclipse.qvtd.runtime.evaluation.AbstractExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Computation;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.Execution;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.evaluation.Transformer;

public class Execution2GraphVisitor
extends AbstractExecutionVisitor<Object> {
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    protected final @NonNull GraphStringBuilder context;
    private Map<@NonNull AssociationStatus, @NonNull String> associationId = new HashMap<AssociationStatus, String>();
    private Map<@NonNull ClassStatus, @NonNull String> classId = new HashMap<ClassStatus, String>();
    private Map<@NonNull Computation, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> computation2node = new HashMap<Computation, GraphStringBuilder.GraphNode>();
    private Map<@NonNull Connection, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> connection2node = new HashMap<Connection, GraphStringBuilder.GraphNode>();
    private Map<@NonNull Interval, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> interval2node = new HashMap<Interval, GraphStringBuilder.GraphNode>();
    private Map<@NonNull Invocation, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> invocation2node = new HashMap<Invocation, GraphStringBuilder.GraphNode>();
    private Map<@NonNull InvocationConstructor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> invocationConstructor2node = new HashMap<InvocationConstructor, GraphStringBuilder.GraphNode>();
    private Map<@NonNull Object, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> object2node = new HashMap<Object, GraphStringBuilder.GraphNode>();
    private Map<@NonNull SlotState, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode> slot2node = new HashMap<SlotState, GraphStringBuilder.GraphNode>();

    public static void writeGraphMLfile(Transformer tx, @NonNull URI graphmlURI) {
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(graphmlURI);
            GraphMLStringBuilder s = new GraphMLStringBuilder();
            Execution2GraphVisitor execution2GraphVisitor = new Execution2GraphVisitor((GraphStringBuilder)s);
            tx.accept((ExecutionVisitor)execution2GraphVisitor);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Execution2GraphVisitor(@NonNull GraphStringBuilder s) {
        this.context = s;
    }

    protected void appendEdge(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode sourceNode, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode targetNode, @NonNull String color, @Nullable String style) {
        this.context.appendEdge(sourceNode, (GraphStringBuilder.GraphEdge)new ExecutionEdge(sourceNode, targetNode, color, style), targetNode);
    }

    protected @NonNull String getAssociationColor(@NonNull AssociationStatus associationStatus) {
        if (associationStatus.isIsInput()) {
            return associationStatus.isIsOutput() ? "#ccffff" : "#ccff00";
        }
        return associationStatus.isIsOutput() ? "#cc80ff" : "#cc0000";
    }

    protected @NonNull String getAssociationId(@NonNull AssociationStatus object) {
        String id = this.associationId.get(object);
        if (id == null) {
            id = "a" + this.associationId.size() + 1;
            this.associationId.put(object, id);
        }
        return id;
    }

    protected String getAssociationLabel(@NonNull AssociationStatus associationStatus) {
        EReference forwardReference = associationStatus.getForwardEReference();
        EReference oppositeReference = forwardReference.getEOpposite();
        String firstName = forwardReference.getName();
        String secondName = oppositeReference.getName();
        boolean swap = false;
        swap = forwardReference.isMany() != oppositeReference.isMany() ? forwardReference.isMany() : firstName.compareTo(secondName) > 0;
        return swap ? String.valueOf(secondName) + " / " + firstName : String.valueOf(firstName) + " / " + secondName;
    }

    protected @NonNull String getAttributeId(@NonNull AttributeStatus attributeStatus) {
        ClassStatus classStatus = attributeStatus.getOwningClassStatus();
        assert (classStatus != null);
        return String.valueOf(this.getClassId(classStatus)) + "-" + attributeStatus.getEFeature().getName();
    }

    protected @NonNull String getClassColor(@NonNull ClassStatus classStatus) {
        if (classStatus.isIsInput()) {
            return classStatus.isIsOutput() ? "#ccffff" : "#ccff00";
        }
        return classStatus.isIsOutput() ? "#cc80ff" : "#cc0000";
    }

    protected @NonNull String getClassId(@NonNull ClassStatus object) {
        String id = this.classId.get(object);
        if (id == null) {
            id = String.valueOf(object.getType().getName()) + "-" + (this.classId.size() + 1);
            this.classId.put(object, id);
        }
        return id;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getComputationNode(@NonNull Computation object) {
        GraphStringBuilder.GraphNode node = this.computation2node.get(object);
        if (node == null) {
            final String label = object.getName();
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("hexagon");
                    s.setColor("brown");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.computation2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getConnectionNode(@NonNull Connection object) {
        GraphStringBuilder.GraphNode node = this.connection2node.get(object);
        if (node == null) {
            final String label = object.getName();
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("ellipse");
                    s.setColor("blue");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.connection2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getExecutionNode(@NonNull Execution object) {
        if (object instanceof Computation) {
            return this.getComputationNode((Computation)object);
        }
        if (object instanceof Invocation) {
            return this.getInvocationNode((Invocation)object);
        }
        throw new UnsupportedOperationException();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getIntervalNode(@NonNull Interval object) {
        GraphStringBuilder.GraphNode node = this.interval2node.get(object);
        if (node == null) {
            final String label = "          " + object.getName() + "          ";
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("octagon");
                    s.setColor("black");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.interval2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getInvocationConstructorNode(@NonNull InvocationConstructor object) {
        GraphStringBuilder.GraphNode node = this.invocationConstructor2node.get(object);
        if (node == null) {
            final String label = object.getName();
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("hexagon");
                    s.setColor("brown");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.invocationConstructor2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getInvocationNode(@NonNull Invocation object) {
        GraphStringBuilder.GraphNode node = this.invocation2node.get(object);
        if (node == null) {
            final String label = object.getName();
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("hexagon");
                    s.setColor("orange");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.invocation2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getObjectNode(@NonNull Object object) {
        GraphStringBuilder.GraphNode node = this.object2node.get(object);
        if (node == null) {
            final String label = object instanceof EObject ? String.valueOf(((EObject)object).eClass().getName()) + "-" + (this.object2node.size() + 1) : object.toString().replace("@", "\n@");
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("rectangle");
                    s.setColor("blue");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.object2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected @NonNull String getPropertyId(@NonNull PropertyStatus object) {
        if (object instanceof AssociationStatus) {
            return this.getAssociationId((AssociationStatus)object);
        }
        if (object instanceof AttributeStatus) {
            return this.getAttributeId((AttributeStatus)object);
        }
        throw new UnsupportedOperationException();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getSlotNode(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SlotState.Incremental object) {
        GraphStringBuilder.GraphNode node;
        if (object.getValue() != null) {
            object = object.getPrimarySlotState();
        }
        if ((node = this.slot2node.get(object)) == null) {
            final EStructuralFeature eFeature = object.getEFeature();
            String label = eFeature.getName();
            if (eFeature instanceof EReference) {
                EReference eOpposite = ((EReference)eFeature).getEOpposite();
                if (eOpposite != null) {
                    label = String.valueOf(label) + " / " + eOpposite.getName();
                }
            } else if (eFeature instanceof EAttribute) {
                String stringValue;
                Object value = object.getValue();
                String string = stringValue = value != null ? value.toString() : "???";
                if (stringValue.length() > 20) {
                    stringValue = String.valueOf(stringValue.substring(0, 17)) + "...";
                }
                label = String.valueOf(label) + "  \n  " + stringValue;
            }
            final String finalLabel = label;
            node = new GraphStringBuilder.GraphNode(){

                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(finalLabel);
                    s.setShape("rectangle");
                    if (eFeature instanceof EAttribute) {
                        s.setStyle("rounded");
                    }
                    s.setColor("blue");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.slot2node.put((SlotState)object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    public @Nullable String visitComputation(@NonNull Computation object) {
        GraphStringBuilder.GraphNode computationNode = this.getComputationNode(object);
        return null;
    }

    public @Nullable Object visitConnection(@NonNull Connection object) {
        GraphStringBuilder.GraphNode connectionNode = this.getConnectionNode(object);
        if (object instanceof Connection.Incremental) {
            for (InvocationConstructor producer : ((Connection.Incremental)object).getAppenders()) {
                GraphStringBuilder.GraphNode producerNode = this.getInvocationConstructorNode(producer);
                this.appendEdge(producerNode, connectionNode, "brown", null);
            }
        }
        for (InvocationConstructor consumer : object.getConsumers()) {
            GraphStringBuilder.GraphNode consumerNode = this.getInvocationConstructorNode(consumer);
            this.appendEdge(connectionNode, consumerNode, "brown", null);
        }
        int iMax = object.getValues();
        int i = 0;
        while (i < iMax) {
            Object value = object.getValue(i);
            if (value != null) {
                GraphStringBuilder.GraphNode objectNode = this.getObjectNode(value);
                this.appendEdge(connectionNode, objectNode, "blue", "dotted");
            }
            ++i;
        }
        return null;
    }

    public @Nullable Object visitInterval(@NonNull Interval object) {
        GraphStringBuilder.GraphNode intervalNode = this.getIntervalNode(object);
        for (Connection connection : object.getConnections()) {
            connection.accept((ExecutionVisitor)this);
            GraphStringBuilder.GraphNode connectionNode = this.getConnectionNode(connection);
            this.appendEdge(connectionNode, intervalNode, "black", "dashed");
        }
        return null;
    }

    public @Nullable String visitInvocation(@NonNull Invocation object) {
        GraphStringBuilder.GraphNode invocationNode = this.getInvocationNode(object);
        if (object instanceof Invocation.Incremental) {
            Invocation.Incremental invocation = (Invocation.Incremental)object;
            int iMax = invocation.getBoundValues();
            int i = 0;
            while (i < iMax) {
                Object boundObject = invocation.getBoundValue(i);
                if (boundObject instanceof Connection) {
                    GraphStringBuilder.GraphNode connectionNode = this.getConnectionNode((Connection)boundObject);
                    this.appendEdge(invocationNode, connectionNode, "green", "dotted");
                } else {
                    GraphStringBuilder.GraphNode objectNode = this.getObjectNode(boundObject);
                    this.appendEdge(objectNode, invocationNode, "cyan", null);
                }
                ++i;
            }
        }
        return null;
    }

    public @Nullable Object visitInvocationConstructor(@NonNull InvocationConstructor object) {
        GraphStringBuilder.GraphNode invokerNode = this.getInvocationConstructorNode(object);
        GraphStringBuilder.GraphNode intervalNode = this.getIntervalNode(object.getInterval());
        this.appendEdge(invokerNode, intervalNode, "black", "dashed");
        for (Invocation invocation : object.debugGetInvocations()) {
            GraphStringBuilder.GraphNode invocationNode = this.getInvocationNode(invocation);
            this.appendEdge(invokerNode, invocationNode, "orange", "dotted");
        }
        return null;
    }

    public @Nullable String visitInvocationManager(@NonNull InvocationManager object) {
        GraphStringBuilder.GraphNode previousNode = null;
        for (InvocationConstructor invoker : object.getInvokers()) {
            invoker.accept((ExecutionVisitor)this);
        }
        for (Interval interval : object.getIntervals()) {
            interval.accept((ExecutionVisitor)this);
            GraphStringBuilder.GraphNode nextNode = this.getIntervalNode(interval);
            if (previousNode != null) {
                this.appendEdge(previousNode, nextNode, "black", null);
            }
            previousNode = nextNode;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable String visitObjectManager(@NonNull ObjectManager objectManager) {
        HashSet<@NonNull E> allExecutions = new HashSet();
        HashSet<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SlotState.Incremental> allSlots = new HashSet<SlotState.Incremental>();
        HashMap<@NonNull T, @NonNull ArrayList<@NonNull E>> object2slots = new HashMap();
        for (Object object : objectManager.getObjects()) {
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull SlotState.Incremental> objectSlots = new ArrayList<SlotState.Incremental>();
            for (SlotState slotState : objectManager.getSlotStates(object)) {
                if (!(slotState instanceof SlotState.Incremental)) continue;
                allSlots.add((SlotState.Incremental)slotState);
                objectSlots.add((SlotState.Incremental)slotState);
            }
            object2slots.put(object, objectSlots);
        }
        for (SlotState.Incremental slotState : allSlots) {
            Iterables.addAll(allExecutions, (Iterable)slotState.getSources());
            Iterables.addAll(allExecutions, (Iterable)slotState.getTargets());
            slotState.accept((ExecutionVisitor)this);
        }
        for (Execution.Incremental execution : allExecutions) {
            execution.accept((ExecutionVisitor)this);
            GraphStringBuilder.GraphNode invocationNode = this.getExecutionNode((Execution)execution);
            for (Object createdObject : execution.getCreatedObjects()) {
                GraphStringBuilder.GraphNode objectNode = this.getObjectNode(createdObject);
                this.appendEdge(invocationNode, objectNode, "green", null);
            }
        }
        for (SlotState.Incremental slotState : allSlots) {
            GraphStringBuilder.GraphNode slotNode = this.getSlotNode(slotState);
            slotState.accept((ExecutionVisitor)this);
            for (Invocation invocation : slotState.getSources()) {
                this.appendEdge(this.getInvocationNode(invocation), slotNode, "green", "dashed");
            }
            for (Invocation invocation : slotState.getTargets()) {
                this.appendEdge(slotNode, this.getExecutionNode((Execution)invocation), "cyan", "dashed");
            }
            Iterables.addAll(allExecutions, (Iterable)slotState.getTargets());
        }
        for (Object object : objectManager.getObjects()) {
            GraphStringBuilder.GraphNode objectNode = this.getObjectNode(object);
            @NonNull List slots = (List)object2slots.get(object);
            if (slots == null) continue;
            for (SlotState.Incremental slotState : slots) {
                GraphStringBuilder.GraphNode slotNode = this.getSlotNode(slotState);
                slotState.accept((ExecutionVisitor)this);
                this.appendEdge(objectNode, slotNode, "blue", "dashed");
            }
        }
        return null;
    }

    public @Nullable String visitSlotState(@NonNull SlotState object) {
        return null;
    }

    public @Nullable String visitTransformer(@NonNull Transformer transformer) {
        transformer.getInvocationManager().accept((ExecutionVisitor)this);
        transformer.getObjectManager().accept((ExecutionVisitor)this);
        return null;
    }

    protected static final class ExecutionEdge
    implements GraphStringBuilder.GraphEdge {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode sourceNode;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode targetNode;
        private final @NonNull String color;
        private final @Nullable String style;

        protected ExecutionEdge(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode sourceNode, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode targetNode, @NonNull String color, @Nullable String style) {
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.color = color;
            this.style = style;
        }

        public void appendEdgeAttributes(@NonNull GraphStringBuilder s, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode source, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode target) {
            s.setColor(this.color);
            if (this.style != null) {
                s.setStyle(this.style);
            }
            s.appendAttributedEdge(source, (GraphStringBuilder.GraphEdge)this, target);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode getEdgeSource() {
            return this.sourceNode;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode getEdgeTarget() {
            return this.targetNode;
        }
    }
}

