/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.providers.PHP5ElementContentProvider;

public class PHPUnitSearchEngine {
    public static int FIND_ELEMENT_CLASS = 4;
    public static int FIND_ELEMENT_PHPUNIT_CASE = 1;
    public static int FIND_ELEMENT_PHPUNIT_SUITE = 2;
    public static int FIND_OPTION_FIRST_ONLY = 16;
    public static final String CLASS_CASE = "PHPUnit_Framework_TestCase";
    public static final String CLASS_SUITE = "PHPUnit_Framework_TestSuite";
    public static final String PHPUNIT_BASE = "PHPUnit_Framework_Test";
    public static final String FUNCTION_SUITE = "suite";
    private Map<IType, Set<IType>> typeHierarchyCache = new HashMap<IType, Set<IType>>();
    private IScriptProject project;

    public PHPUnitSearchEngine(IScriptProject project) {
        this.project = project;
    }

    public List<IType> findTestCaseBaseClasses(IModelElement elementContainer, boolean listAbstract, IProgressMonitor monitor) {
        return this.findPHPUnitClassesBySupertype(elementContainer, this.getTestCase(), listAbstract, false, monitor);
    }

    public List<IType> findTestSuiteBaseClasses(IModelElement elementContainer, boolean listAbstract, IProgressMonitor monitor) {
        return this.findPHPUnitClassesBySupertype(elementContainer, this.getTestSuite(), listAbstract, false, monitor);
    }

    public List<IType> findTestCaseBaseClasses(IModelElement elementContainer, IType baseClass, boolean listAbstract, IProgressMonitor monitor) {
        return this.findPHPUnitClassesBySupertype(elementContainer, baseClass, listAbstract, false, monitor);
    }

    public List<IType> findAllTestCasesAndSuites(IModelElement element, boolean listAbstract, IProgressMonitor monitor) {
        Collection<Set<IType>> values;
        LinkedList<IType> result = new LinkedList<IType>();
        if (this.typeHierarchyCache.isEmpty()) {
            this.findPHPUnitClassesBySupertype(element, this.getTestCase(), listAbstract, false, monitor);
            this.findPHPUnitClassesBySupertype(element, this.getTestSuite(), listAbstract, false, monitor);
        }
        if ((values = this.typeHierarchyCache.values()) != null && !values.isEmpty()) {
            for (Set<IType> set : values) {
                result.addAll(set);
            }
        }
        return result;
    }

    public List<IType> findPHPUnitClassesByTestCase(IModelElement elementContainer, boolean listAbstract, boolean isFirst, IProgressMonitor monitor) {
        return this.findPHPUnitClassesBySupertype(elementContainer, this.getTestCase(), listAbstract, isFirst, monitor);
    }

    public List<IType> findPHPUnitClassesByTestSuite(IModelElement elementContainer, boolean listAbstract, boolean isFirst, IProgressMonitor monitor) {
        return this.findPHPUnitClassesBySupertype(elementContainer, this.getTestSuite(), listAbstract, isFirst, monitor);
    }

    public List<IType> findPHPUnitClassesBySupertype(IModelElement elementContainer, IType superClass, boolean listAbstract, boolean isFirst, IProgressMonitor monitor) {
        if (superClass == null || elementContainer == null) {
            return Collections.emptyList();
        }
        List<IType> subtypes = Collections.emptyList();
        IPath parentPath = elementContainer.getPath();
        LinkedList<IType> result = new LinkedList<IType>();
        try {
            IScriptProject scriptProject = elementContainer.getScriptProject();
            if (elementContainer != null && scriptProject.getProject().hasNature("org.eclipse.php.core.PHPNature")) {
                Set<IType> subClasses = null;
                try {
                    subClasses = this.typeHierarchyCache.get(superClass);
                    if (subClasses == null) {
                        IType baseClass = this.getByName(PHPUNIT_BASE);
                        ITypeHierarchy hierarchy = baseClass.newTypeHierarchy(scriptProject, monitor);
                        if (monitor != null && monitor.isCanceled()) {
                            return Collections.emptyList();
                        }
                        IType testCase = this.getTestCase();
                        IType[] caseSubtypes = hierarchy.getAllSubtypes(testCase);
                        IType testSuite = this.getTestSuite();
                        IType[] suiteSubtypes = hierarchy.getAllSubtypes(testSuite);
                        HashSet<IType> caseSubtypesSet = new HashSet<IType>();
                        IType[] iTypeArray = caseSubtypes;
                        int n = caseSubtypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            caseSubtypesSet.add(type);
                            ++n2;
                        }
                        this.typeHierarchyCache.put(testCase, caseSubtypesSet);
                        HashSet<IType> suiteSubtypesSet = new HashSet<IType>();
                        IType[] iTypeArray2 = suiteSubtypes;
                        int n3 = suiteSubtypes.length;
                        n = 0;
                        while (n < n3) {
                            IType type = iTypeArray2[n];
                            suiteSubtypesSet.add(type);
                            ++n;
                        }
                        this.typeHierarchyCache.put(testSuite, suiteSubtypesSet);
                    }
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)elementContainer);
                    subClasses = this.typeHierarchyCache.get(superClass);
                    block6: for (IType type : subClasses) {
                        int flags = type.getFlags();
                        if (!listAbstract && PHPFlags.isAbstract((int)flags)) continue;
                        if (parentPath.isPrefixOf(type.getPath())) {
                            result.add(type);
                            if (!isFirst) continue;
                            subtypes = result;
                            return subtypes;
                        }
                        IType element = type;
                        do {
                            if (!scope.encloses((IModelElement)element)) continue;
                            result.add(type);
                            continue block6;
                        } while ((element = element.getParent()) != null && element instanceof IModelElement && !(element instanceof Model));
                    }
                    if (listAbstract) {
                        result.add(superClass);
                    }
                    subtypes = result;
                }
                catch (ModelException e) {
                    PHPUnitPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
        }
        return subtypes;
    }

    public Set<IType> findTestCaseBaseClassesInWorkspace(IProgressMonitor monitor) {
        IProject[] projects;
        HashSet<IType> cache = new HashSet<IType>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                boolean hasNature = false;
                try {
                    hasNature = project.hasNature("org.eclipse.php.core.PHPNature");
                }
                catch (CoreException e) {
                    PHPUnitPlugin.log(e);
                }
                if (scriptProject != null && scriptProject.isOpen() && hasNature) {
                    List<IType> foundTestCases = this.findTestCaseBaseClasses((IModelElement)scriptProject, this.getTestCase(), false, monitor);
                    cache.addAll(foundTestCases);
                }
            }
            ++n2;
        }
        return cache;
    }

    public List<IType> findTestCases(IModelElement elementContainer, IProgressMonitor monitor) {
        return this.findTestCaseBaseClasses(elementContainer, this.getTestCase(), true, monitor);
    }

    public List<IType> findTestSuites(IModelElement elementContainer, IProgressMonitor monitor) {
        return this.findTestCaseBaseClasses(elementContainer, this.getTestSuite(), true, monitor);
    }

    public boolean hasCasesOrSuites(IModelElement element, IProgressMonitor monitor) {
        return !this.findPHPUnitClassesBySupertype(element, this.getTestCase(), false, true, monitor).isEmpty() || !this.findPHPUnitClassesBySupertype(element, this.getTestSuite(), false, true, monitor).isEmpty();
    }

    private void collectElements(Object parent, IProgressMonitor pm, Set<IType> result, int flags) {
        this.collectElementsRecursive(parent, pm, result, flags);
    }

    private boolean collectElementsRecursive(Object parent, IProgressMonitor pm, Set<IType> result, int flags) {
        IResource resource;
        if (parent instanceof Collection) {
            return this.collectFromObject(((Collection)parent).toArray(), pm, result, flags);
        }
        if (parent instanceof Object[]) {
            return this.collectFromObject((Object[])parent, pm, result, flags);
        }
        if (parent instanceof IModelElement) {
            return this.collectFromModelElement((IModelElement)parent, pm, result, flags);
        }
        if (parent instanceof IProject) {
            return this.collectFromProject((IProject)parent, pm, result, flags);
        }
        if (parent instanceof IContainer) {
            return this.collectFromContainer((IContainer)parent, pm, result, flags);
        }
        if (parent instanceof IFile) {
            return this.collectFromFile((IFile)parent, pm, result, flags);
        }
        if (parent instanceof IAdaptable && (resource = (IResource)((IAdaptable)parent).getAdapter(IResource.class)) != null && resource instanceof IFile) {
            return this.collectFromFile((IFile)resource, pm, result, flags);
        }
        return false;
    }

    private boolean collectFromModelElement(IModelElement parent, IProgressMonitor pm, Set<IType> result, int flags) {
        List<IType> findPHPUnitClassesBySupertype2;
        List<IType> findPHPUnitClassesBySupertype1;
        boolean isFirts = false;
        if ((flags & FIND_OPTION_FIRST_ONLY) > 0) {
            isFirts = true;
        }
        if ((flags & FIND_ELEMENT_PHPUNIT_CASE) > 0 && (findPHPUnitClassesBySupertype1 = this.findPHPUnitClassesBySupertype(parent, this.getTestCase(), false, isFirts, (IProgressMonitor)new SubProgressMonitor(pm, -1))) != null) {
            result.addAll(findPHPUnitClassesBySupertype1);
        }
        if ((flags & FIND_ELEMENT_PHPUNIT_SUITE) > 0 && (findPHPUnitClassesBySupertype2 = this.findPHPUnitClassesBySupertype(parent, this.getTestSuite(), false, isFirts, (IProgressMonitor)new SubProgressMonitor(pm, -1))) != null) {
            result.addAll(findPHPUnitClassesBySupertype2);
        }
        return false;
    }

    private boolean collectFromContainer(IContainer container, IProgressMonitor pm, Set<IType> result, int flags) {
        PHP5ElementContentProvider provider = new PHP5ElementContentProvider();
        return this.collectElementsRecursive(provider.getChildren(container), pm, result, flags);
    }

    private boolean collectFromFile(IFile file, IProgressMonitor pm, Set<IType> result, int flags) {
        return this.collectElementsRecursive(DLTKCore.create((IFile)file), pm, result, flags);
    }

    private boolean collectFromObject(Object[] items, IProgressMonitor pm, Set<IType> result, int flags) {
        if (items == null || items.length == 0) {
            return false;
        }
        int nItems = items.length;
        SubProgressMonitor ipm = new SubProgressMonitor(pm, 1);
        boolean r = false;
        int i = 0;
        while (i < nItems) {
            if ((flags & FIND_OPTION_FIRST_ONLY) > 0 && (r |= this.collectElementsRecursive(items[i], (IProgressMonitor)ipm, result, flags))) {
                return true;
            }
            ++i;
        }
        return r;
    }

    private boolean collectFromProject(IProject project, IProgressMonitor pm, Set<IType> result, int flags) {
        return this.collectElementsRecursive(DLTKCore.create((IProject)project), pm, result, flags);
    }

    private void doFindElements(Object[] parents, Set<IType> result, IProgressMonitor pm, int flags) {
        if (parents != null && parents.length > 0) {
            Object[] objectArray = parents;
            int n = parents.length;
            int n2 = 0;
            while (n2 < n) {
                Object parent = objectArray[n2];
                this.collectElements(parent, pm, result, flags);
                ++n2;
            }
        }
    }

    public IType[] findElements(Object[] parents, int flags, IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        HashSet<IType> result = new HashSet<IType>();
        if (parents != null && parents.length > 0) {
            this.doFindElements(parents, result, pm, flags);
        }
        return result.toArray(new IType[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSuiteMethod(IType classData) {
        if (classData == null) {
            return false;
        }
        try {
            IMethod[] functions = classData.getMethods();
            int i = 0;
            while (true) {
                if (i >= functions.length) {
                    return false;
                }
                IMethod function = functions[i];
                if (function.getElementName().compareToIgnoreCase(FUNCTION_SUITE) == 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            PHPUnitPlugin.log(e);
        }
        return false;
    }

    public boolean hasTestCaseClass() {
        return this.getTestCase() != null;
    }

    public boolean isCase(IType classData) {
        return this.isSubOf(classData, this.getTestCase());
    }

    public boolean isSuite(IType classData) {
        return this.isSubOf(classData, this.getTestSuite());
    }

    public boolean isTest(IType classData) {
        return this.isSuite(classData) || this.isCase(classData) || this.hasSuiteMethod(classData);
    }

    private IType getTestCase() {
        return this.getByName(CLASS_CASE);
    }

    private IType getTestSuite() {
        return this.getByName(CLASS_SUITE);
    }

    private IType getByName(String elementName) {
        if (elementName == null || elementName.length() == 0) {
            return null;
        }
        IType[] classes = PHPModelAccess.getDefault().findTypes(elementName, ISearchEngine.MatchRule.EXACT, 0, 0, SearchEngine.createSearchScope((IModelElement)this.project), null);
        if (classes != null && classes.length > 0) {
            return classes[0];
        }
        return null;
    }

    private boolean isSubOf(IType classData, IType superClass) {
        block5: {
            if (classData == null || superClass == null) {
                return false;
            }
            try {
                if (!Flags.isAbstract((int)classData.getFlags())) break block5;
                return false;
            }
            catch (ModelException e) {
                PHPUnitPlugin.log(e);
                return false;
            }
        }
        Set<IType> subclasses = this.typeHierarchyCache.get(superClass);
        if (subclasses == null) {
            this.findPHPUnitClassesBySupertype((IModelElement)this.project, superClass, true, false, null);
            subclasses = this.typeHierarchyCache.get(superClass);
        }
        return subclasses.contains(classData);
    }
}

