/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.ast.nodes.InLineHtml;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public final class ImportRewriteAnalyzer {
    private final ISourceModule sourceModule;
    private final List<NamespaceDeclaration> namespaces;
    private final Map<NamespaceDeclaration, ArrayList<PackageEntry>> packageEntries;
    private final Map<NamespaceDeclaration, List<String>> importsCreated;
    private final Map<NamespaceDeclaration, IRegion> replaceRange;
    private boolean filterImplicitImports;
    private Map<NamespaceDeclaration, Integer> flags = new HashMap<NamespaceDeclaration, Integer>();
    private final String indentationString;
    private static final int F_NEEDS_LEADING_DELIM = 2;
    private static final int F_NEEDS_TRAILING_DELIM = 4;

    public ImportRewriteAnalyzer(ISourceModule sourceModule, Program root, String[] importOrder, Map<NamespaceDeclaration, Boolean> restoreExistingImports) {
        this.sourceModule = sourceModule;
        this.indentationString = this.createIndentationString(1);
        this.filterImplicitImports = true;
        this.packageEntries = new HashMap<NamespaceDeclaration, ArrayList<PackageEntry>>();
        this.importsCreated = new HashMap<NamespaceDeclaration, List<String>>();
        this.replaceRange = new HashMap<NamespaceDeclaration, IRegion>();
        this.namespaces = root.getNamespaceDeclarations();
        if (this.namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : this.namespaces) {
                this.initialize(root, namespace, importOrder, restoreExistingImports);
            }
        } else {
            this.initialize(root, null, importOrder, restoreExistingImports);
        }
    }

    private String createIndentationString(int indentationUnits) {
        int tabs = indentationUnits;
        if (tabs == 0) {
            return "";
        }
        try {
            IStructuredDocument document = StructuredModelManager.getModelManager().getModelForRead((IFile)this.sourceModule.getResource()).getStructuredDocument();
            char indentationChar = FormatterUtils.getFormatterCommonPreferences().getIndentationChar((IDocument)document);
            int indentWidth = FormatterUtils.getFormatterCommonPreferences().getIndentationSize((IDocument)document);
            StringBuilder buffer = new StringBuilder(tabs * indentWidth);
            int i = 0;
            while (i < tabs * indentWidth) {
                buffer.append(indentationChar);
                ++i;
            }
            return buffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void initialize(Program root, NamespaceDeclaration namespace, String[] importOrder, Map<NamespaceDeclaration, Boolean> restoreExistingImports) {
        this.packageEntries.put(namespace, new ArrayList(20));
        this.importsCreated.put(namespace, new ArrayList());
        this.flags.put(namespace, 0);
        this.replaceRange.put(namespace, this.evaluateReplaceRange(root, namespace));
        if (restoreExistingImports.get(namespace).booleanValue()) {
            this.addExistingImports(root, namespace);
        }
        PackageEntry[] order = new PackageEntry[importOrder.length];
        int i = 0;
        while (i < order.length) {
            String curr = importOrder[i];
            order[i] = new PackageEntry(curr, curr);
            ++i;
        }
        this.addPreferenceOrderHolders(this.packageEntries.get(namespace), order);
    }

    private void addPreferenceOrderHolders(ArrayList<PackageEntry> packageEntries, PackageEntry[] preferenceOrder) {
        if (packageEntries.isEmpty()) {
            int i = 0;
            while (i < preferenceOrder.length) {
                packageEntries.add(preferenceOrder[i]);
                ++i;
            }
        } else {
            PackageEntry[] lastAssigned = new PackageEntry[preferenceOrder.length];
            int k = 0;
            while (k < packageEntries.size()) {
                PackageEntry entry = packageEntries.get(k);
                if (!entry.isComment()) {
                    String currName = entry.getName();
                    int currNameLen = currName.length();
                    int bestGroupIndex = -1;
                    int bestGroupLen = -1;
                    int i = 0;
                    while (i < preferenceOrder.length) {
                        String currPrefEntry = preferenceOrder[i].getName();
                        int currPrefLen = currPrefEntry.length();
                        if (!(!currName.startsWith(currPrefEntry) || currPrefLen < bestGroupLen || currPrefLen != currNameLen && currName.charAt(currPrefLen) != '\\' || bestGroupIndex != -1 && currPrefLen <= bestGroupLen)) {
                            bestGroupLen = currPrefLen;
                            bestGroupIndex = i;
                        }
                        ++i;
                    }
                    if (bestGroupIndex != -1) {
                        entry.setGroupID(preferenceOrder[bestGroupIndex].getName());
                        lastAssigned[bestGroupIndex] = entry;
                    }
                }
                ++k;
            }
            int currAppendIndex = 0;
            int i = 0;
            while (i < lastAssigned.length) {
                PackageEntry entry = lastAssigned[i];
                if (entry == null) {
                    PackageEntry newEntry = preferenceOrder[i];
                    if (currAppendIndex == 0) {
                        currAppendIndex = this.getIndexAfterStatics(packageEntries);
                    }
                    packageEntries.add(currAppendIndex, newEntry);
                    ++currAppendIndex;
                } else {
                    currAppendIndex = packageEntries.indexOf(entry) + 1;
                }
                ++i;
            }
        }
    }

    private static String getQualifier(String decl) {
        String namesapceName = PHPModelUtils.extractNameSpaceName(decl);
        if (namesapceName == null) {
            return "global namespace";
        }
        return namesapceName;
    }

    private static String getFullName(UseStatement decl) {
        if (decl.parts().get(0).getAlias() != null) {
            return decl.parts().get(0).getAlias().getName();
        }
        return decl.parts().get(0).getName().getName();
    }

    private void addExistingImports(Program root, NamespaceDeclaration namespace) {
        List<UseStatement> decls = root.getUseStatements(namespace);
        if (decls.isEmpty()) {
            return;
        }
        PackageEntry currPackage = null;
        UseStatement curr = decls.get(0);
        int currOffset = this.getUseStatementStart(namespace, curr);
        int currLength = curr.getLength();
        int currEndLine = root.getLineNumber(currOffset + currLength);
        int i = 1;
        while (i < decls.size()) {
            int statementType = curr.getStatementType();
            String name = ImportRewriteAnalyzer.getFullName(curr);
            String packName = ImportRewriteAnalyzer.getQualifier(name);
            if (currPackage == null || currPackage.compareTo(packName) != 0) {
                currPackage = new PackageEntry(packName, null);
                this.packageEntries.get(namespace).add(currPackage);
            }
            UseStatement next = decls.get(i);
            int nextOffset = this.getUseStatementStart(namespace, next);
            int nextLength = next.getLength();
            int nextOffsetLine = root.getLineNumber(nextOffset + 1);
            if (currEndLine < nextOffsetLine) {
                nextOffset = this.getPosition(root, ++currEndLine);
            }
            currPackage.add(new ImportDeclEntry(name, statementType, (IRegion)new Region(currOffset, nextOffset - currOffset)));
            currOffset = nextOffset;
            curr = next;
            if (currEndLine < nextOffsetLine) {
                nextOffset = this.getPosition(root, nextOffsetLine);
                currPackage = new PackageEntry();
                this.packageEntries.get(namespace).add(currPackage);
                currPackage.add(new ImportDeclEntry(null, statementType, (IRegion)new Region(currOffset, nextOffset - currOffset)));
                currOffset = nextOffset;
            }
            currEndLine = root.getLineNumber(nextOffset + nextLength);
            ++i;
        }
        int statementType = curr.getStatementType();
        String name = ImportRewriteAnalyzer.getFullName(curr);
        String packName = ImportRewriteAnalyzer.getQualifier(name);
        if (currPackage == null || currPackage.compareTo(packName) != 0) {
            currPackage = new PackageEntry(packName, null);
            this.packageEntries.get(namespace).add(currPackage);
        }
        int start = this.getUseStatementStart(namespace, curr);
        int length = this.replaceRange.get(namespace).getOffset() + this.replaceRange.get(namespace).getLength() - start;
        currPackage.add(new ImportDeclEntry(name, statementType, (IRegion)new Region(start, length)));
    }

    private int getUseStatementStart(NamespaceDeclaration namespace, UseStatement statement) {
        if (namespace != null && namespace.isBracketed()) {
            Program root = statement.getProgramRoot();
            return this.getPosition(root, root.getLineNumber(statement.getStart()));
        }
        return statement.getStart();
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.filterImplicitImports = filterImplicitImports;
    }

    static int getCommonPrefixLength(String s, String t) {
        int len = Math.min(s.length(), t.length());
        int i = 0;
        while (i < len) {
            if (s.charAt(i) != t.charAt(i)) {
                return i;
            }
            ++i;
        }
        return len;
    }

    static char getCharAt(String str, int index) {
        if (str.length() > index) {
            return str.charAt(index);
        }
        return '\u0000';
    }

    private PackageEntry findBestMatch(ArrayList<PackageEntry> packageEntries, String newName, int importType) {
        if (packageEntries.isEmpty()) {
            return null;
        }
        String groupId = null;
        int longestPrefix = -1;
        int i = 0;
        while (i < packageEntries.size()) {
            PackageEntry curr = packageEntries.get(i);
            String currGroup = curr.getGroupID();
            if (currGroup != null && newName.startsWith(currGroup)) {
                int prefixLen = currGroup.length();
                if (prefixLen == newName.length()) {
                    return curr;
                }
                if ((newName.charAt(prefixLen) == '\\' || prefixLen == 0) && prefixLen > longestPrefix) {
                    longestPrefix = prefixLen;
                    groupId = currGroup;
                }
            }
            ++i;
        }
        PackageEntry bestMatch = null;
        PackageMatcher matcher = new PackageMatcher();
        matcher.initialize(newName, "");
        int i2 = 0;
        while (i2 < packageEntries.size()) {
            PackageEntry curr = packageEntries.get(i2);
            if (!curr.isComment() && (groupId == null || groupId.equals(curr.getGroupID()))) {
                boolean preferrCurr;
                boolean bl = preferrCurr = bestMatch == null || curr.getNumberOfImports() > bestMatch.getNumberOfImports();
                if (matcher.isBetterMatch(curr.getName(), preferrCurr)) {
                    bestMatch = curr;
                }
            }
            ++i2;
        }
        return bestMatch;
    }

    private boolean isImplicitImport(NamespaceDeclaration namespace, String qualifier) {
        String packageName = namespace == null || namespace.getName() == null ? "global namespace" : namespace.getName().getName();
        return qualifier.equals(packageName);
    }

    public void addImport(NamespaceDeclaration namespace, String fullTypeName, int importType) {
        String typeContainerName = ImportRewriteAnalyzer.getQualifier(fullTypeName);
        ImportDeclEntry decl = new ImportDeclEntry(fullTypeName, importType, null);
        this.sortIn(this.packageEntries.get(namespace), typeContainerName, decl, importType);
    }

    public boolean removeImport(NamespaceDeclaration namespace, String qualifiedName) {
        String containerName = ImportRewriteAnalyzer.getQualifier(qualifiedName);
        int nPackages = this.packageEntries.get(namespace).size();
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = this.packageEntries.get(namespace).get(i);
            if (entry.compareTo(containerName) == 0 && entry.remove(qualifiedName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getIndexAfterStatics(ArrayList<PackageEntry> packageEntries) {
        return packageEntries.size();
    }

    private void sortIn(ArrayList<PackageEntry> packageEntries, String typeContainerName, ImportDeclEntry decl, int importType) {
        PackageEntry bestMatch = this.findBestMatch(packageEntries, typeContainerName, importType);
        if (bestMatch == null) {
            PackageEntry packEntry = new PackageEntry(typeContainerName, null);
            packEntry.add(decl);
            int insertPos = this.getIndexAfterStatics(packageEntries);
            packageEntries.add(insertPos, packEntry);
        } else {
            int cmp = typeContainerName.compareTo(bestMatch.getName());
            if (cmp == 0) {
                bestMatch.sortIn(decl);
            } else {
                String group = bestMatch.getGroupID();
                if (group != null && !typeContainerName.startsWith(group)) {
                    group = null;
                }
                PackageEntry packEntry = new PackageEntry(typeContainerName, group);
                packEntry.add(decl);
                int index = packageEntries.indexOf(bestMatch);
                if (cmp < 0) {
                    packageEntries.add(index, packEntry);
                } else {
                    packageEntries.add(index + 1, packEntry);
                }
            }
        }
    }

    private IRegion evaluateReplaceRange(Program root, NamespaceDeclaration namespace) {
        List<UseStatement> imports = root.getUseStatements(namespace);
        if (!imports.isEmpty()) {
            int nextLinePos;
            UseStatement first = imports.get(0);
            UseStatement last = imports.get(imports.size() - 1);
            int startPos = this.getUseStatementStart(namespace, first);
            int endPos = root.getExtendedStartPosition(last) + root.getExtendedLength(last);
            int endLine = root.getLineNumber(endPos);
            if (endLine > 0 && (nextLinePos = this.getPosition(root, endLine + 1)) >= 0) {
                int firstStatementPos = this.getFirstStatementBeginPos(root, namespace);
                endPos = firstStatementPos != -1 && firstStatementPos < nextLinePos ? firstStatementPos : nextLinePos;
            }
            return new Region(startPos, endPos - startPos);
        }
        int start = this.getNamespaceNameEndPos(root, namespace);
        return new Region(start, 0);
    }

    public MultiTextEdit getResultingEdits(IProgressMonitor monitor) throws ModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        MultiTextEdit resEdit = new MultiTextEdit();
        if (this.namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : this.namespaces) {
                this.getResultingEdits(namespace, resEdit, monitor);
            }
        } else {
            this.getResultingEdits(null, resEdit, monitor);
        }
        return resEdit;
    }

    private void getResultingEdits(NamespaceDeclaration namespace, MultiTextEdit resEdit, IProgressMonitor monitor) throws ModelException {
        try {
            int importsStart = this.replaceRange.get(namespace).getOffset();
            int importsLen = this.replaceRange.get(namespace).getLength();
            String lineDelim = ImportRewriteAnalyzer.getLineDelimiterUsed(this.sourceModule.getScriptProject());
            IBuffer buffer = this.sourceModule.getBuffer();
            int currPos = importsStart;
            if ((this.flags.get(namespace) & 2) != 0) {
                resEdit.addChild((TextEdit)new InsertEdit(currPos, lineDelim));
            }
            ArrayList<String> stringsToInsert = new ArrayList<String>();
            int nPackageEntries = this.packageEntries.get(namespace).size();
            int i = 0;
            while (i < nPackageEntries) {
                PackageEntry pack = this.packageEntries.get(namespace).get(i);
                int nImports = pack.getNumberOfImports();
                if (this.filterImplicitImports && this.isImplicitImport(namespace, pack.getName())) {
                    pack.removeAllNew();
                    nImports = pack.getNumberOfImports();
                }
                if (nImports != 0) {
                    int k = 0;
                    while (k < nImports) {
                        ImportDeclEntry currDecl = pack.getImportAt(k);
                        IRegion region = currDecl.getSourceRange();
                        if (region == null) {
                            String str = this.getNewImportString(namespace, currDecl.getElementName(), currDecl.getImportType(), lineDelim);
                            stringsToInsert.add(str);
                        } else {
                            int offset = region.getOffset();
                            this.removeAndInsertNew(buffer, currPos, offset, stringsToInsert, resEdit);
                            stringsToInsert.clear();
                            currPos = offset + region.getLength();
                        }
                        ++k;
                    }
                }
                ++i;
            }
            int end = importsStart + importsLen;
            this.removeAndInsertNew(buffer, currPos, end, stringsToInsert, resEdit);
            if (importsLen == 0) {
                if (!this.importsCreated.get(namespace).isEmpty()) {
                    if ((this.flags.get(namespace) & 4) != 0) {
                        resEdit.addChild((TextEdit)new InsertEdit(currPos, lineDelim));
                    }
                } else if (resEdit.getChildrenSize() > 0) {
                    resEdit.removeChild(resEdit.getChildrenSize() - 1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void removeAndInsertNew(IBuffer buffer, int contentOffset, int contentEnd, ArrayList<String> stringsToInsert, MultiTextEdit resEdit) {
        int pos = contentOffset;
        int i = 0;
        while (i < stringsToInsert.size()) {
            String curr = stringsToInsert.get(i);
            int idx = this.findInBuffer(buffer, curr, pos, contentEnd);
            if (idx != -1) {
                if (idx != pos) {
                    resEdit.addChild((TextEdit)new DeleteEdit(pos, idx - pos));
                }
                pos = idx + curr.length();
            } else {
                resEdit.addChild((TextEdit)new InsertEdit(pos, curr));
            }
            ++i;
        }
        if (pos < contentEnd) {
            resEdit.addChild((TextEdit)new DeleteEdit(pos, contentEnd - pos));
        }
    }

    private int findInBuffer(IBuffer buffer, String str, int start, int end) {
        int pos = start;
        int len = str.length();
        if (pos + len > end || str.length() == 0) {
            return -1;
        }
        char first = str.charAt(0);
        int step = str.indexOf(first, 1);
        if (step == -1) {
            step = len;
        }
        while (pos + len <= end) {
            if (buffer.getChar(pos) == first) {
                int k = 1;
                while (k < len && buffer.getChar(pos + k) == str.charAt(k)) {
                    ++k;
                }
                if (k == len) {
                    return pos;
                }
                if (k < step) {
                    pos += k;
                    continue;
                }
                pos += step;
                continue;
            }
            ++pos;
        }
        return -1;
    }

    private String getNewImportString(NamespaceDeclaration namespace, String importName, int importType, String lineDelim) {
        StringBuilder buf = new StringBuilder();
        if (namespace != null && namespace.isBracketed()) {
            buf.append(this.indentationString);
        }
        buf.append("use ");
        if (importType == 1) {
            buf.append("function ");
        } else if (importType == 2) {
            buf.append("const ");
        }
        buf.append(importName);
        buf.append(';');
        buf.append(lineDelim);
        this.importsCreated.get(namespace).add(importName);
        return buf.toString();
    }

    private int getFirstStatementBeginPos(Program root, NamespaceDeclaration namespace) {
        List<Statement> statements = namespace == null ? root.statements() : namespace.getBody().statements();
        if (!statements.isEmpty()) {
            Statement node = null;
            boolean isAfterUseStatements = false;
            if (root.getUseStatements(namespace).size() == 0) {
                isAfterUseStatements = true;
            }
            for (Statement s : statements) {
                if (s instanceof UseStatement || s instanceof InLineHtml) {
                    isAfterUseStatements = true;
                    continue;
                }
                if (!isAfterUseStatements) continue;
                node = s;
                break;
            }
            if (node != null) {
                return root.getExtendedStartPosition(node);
            }
        }
        return -1;
    }

    private int getNamespaceNameEndPos(Program root, NamespaceDeclaration namespace) {
        int flags = this.flags.get(namespace);
        if (namespace != null) {
            int offset = namespace.getBody().getStart() + 1;
            int afterPackageStatementPos = -1;
            int lineNumber = root.getLineNumber(offset);
            if (lineNumber >= 0) {
                int lineAfterPackage = lineNumber + 1;
                afterPackageStatementPos = this.getPosition(root, lineAfterPackage);
            }
            if (afterPackageStatementPos < 0) {
                this.flags.put(namespace, flags |= 2);
                return offset;
            }
            int firstStatementPos = this.getFirstStatementBeginPos(root, namespace);
            if (firstStatementPos != -1 && firstStatementPos <= afterPackageStatementPos && firstStatementPos <= afterPackageStatementPos) {
                flags |= 4;
                if (firstStatementPos == afterPackageStatementPos) {
                    flags |= 2;
                }
                this.flags.put(namespace, flags);
                return firstStatementPos;
            }
            this.flags.put(namespace, flags |= 2);
            return afterPackageStatementPos;
        }
        this.flags.put(namespace, flags |= 4);
        return this.getFirstStatementBeginPos(root, null);
    }

    private int getPosition(Program root, int line) {
        return this.getPosition(root, line, 0);
    }

    private int getPosition(Program root, int line, int column) {
        return root.getPosition(line, column) - 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n-----------------------\n");
        if (this.namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : this.namespaces) {
                int nPackages = this.packageEntries.get(namespace).size();
                int i = 0;
                while (i < nPackages) {
                    PackageEntry entry = this.packageEntries.get(namespace).get(i);
                    buf.append(entry.toString());
                    ++i;
                }
            }
        } else {
            int nPackages = this.packageEntries.get(null).size();
            int i = 0;
            while (i < nPackages) {
                PackageEntry entry = this.packageEntries.get(null).get(i);
                buf.append(entry.toString());
                ++i;
            }
        }
        return buf.toString();
    }

    public String[] getCreatedImports() {
        ArrayList imports = new ArrayList();
        if (this.namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : this.namespaces) {
                imports.addAll(this.importsCreated.get(namespace));
            }
        } else {
            imports.addAll(this.importsCreated.get(null));
        }
        return imports.toArray(new String[imports.size()]);
    }

    private static String getLineDelimiterUsed(IScriptProject project) {
        return ImportRewriteAnalyzer.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IScriptProject project) {
        if (project == null) {
            assert (false);
            return null;
        }
        String lineDelimiter = ImportRewriteAnalyzer.getLineDelimiterPreference(project);
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    private static String getLineDelimiterPreference(IScriptProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    private static final class ImportDeclEntry {
        private String elementName;
        private boolean isAlias;
        private int importType;
        private IRegion sourceRange;

        public ImportDeclEntry(String elementName, int importType, IRegion sourceRange) {
            this.elementName = elementName;
            this.importType = importType;
            if (elementName != null && elementName.toLowerCase().contains(" as ")) {
                this.isAlias = true;
            }
            this.sourceRange = sourceRange;
        }

        public String getElementName() {
            return this.elementName;
        }

        public int compareTo(String fullName) {
            return this.elementName.compareTo(fullName);
        }

        public String getSimpleName() {
            return PHPModelUtils.extractElementName(this.elementName);
        }

        public boolean isNew() {
            return this.sourceRange == null;
        }

        public boolean isComment() {
            return this.elementName == null;
        }

        public boolean isAlias() {
            return this.isAlias;
        }

        public IRegion getSourceRange() {
            return this.sourceRange;
        }

        public int getImportType() {
            return this.importType;
        }
    }

    private static final class PackageEntry {
        private String name;
        private ArrayList<ImportDeclEntry> importEntries;
        private String group;

        public PackageEntry() {
            this("!", null);
        }

        public PackageEntry(String name, String group) {
            this.name = name;
            this.importEntries = new ArrayList(5);
            this.group = group;
        }

        public int compareTo(String otherName) {
            return this.name.compareTo(otherName);
        }

        public void sortIn(ImportDeclEntry imp) {
            String fullImportName = imp.getElementName();
            int insertPosition = -1;
            int nInports = this.importEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment()) {
                    int cmp = curr.compareTo(fullImportName);
                    if (cmp == 0) {
                        return;
                    }
                    if (cmp > 0 && insertPosition == -1) {
                        insertPosition = i;
                    }
                }
                ++i;
            }
            if (insertPosition == -1) {
                this.importEntries.add(imp);
            } else {
                this.importEntries.add(insertPosition, imp);
            }
        }

        public void add(ImportDeclEntry imp) {
            this.importEntries.add(imp);
        }

        public boolean remove(String fullName) {
            int nInports = this.importEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment() && curr.compareTo(fullName) == 0) {
                    this.importEntries.remove(i);
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void removeAllNew() {
            int nInports = this.importEntries.size();
            int i = nInports - 1;
            while (i >= 0) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isAlias() && curr.isNew()) {
                    this.importEntries.remove(i);
                }
                --i;
            }
        }

        public ImportDeclEntry getImportAt(int index) {
            return this.importEntries.get(index);
        }

        public int getNumberOfImports() {
            return this.importEntries.size();
        }

        public String getName() {
            return this.name;
        }

        public String getGroupID() {
            return this.group;
        }

        public void setGroupID(String groupID) {
            this.group = groupID;
        }

        public boolean isComment() {
            return "!".equals(this.name);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.isComment()) {
                buf.append("comment\n");
            } else {
                buf.append(this.name);
                buf.append(", groupId: ");
                buf.append(this.group);
                buf.append("\n");
                int nImports = this.getNumberOfImports();
                int i = 0;
                while (i < nImports) {
                    ImportDeclEntry curr = this.getImportAt(i);
                    buf.append("  ");
                    buf.append(curr.getSimpleName());
                    if (curr.isNew()) {
                        buf.append(" (new)");
                    }
                    buf.append("\n");
                    ++i;
                }
            }
            return buf.toString();
        }
    }

    private static class PackageMatcher {
        private String newName;
        private String bestName;
        private int bestMatchLen;

        public void initialize(String newImportName, String bestImportName) {
            this.newName = newImportName;
            this.bestName = bestImportName;
            this.bestMatchLen = ImportRewriteAnalyzer.getCommonPrefixLength(bestImportName, newImportName);
        }

        public boolean isBetterMatch(String currName, boolean preferCurr) {
            boolean isBetter;
            int currMatchLen = ImportRewriteAnalyzer.getCommonPrefixLength(currName, this.newName);
            int matchDiff = currMatchLen - this.bestMatchLen;
            if (matchDiff == 0) {
                isBetter = currMatchLen == this.newName.length() && currMatchLen == currName.length() && currMatchLen == this.bestName.length() ? preferCurr : this.sameMatchLenTest(currName);
            } else {
                boolean bl = isBetter = matchDiff > 0;
            }
            if (isBetter) {
                this.bestName = currName;
                this.bestMatchLen = currMatchLen;
            }
            return isBetter;
        }

        private boolean sameMatchLenTest(String currName) {
            int matchLen = this.bestMatchLen;
            char newChar = ImportRewriteAnalyzer.getCharAt(this.newName, matchLen);
            char currChar = ImportRewriteAnalyzer.getCharAt(currName, matchLen);
            char bestChar = ImportRewriteAnalyzer.getCharAt(this.bestName, matchLen);
            if (newChar < currChar) {
                if (bestChar < newChar) {
                    return currChar - newChar < newChar - bestChar;
                }
                if (currChar == bestChar) {
                    return false;
                }
                return currChar < bestChar;
            }
            if (bestChar > newChar) {
                return newChar - currChar < bestChar - newChar;
            }
            if (currChar == bestChar) {
                return true;
            }
            return currChar > bestChar;
        }
    }
}

