/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ZipArchiveFile;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phar.PharArchiveFile;
import org.eclipse.php.internal.core.phar.PharException;
import org.eclipse.php.internal.core.tar.TarArchiveFile;
import org.eclipse.php.internal.core.tar.TarException;

public class PHPToolkitUtil {
    public static final String PHAR_EXTENSTION = "phar";
    public static final String TAR_EXTENSTION = "tar";
    public static final String BZ2_EXTENSTION = "bz2";
    public static final String GZ_EXTENSTION = "gz";
    public static final String ZIP_EXTENSTION = "zip";
    public static final String[] PHAR_EXTENSTIONS = new String[]{"phar", "tar", "bz2", "gz", "zip"};

    public static boolean isPHPElement(IModelElement modelElement) {
        Assert.isNotNull((Object)modelElement);
        IModelElement sourceModule = modelElement.getAncestor(5);
        if (sourceModule != null) {
            return PHPToolkitUtil.isPHPFile((ISourceModule)sourceModule);
        }
        return false;
    }

    public static boolean isPHPFile(ISourceModule sourceModule) {
        block4: {
            IResource resource;
            block5: {
                try {
                    resource = sourceModule.getCorrespondingResource();
                    if (!(resource instanceof IFile)) break block4;
                    if (!PHPToolkitUtil.isPhar(resource)) break block5;
                    return true;
                }
                catch (CoreException coreException) {}
            }
            IContentDescription contentDescription = ((IFile)resource).getContentDescription();
            if (contentDescription != null) {
                return ContentTypeIdForPHP.ContentTypeID_PHP.equals(contentDescription.getContentType().getId());
            }
        }
        return PHPToolkitUtil.hasPHPExtention(sourceModule.getElementName());
    }

    public static boolean isPHPFile(IFile file) {
        IContentDescription contentDescription = null;
        if (!file.exists()) {
            return PHPToolkitUtil.hasPHPExtention(file);
        }
        try {
            contentDescription = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return PHPToolkitUtil.hasPHPExtention(file);
        }
        if (contentDescription == null) {
            return PHPToolkitUtil.hasPHPExtention(file);
        }
        return ContentTypeIdForPHP.ContentTypeID_PHP.equals(contentDescription.getContentType().getId());
    }

    public static boolean isPhar(IResource resource) {
        if (resource instanceof IFile) {
            return PHPToolkitUtil.isPharExtention(((IFile)resource).getFileExtension());
        }
        return false;
    }

    public static boolean isPharExtention(String extension) {
        int i = 0;
        while (i < PHAR_EXTENSTIONS.length) {
            if (PHAR_EXTENSTIONS[i].equals(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPharFileName(String fileName) {
        String extension = PHPToolkitUtil.getExtention(fileName);
        return extension != null && PHPToolkitUtil.isPharExtention(extension);
    }

    public static boolean hasPHPExtention(IFile file) {
        String[] validExtensions;
        String fileName = file.getName();
        String extension = PHPToolkitUtil.getExtention(fileName);
        if (extension == null) {
            return false;
        }
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = validExtensions = type.getFileSpecs(8);
        int n = validExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String validExtension = stringArray[n2];
            if (extension.equalsIgnoreCase(validExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String getExtention(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index + 1);
    }

    public static boolean hasPHPExtention(String fileName) {
        String[] validExtensions;
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = fileName.substring(index + 1);
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = validExtensions = type.getFileSpecs(8);
        int n = validExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String validExtension = stringArray[n2];
            if (extension.equalsIgnoreCase(validExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isFromPHPProject(IModelElement element) {
        IProject project = element != null && element.getScriptProject() != null ? element.getScriptProject().getProject() : null;
        try {
            return PHPToolkitUtil.isPHPProject(project);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isPHPProject(IProject project) throws CoreException {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        IProjectNature nature = project.getNature("org.eclipse.php.core.PHPNature");
        return nature != null;
    }

    public static final ISourceModule getSourceModule(Object element) {
        if (element instanceof IFile) {
            return (ISourceModule)DLTKCore.create((IFile)((IFile)element));
        }
        if (element instanceof IModelElement) {
            return PHPToolkitUtil.getSourceModule((IModelElement)element);
        }
        if (element instanceof String) {
            return PHPToolkitUtil.getSourceModule((String)element);
        }
        return null;
    }

    public static ISourceModule getSourceModule(IModelElement element) {
        if (element.getElementType() == 5) {
            return (ISourceModule)element;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getSourceModule();
        }
        return null;
    }

    public static ISourceModule getSourceModule(String element) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(element));
        if (file != null) {
            return (ISourceModule)DLTKCore.create((IFile)file);
        }
        return null;
    }

    public static IArchive getArchive(File localFile) throws IOException {
        String extension = PHPToolkitUtil.getExtension(localFile);
        if (PHPToolkitUtil.isPharExtention(extension)) {
            Object archive = null;
            try {
                if (PHAR_EXTENSTION.equals(extension)) {
                    archive = new PharArchiveFile(localFile);
                } else if (ZIP_EXTENSTION.equals(extension)) {
                    archive = new ZipArchiveFile(localFile);
                } else if (TAR_EXTENSTION.equals(extension) || GZ_EXTENSTION.equals(extension) || BZ2_EXTENSTION.equals(extension)) {
                    archive = new TarArchiveFile(localFile);
                }
            }
            catch (PharException e) {
                throw new IOException(e.getMessage());
            }
            catch (TarException e) {
                throw new IOException(e.getMessage());
            }
            return archive;
        }
        return null;
    }

    private static String getExtension(File localFile) {
        if (localFile.isFile()) {
            int index = localFile.getName().lastIndexOf(46);
            if (localFile.getName().length() > index + 1) {
                return localFile.getName().substring(index + 1);
            }
        }
        return null;
    }
}

