/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.ProgressUtil;
import org.eclipse.php.internal.server.core.builtin.Trace;

public class FileUtil {
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];

    private FileUtil() {
    }

    public static void copyDirectory(String from, String to, IProgressMonitor monitor) {
        try {
            File fromDir = new File(from);
            File toDir = new File(to);
            File[] files = fromDir.listFiles();
            toDir.mkdir();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{from, to}), size * 50);
            int i = 0;
            while (i < size) {
                File current = files[i];
                String fromFile = current.getAbsolutePath();
                String toFile = to;
                if (!toFile.endsWith(File.separator)) {
                    toFile = String.valueOf(toFile) + File.separator;
                }
                toFile = String.valueOf(toFile) + current.getName();
                if (current.isFile()) {
                    FileUtil.copyFile(fromFile, toFile);
                    monitor.worked(50);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{fromFile, toFile}));
                    FileUtil.copyDirectory(fromFile, toFile, ProgressUtil.getSubMonitorFor(monitor, 50));
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error copying directory", e);
        }
    }

    public static IStatus copyFile(InputStream in, String to) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            int avail = in.read(buf);
            while (avail > 0) {
                ((OutputStream)out).write(buf, 0, avail);
                avail = in.read(buf);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error copying file", e);
            Status status = new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
            return status;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static IStatus copyFile(String from, String to) {
        try {
            return FileUtil.copyFile(new FileInputStream(from), to);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error copying file", e);
            return new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    public static IStatus copyFile(URL from, String to) {
        try {
            return FileUtil.copyFile(from.openStream(), to);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error copying file", e);
            return new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
        }
    }
}

