/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.adapters;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.uml.tools.adapters.DerivedAttributeAdapter;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class PortTypeAdapter
extends AdapterImpl {
    private Adapter adapter = null;
    private Port port = null;
    private EStructuralFeature derivedFeature = null;
    private EStructuralFeature navigationFeature = null;

    public PortTypeAdapter(Port port, EStructuralFeature volatileFeature, EStructuralFeature navigationFeature) {
        this.port = port;
        this.derivedFeature = volatileFeature;
        this.navigationFeature = navigationFeature;
        if (port.getType() != null) {
            this.attachAdapter(null, port.getType());
        }
    }

    public void notifyChanged(Notification msg) {
        Object notificationFeature = msg.getFeature();
        if (notificationFeature != null && notificationFeature.equals(UMLPackage.Literals.TYPED_ELEMENT__TYPE)) {
            switch (msg.getEventType()) {
                case 1: {
                    Type newType = (Type)msg.getNewValue();
                    if (newType != null) {
                        this.attachAdapter((Type)msg.getOldValue(), newType);
                        this.updateObservableList();
                        break;
                    }
                    this.detachAdapter((Type)msg.getOldValue());
                    this.updateObservableList();
                    break;
                }
            }
        }
    }

    private void detachAdapter(Type type) {
        if (type == null) {
            return;
        }
        EObject source = this.determineSource(type);
        source.eAdapters().remove((Object)this.adapter);
    }

    private void attachAdapter(Type oldType, Type newType) {
        EObject newSource = this.determineSource(newType);
        if (newSource != null) {
            EObject oldSource;
            if (oldType != null && this.adapter != null && !(oldSource = this.determineSource(oldType)).equals(newSource)) {
                oldSource.eAdapters().remove((Object)this.adapter);
            }
            if (this.adapter == null || !newSource.eAdapters().contains((Object)this.adapter)) {
                this.adapter = new DerivedAttributeAdapter(newSource, this.derivedFeature, this.navigationFeature, (EStructuralFeature)UMLPackage.Literals.DEPENDENCY__SUPPLIER, 3){

                    @Override
                    protected void notifyDerivedAttributeChange(Notification notification) {
                        if (UMLPackage.Literals.DEPENDENCY__SUPPLIER.equals(notification.getFeature())) {
                            PortTypeAdapter.this.port.eNotify((Notification)new ENotificationImpl((InternalEObject)PortTypeAdapter.this.port, notification.getEventType(), PortTypeAdapter.this.derivedFeature, notification.getOldValue(), notification.getNewValue()));
                        } else if (4 == notification.getEventType()) {
                            PortTypeAdapter.this.port.eNotify((Notification)new ENotificationImpl((InternalEObject)PortTypeAdapter.this.port, notification.getEventType(), PortTypeAdapter.this.derivedFeature, notification.getOldValue(), notification.getNewValue()));
                        }
                    }
                };
            }
        }
    }

    private EObject determineSource(Type type) {
        Type source = type;
        if (UMLPackage.Literals.PORT__REQUIRED.equals(this.derivedFeature)) {
            source = type.eContainer();
        }
        return source;
    }

    private void updateObservableList() {
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)this.port);
        if (cache != null) {
            cache.put((EObject)this.port, (Object)this.derivedFeature, null);
        }
        this.port.eNotify((Notification)new ENotificationImpl((InternalEObject)this.port, 1, this.derivedFeature, null, this.port.eGet(this.derivedFeature), true));
    }
}

