/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConsiderIgnoreFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionOperatorKind;

public class CCombinedFragmentEditPart
extends CombinedFragmentEditPart {
    public static int DEFAULT_HEIGHT = 60;
    public static int DEFAULT_WIDTH = 40;

    public CCombinedFragmentEditPart(View view) {
        super(view);
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        this.getPrimaryShape().setName(((CombinedFragment)this.resolveSemanticElement()).getInteractionOperator().getLiteral());
    }

    public boolean isCoregion() {
        boolean coregion = false;
        Element umlElement = this.getUMLElement();
        if (umlElement instanceof CombinedFragment && !(umlElement instanceof ConsiderIgnoreFragment)) {
            InteractionOperatorKind interactionOperator = ((CombinedFragment)umlElement).getInteractionOperator();
            if (InteractionOperatorKind.PAR_LITERAL.getLiteral() == interactionOperator.getLiteral() && ((CombinedFragment)umlElement).getCovereds().size() == 1) {
                coregion = true;
            }
        }
        return coregion;
    }

    public void refresh() {
        this.getPrimaryShape().setCoregion(this.isCoregion());
        super.refresh();
    }

    public void showTargetFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest;
        if (request instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)request).getEditParts().get(0) instanceof LifelineEditPart) {
            changeBoundsRequest.setMoveDelta(new Point(changeBoundsRequest.getMoveDelta().x, 0));
        }
        super.showTargetFeedback(request);
    }
}

