/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.IMultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WrappedLabelProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.widgets.Composite;

public class MultipleReferenceEditor
extends MultipleValueEditor<ReferenceSelector>
implements IMultipleReferenceEditor {
    protected IStaticContentProvider contentProvider;

    public MultipleReferenceEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, style, new ReferenceSelector(unique), ordered, unique, label);
        this.setProviders(EmptyContentProvider.instance, new WrappedLabelProvider());
    }

    public MultipleReferenceEditor(Composite parent, int style, String label) {
        this(parent, style, false, false, label);
    }

    public MultipleReferenceEditor(Composite parent, int style) {
        this(parent, style, false, false, (String)null);
    }

    @Override
    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        Assert.isNotNull((Object)contentProvider, (String)"The content provider should be defined");
        this.contentProvider = contentProvider;
        if (this.selector instanceof ReferenceSelector) {
            ((ReferenceSelector)this.selector).setContentProvider(contentProvider);
        }
        if (labelProvider != null) {
            ((ReferenceSelector)this.selector).setLabelProvider(labelProvider);
            super.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    @Override
    public void setUnique(boolean unique) {
        ((ReferenceSelector)this.selector).setUnique(unique);
        super.setUnique(unique);
    }
}

