/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.pluginexplorer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.infra.core.pluginexplorer.Plugin;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalFile
implements PluginEntry {
    private static final List<PluginEntry> empty = new ArrayList<PluginEntry>(0);
    private Plugin plugin;
    private File file;
    private List<PluginEntry> cache;

    public PhysicalFile(Plugin plugin, File file) {
        this.plugin = plugin;
        this.file = file;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getLogicalPath() {
        Path pp = new Path(this.plugin.getPhysicalPath());
        Path physical = new Path(this.file.getAbsolutePath());
        return "platform:/plugin/" + this.plugin.getName() + "/" + physical.makeRelativeTo((IPath)pp).toString();
    }

    @Override
    public String getPhysicalPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean hasChildren() {
        if (this.file.isDirectory()) {
            File[] content = this.file.listFiles();
            return content != null && content.length > 0;
        }
        return false;
    }

    @Override
    public List<PluginEntry> children() {
        if (this.cache != null) {
            return this.cache;
        }
        if (!this.file.isDirectory()) {
            this.cache = empty;
            return empty;
        }
        this.buildCache();
        return this.cache;
    }

    @Override
    public PluginEntry getChild(String name) {
        if (this.cache == null) {
            this.buildCache();
        }
        for (PluginEntry entry : this.cache) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private void buildCache() {
        File[] content = this.file.listFiles();
        if (content == null || content.length == 0) {
            this.cache = empty;
        } else {
            this.cache = new ArrayList<PluginEntry>(content.length);
            int i = 0;
            while (i != content.length) {
                this.cache.add(new PhysicalFile(this.plugin, content[i]));
                ++i;
            }
        }
    }
}

