/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class PrecedenceManager {
    public static @NonNull Precedence NULL_PRECEDENCE = PivotFactory.eINSTANCE.createPrecedence();
    public static @NonNull Precedence NAVIGATION_PRECEDENCE = PivotFactory.eINSTANCE.createPrecedence();
    public static @NonNull Precedence LEAF_PRECEDENCE = PivotFactory.eINSTANCE.createPrecedence();
    private Map<@NonNull String, @NonNull List<Precedence>> nameToPrecedencesMap = null;
    private Map<@NonNull String, String> infixToPrecedenceNameMap = null;
    private Map<@NonNull String, @NonNull String> prefixToPrecedenceNameMap = null;

    static {
        NULL_PRECEDENCE.setName("NULL");
        NULL_PRECEDENCE.setOrder(0x3FFFFFFF);
        NAVIGATION_PRECEDENCE.setName("NAVIGATION");
        NAVIGATION_PRECEDENCE.setOrder(-1);
        LEAF_PRECEDENCE.setName("LEAF");
        LEAF_PRECEDENCE.setOrder(-2);
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull List<@NonNull String> compilePrecedences(@NonNull Iterable<@NonNull ? extends Library> libraries) {
        void var4_7;
        List<Precedence> precedences;
        ArrayList<@NonNull String> errors = new ArrayList<String>();
        ArrayList<@NonNull String> orderedPrecedences = new ArrayList<String>();
        this.nameToPrecedencesMap = new HashMap<String, List<Precedence>>();
        this.infixToPrecedenceNameMap = new HashMap<String, String>();
        this.prefixToPrecedenceNameMap = new HashMap<String, String>();
        for (Library library : libraries) {
            precedences = ClassUtil.nullFree(library.getOwnedPrecedences());
            if (precedences.size() <= 0) continue;
            this.compilePrecedencePackage(errors, library);
            int prevIndex = -1;
            List<Precedence> list = null;
            String name = null;
            for (Precedence precedence : precedences) {
                name = precedence.getName();
                assert (name != null);
                int index = orderedPrecedences.indexOf(name);
                if (index < 0) {
                    index = prevIndex < 0 ? orderedPrecedences.size() : prevIndex + 1;
                    orderedPrecedences.add(index, name);
                    list = new ArrayList<Precedence>();
                    this.nameToPrecedencesMap.put(name, list);
                } else {
                    list = this.nameToPrecedencesMap.get(name);
                    assert (list != null);
                    if (index <= prevIndex) {
                        errors.add("Inconsistent precedence ordering for '" + name + "'");
                    } else if (prevIndex >= 0 && index != prevIndex + 1) {
                        errors.add("Ambiguous precedence ordering for '" + name + "'");
                    }
                    if (precedence.getAssociativity() != list.get(0).getAssociativity()) {
                        errors.add("Inconsistent precedence associativity for '" + name + "'");
                    }
                }
                prevIndex = index;
                list.add(precedence);
            }
            if (list == null || list.size() != 1 || prevIndex == orderedPrecedences.size() - 1) continue;
            errors.add("Ambiguous precedence ordering for '" + name + "' at tail");
        }
        boolean bl = false;
        while (var4_7 < orderedPrecedences.size()) {
            String name = (String)orderedPrecedences.get((int)var4_7);
            precedences = this.nameToPrecedencesMap.get(name);
            assert (precedences != null);
            for (Precedence precedence : precedences) {
                precedence.setOrder((int)var4_7);
            }
            ++var4_7;
        }
        return errors;
    }

    protected void compilePrecedenceOperation(@NonNull List<@NonNull String> errors, @NonNull Operation operation) {
        Precedence precedence = operation.getPrecedence();
        if (precedence != null) {
            List<@NonNull Parameter> parameters = ClassUtil.nullFree(operation.getOwnedParameters());
            if (parameters.size() == 0) {
                String newName = precedence.getName();
                String operatorName = operation.getName();
                assert (newName != null && operatorName != null);
                String oldName = this.prefixToPrecedenceNameMap.put(operatorName, newName);
                if (oldName != null && !oldName.equals(newName)) {
                    errors.add("Conflicting precedences for prefix operation '" + operatorName + "'");
                }
            } else if (parameters.size() == 1) {
                String newName = precedence.getName();
                String operatorName = operation.getName();
                assert (newName != null && operatorName != null);
                String oldName = this.infixToPrecedenceNameMap.put(operatorName, newName);
                if (oldName != null && !oldName.equals(newName)) {
                    errors.add("Conflicting precedences for infix operation '" + operatorName + "'");
                }
            }
        }
    }

    protected void compilePrecedencePackage(@NonNull List<@NonNull String> errors, @NonNull Library library) {
        for (Class type : library.getOwnedClasses()) {
            if (type == null || PivotUtilInternal.isOrphanType(type)) continue;
            this.compilePrecedenceType(errors, type);
        }
    }

    protected void compilePrecedenceType(@NonNull List<String> errors, @NonNull Class pivotType) {
        for (Operation operation : pivotType.getOwnedOperations()) {
            if (operation == null) continue;
            this.compilePrecedenceOperation(errors, operation);
        }
    }

    public void dispose() {
        this.nameToPrecedencesMap = null;
        this.infixToPrecedenceNameMap = null;
        this.prefixToPrecedenceNameMap = null;
    }

    public @Nullable Precedence getInfixPrecedence(@NonNull String operatorName) {
        String precedenceName = this.infixToPrecedenceNameMap.get(operatorName);
        if (precedenceName == null) {
            return null;
        }
        List<Precedence> precedences = this.nameToPrecedencesMap.get(precedenceName);
        if (precedences == null) {
            return null;
        }
        return precedences.get(0);
    }

    public @Nullable Precedence getPrefixPrecedence(@NonNull String operatorName) {
        String precedenceName = this.prefixToPrecedenceNameMap.get(operatorName);
        if (precedenceName == null) {
            return null;
        }
        List<Precedence> precedences = this.nameToPrecedencesMap.get(precedenceName);
        if (precedences == null) {
            return null;
        }
        return precedences.get(0);
    }
}

