/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.as2es;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.delegate.DelegateInstaller;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.OrderedSet;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class AS2EcoreDeclarationVisitor
extends AbstractExtendingVisitor<Object, AS2Ecore> {
    public static final @NonNull DuplicateConstraintsFilter duplicateConstraintsFilter = new DuplicateConstraintsFilter();
    public static final @NonNull DuplicateOperationsFilter duplicateOperationsFilter = new DuplicateOperationsFilter();
    public static final @NonNull DuplicatePropertiesFilter duplicatePropertiesFilter = new DuplicatePropertiesFilter();
    public static final @NonNull NonDuplicateConstraintsFilter nonDuplicateConstraintsFilter = new NonDuplicateConstraintsFilter();
    public static final @NonNull NonDuplicateOperationsFilter nonDuplicateOperationsFilter = new NonDuplicateOperationsFilter();
    public static final @NonNull NonDuplicatePropertiesFilter nonDuplicatePropertiesFilter = new NonDuplicatePropertiesFilter();
    protected final @NonNull DelegateInstaller delegateInstaller;

    public AS2EcoreDeclarationVisitor(@NonNull AS2Ecore context) {
        super(context);
        this.delegateInstaller = context.getDelegateInstaller();
    }

    protected void copyClassifier(@NonNull EClassifier eClassifier, @NonNull Class pivotType) {
        this.copyNamedElement((ENamedElement)eClassifier, pivotType);
        @NonNull EList eTypeParameters = eClassifier.getETypeParameters();
        this.copyTemplateSignature((List<ETypeParameter>)eTypeParameters, pivotType);
        if (pivotType.eIsSet((EStructuralFeature)PivotPackage.Literals.CLASS__INSTANCE_CLASS_NAME)) {
            eClassifier.setInstanceClassName(pivotType.getInstanceClassName());
        } else {
            eClassifier.eUnset((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME);
        }
        this.delegateInstaller.installDelegates(eClassifier, pivotType);
        for (Constraint pivotInvariant : pivotType.getOwnedInvariants()) {
            if (pivotInvariant.isIsCallable()) continue;
            this.safeVisit(pivotInvariant);
        }
    }

    protected @Nullable EAnnotation copyConstraint(@NonNull EModelElement eModelElement, @NonNull Constraint pivotConstraint) {
        EAnnotation eAnnotation = this.delegateInstaller.createConstraintDelegate(eModelElement, pivotConstraint, ((AS2Ecore)this.context).getEcoreURI());
        if (eAnnotation != null) {
            if (eModelElement instanceof EOperation) {
                AS2Ecore.copyAnnotationComments(eAnnotation, pivotConstraint);
            } else {
                AS2Ecore.copyCommentsAndDocumentation((EModelElement)eAnnotation, pivotConstraint);
            }
        }
        return eAnnotation;
    }

    protected void copyDataTypeOrEnum(@NonNull EDataType eDataType, @NonNull DataType pivotDataType) {
        this.copyClassifier((EClassifier)eDataType, pivotDataType);
        eDataType.setSerializable(pivotDataType.isIsSerializable());
    }

    protected void copyDetails(@NonNull EAnnotation eAnnotation, @NonNull Annotation pivotAnnotation) {
        this.copyModelElement((EModelElement)eAnnotation, pivotAnnotation);
        @NonNull EList eAnnotations = eAnnotation.getEAnnotations();
        this.safeVisitAll((List)eAnnotations, (Iterable<? extends Element>)pivotAnnotation.getOwnedAnnotations());
        for (Detail pivotDetail : pivotAnnotation.getOwnedDetails()) {
            String name = pivotDetail.getName();
            if ("documentation".equals(name) && "http://www.eclipse.org/emf/2002/GenModel".equals(pivotAnnotation.getName())) continue;
            String value = StringUtil.splice(pivotDetail.getValues(), "");
            eAnnotation.getDetails().put((Object)name, (Object)value);
        }
    }

    protected void copyModelElement(@NonNull EModelElement eModelElement, @NonNull Element pivotModelElement) {
        ((AS2Ecore)this.context).putCreated(pivotModelElement, eModelElement);
        this.safeVisitAll((List)ClassUtil.nonNullState(eModelElement.getEAnnotations()), pivotModelElement.getOwnedAnnotations());
        AS2Ecore.copyCommentsAndDocumentation(eModelElement, pivotModelElement);
    }

    protected void copyNamedElement(@NonNull ENamedElement eNamedElement, @NonNull NamedElement pivotNamedElement) {
        EObject eContainer;
        this.copyModelElement((EModelElement)eNamedElement, pivotNamedElement);
        String name = pivotNamedElement.getName();
        if ("containingActivity".equals(name)) {
            EObject eContainer2 = pivotNamedElement.eContainer();
            if (eContainer2 instanceof Type && "ActivityNode".equals(((Type)eContainer2).getName())) {
                name = "ActivityNode_" + name;
            }
        } else if ("inActivity".equals(name) && (eContainer = pivotNamedElement.eContainer()) instanceof Type && "StructuredActivityNode".equals(((Type)eContainer).getName())) {
            name = "activity";
        }
        eNamedElement.setName(name);
    }

    protected void copyTemplateSignature(@NonNull List<ETypeParameter> eTypeParameters, TemplateableElement pivotElement) {
        TemplateSignature templateSignature = pivotElement.getOwnedSignature();
        if (templateSignature != null) {
            List<TemplateParameter> parameters = templateSignature.getOwnedParameters();
            this.safeVisitAll(eTypeParameters, parameters);
        }
    }

    protected void copyTypedElement(@NonNull ETypedElement eTypedElement, @NonNull TypedElement pivotTypedElement) {
        this.copyNamedElement((ENamedElement)eTypedElement, pivotTypedElement);
        ((AS2Ecore)this.context).defer(pivotTypedElement);
    }

    protected @Nullable EAnnotation createOppositeEAnnotation(@NonNull Property property) {
        String name;
        UnlimitedNaturalValue upperValue;
        IntegerValue lowerValue;
        Type type;
        String lower = null;
        String ordered = null;
        String unique = null;
        String upper = null;
        Type propertyType = property.getType();
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            type = collectionType.getElementType();
            lowerValue = collectionType.getLowerValue();
            upperValue = collectionType.getUpperValue();
            if (collectionType.isOrdered()) {
                ordered = Boolean.toString(collectionType.isOrdered());
            }
            if (collectionType.isUnique()) {
                unique = Boolean.toString(collectionType.isUnique());
            }
        } else {
            type = propertyType;
            lowerValue = property.isIsRequired() ? ValueUtil.ONE_VALUE : ValueUtil.ZERO_VALUE;
            upperValue = ValueUtil.UNLIMITED_ONE_VALUE;
        }
        if (!PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE.equals(lowerValue)) {
            lower = lowerValue.toString();
        }
        if (!(property.getOpposite().isIsComposite() ? ValueUtil.UNLIMITED_ONE_VALUE : PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE).equals(upperValue)) {
            upper = upperValue.toString();
        }
        if ((name = property.getName()).equals(type.getName()) && lower == null && ordered == null && unique == null && upper == null) {
            return null;
        }
        lower = null;
        ordered = null;
        unique = null;
        upper = null;
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            if (collectionType.isOrdered()) {
                ordered = Boolean.toString(collectionType.isOrdered());
            }
            if (!collectionType.isUnique()) {
                unique = Boolean.toString(collectionType.isUnique());
            }
        }
        if (!PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE.equals(lowerValue)) {
            lower = lowerValue.toString();
        }
        if (!PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE.equals(upperValue)) {
            upper = upperValue.toString();
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
        EMap details = eAnnotation.getDetails();
        details.put((Object)"body", (Object)name);
        if (lower != null) {
            details.put((Object)"lower", (Object)lower);
        }
        if (ordered != null) {
            details.put((Object)"ordered", (Object)ordered);
        }
        if (unique != null) {
            details.put((Object)"unique", (Object)unique);
        }
        if (upper != null) {
            details.put((Object)"upper", (Object)upper);
        }
        return eAnnotation;
    }

    public <T extends EObject> void safeVisitAll(@NonNull List<T> eObjects, @NonNull Iterable<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for AS2Ecore Declaration pass");
    }

    @Override
    public EObject visitAnnotation(@NonNull Annotation pivotAnnotation) {
        @NonNull EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        this.copyDetails(eAnnotation, pivotAnnotation);
        eAnnotation.setSource(pivotAnnotation.getName());
        @NonNull EList contents = eAnnotation.getContents();
        this.safeVisitAll((List)contents, (Iterable<? extends Element>)pivotAnnotation.getOwnedContents());
        if (!pivotAnnotation.getReferences().isEmpty()) {
            ((AS2Ecore)this.context).defer(pivotAnnotation);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitAnyType(@NonNull AnyType pivotAnyType) {
        if (pivotAnyType.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotAnyType);
        java.lang.Class<Object> instanceClass = null;
        String name = pivotAnyType.getName();
        if ("OclAny".equals(name)) {
            instanceClass = Object.class;
        }
        eClass.setInstanceClass(instanceClass);
        eClass.setAbstract(true);
        eClass.setInterface(true);
        return eClass;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotClass) {
        if (pivotClass.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotClass);
        eClass.setAbstract(pivotClass.isIsAbstract());
        eClass.setInterface(pivotClass.isIsInterface());
        ((AS2Ecore)this.context).defer(pivotClass);
        @NonNull EList eOperations = eClass.getEOperations();
        @NonNull Iterable nonDuplicateConstraints = Iterables.filter(pivotClass.getOwnedInvariants(), (Predicate)nonDuplicateConstraintsFilter);
        @NonNull Iterable nonDuplicateOperations = Iterables.filter(pivotClass.getOwnedOperations(), (Predicate)nonDuplicateOperationsFilter);
        this.safeVisitAll((List)eOperations, nonDuplicateOperations);
        @NonNull EList eStructuralFeatures = eClass.getEStructuralFeatures();
        @NonNull Iterable nonDuplicateProperties = Iterables.filter(pivotClass.getOwnedProperties(), (Predicate)nonDuplicatePropertiesFilter);
        this.safeVisitAll((List)eStructuralFeatures, nonDuplicateProperties);
        Map<@NonNull String, @Nullable Object> options = ((AS2Ecore)this.context).getOptions();
        String invariantPrefix = AS2Ecore.getInvariantPrefix(options);
        for (Constraint pivotInvariant : nonDuplicateConstraints) {
            if (!pivotInvariant.isIsCallable()) continue;
            @NonNull String name = PivotUtil.getName(pivotInvariant);
            if (invariantPrefix != null) {
                name = String.valueOf(invariantPrefix) + name;
            }
            EOperation eOperation = AS2Ecore.createConstraintEOperation(pivotInvariant, name, options);
            eOperations.add(eOperation);
            ((AS2Ecore)this.context).putCreated(pivotInvariant, (EModelElement)eOperation);
            this.copyConstraint((EModelElement)eOperation, pivotInvariant);
        }
        if (!((AS2Ecore)this.context).isSuppressDuplicates()) {
            ArrayList<Object> eDuplicates = null;
            @NonNull Iterable duplicateConstraints = Iterables.filter(pivotClass.getOwnedInvariants(), (Predicate)duplicateConstraintsFilter);
            for (Constraint asConstraint : duplicateConstraints) {
                if (eDuplicates == null) {
                    eDuplicates = new ArrayList<Object>();
                }
                if (!asConstraint.isIsCallable()) continue;
                EOperation eOperation = AS2Ecore.createConstraintEOperation(asConstraint, PivotUtil.getName(asConstraint), options);
                eOperations.add(eOperation);
                ((AS2Ecore)this.context).putCreated(asConstraint, (EModelElement)eOperation);
                this.copyConstraint((EModelElement)eOperation, asConstraint);
                eDuplicates.add(eOperation);
                ((AS2Ecore)this.context).defer(asConstraint);
            }
            @NonNull Iterable duplicateOperations = Iterables.filter(pivotClass.getOwnedOperations(), (Predicate)duplicateOperationsFilter);
            for (Operation asOperation : duplicateOperations) {
                Object eOperation;
                if (eDuplicates == null) {
                    eDuplicates = new ArrayList();
                }
                if (!((eOperation = this.safeVisit(asOperation)) instanceof EOperation)) continue;
                eDuplicates.add((EOperation)eOperation);
            }
            @NonNull Iterable duplicateProperties = Iterables.filter(pivotClass.getOwnedProperties(), (Predicate)duplicatePropertiesFilter);
            for (Property asProperty : duplicateProperties) {
                Object eStructuralFeature;
                if (eDuplicates == null) {
                    eDuplicates = new ArrayList();
                }
                if (!((eStructuralFeature = this.safeVisit(asProperty)) instanceof EStructuralFeature)) continue;
                eDuplicates.add((EStructuralFeature)eStructuralFeature);
            }
            if (eDuplicates != null) {
                EAnnotation eAnnotation = eClass.getEAnnotation("duplicates");
                if (eAnnotation == null) {
                    eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource("duplicates");
                    eClass.getEAnnotations().add((Object)eAnnotation);
                }
                ((AS2Ecore)this.context).refreshList(eAnnotation.getContents(), eDuplicates);
            }
        }
        return eClass;
    }

    @Override
    public EObject visitCollectionType(@NonNull CollectionType pivotCollectionType) {
        if (pivotCollectionType.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotCollectionType);
        java.lang.Class instanceClass = null;
        String name = pivotCollectionType.getName();
        if ("Bag".equals(name)) {
            instanceClass = Bag.class;
        } else if ("Collection".equals(name)) {
            instanceClass = Collection.class;
        } else if ("OrderedCollection".equals(name)) {
            instanceClass = Collection.class;
        } else if ("OrderedSet".equals(name)) {
            instanceClass = OrderedSet.class;
        } else if ("Sequence".equals(name)) {
            instanceClass = List.class;
        } else if ("Set".equals(name)) {
            instanceClass = Set.class;
        } else if ("UniqueCollection".equals(name)) {
            instanceClass = Collection.class;
        }
        @NonNull EList eStructuralFeatures = eClass.getEStructuralFeatures();
        @NonNull Iterable nonDuplicateProperties = Iterables.filter(pivotCollectionType.getOwnedProperties(), (Predicate)nonDuplicatePropertiesFilter);
        this.safeVisitAll((List)eStructuralFeatures, nonDuplicateProperties);
        eClass.setInstanceClass(instanceClass);
        eClass.setAbstract(true);
        eClass.setInterface(true);
        ((AS2Ecore)this.context).defer(pivotCollectionType);
        return eClass;
    }

    @Override
    public EObject visitConstraint(@NonNull Constraint pivotConstraint) {
        EModelElement eModelElement;
        Element eContainer = (Element)pivotConstraint.eContainer();
        if (eContainer != null && (eModelElement = ((AS2Ecore)this.context).getCreated(EModelElement.class, eContainer)) != null) {
            this.copyConstraint(eModelElement, pivotConstraint);
            return null;
        }
        return null;
    }

    @Override
    public EObject visitDataType(@NonNull DataType pivotDataType) {
        if (pivotDataType.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.copyDataTypeOrEnum(eDataType, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitEnumeration(@NonNull Enumeration pivotEnumeration) {
        if (pivotEnumeration.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.copyDataTypeOrEnum((EDataType)eEnum, pivotEnumeration);
        @NonNull EList eLiterals = eEnum.getELiterals();
        this.safeVisitAll((List)eLiterals, (Iterable<? extends Element>)pivotEnumeration.getOwnedLiterals());
        return eEnum;
    }

    @Override
    public EObject visitEnumerationLiteral(@NonNull EnumerationLiteral pivotEnumLiteral) {
        @NonNull EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        this.copyNamedElement((ENamedElement)eEnumLiteral, pivotEnumLiteral);
        if (pivotEnumLiteral.eIsSet((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE)) {
            eEnumLiteral.setValue(pivotEnumLiteral.getValue().intValue());
        } else {
            eEnumLiteral.eUnset((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE);
        }
        return eEnumLiteral;
    }

    @Override
    public EObject visitMapType(@NonNull MapType pivotMapType) {
        if (pivotMapType.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotMapType);
        @NonNull EList eStructuralFeatures = eClass.getEStructuralFeatures();
        @NonNull Iterable nonDuplicateProperties = Iterables.filter(pivotMapType.getOwnedProperties(), (Predicate)nonDuplicatePropertiesFilter);
        this.safeVisitAll((List)eStructuralFeatures, nonDuplicateProperties);
        eClass.setInstanceClass(Map.class);
        eClass.setAbstract(true);
        eClass.setInterface(true);
        ((AS2Ecore)this.context).defer(pivotMapType);
        return eClass;
    }

    @Override
    public Object visitModel(@NonNull Model pivotModel) {
        EModelElement firstElement = null;
        ArrayList<EObject> outputObjects = new ArrayList<EObject>();
        for (Package pivotObject : pivotModel.getOwnedPackages()) {
            Object ecoreObject;
            if (Orphanage.isTypeOrphanage(pivotObject) || PivotUtilInternal.isImplicitPackage(pivotObject) || !((ecoreObject = this.safeVisit(pivotObject)) instanceof EObject)) continue;
            outputObjects.add((EObject)ecoreObject);
            if (firstElement != null || !(ecoreObject instanceof EModelElement)) continue;
            firstElement = (EModelElement)ecoreObject;
        }
        List<Import> imports = pivotModel.getOwnedImports();
        if (imports.size() > 0) {
            if (imports.size() > 0) {
                imports = new ArrayList<Import>(imports);
                Collections.sort(imports, new Comparator<Import>(){

                    @Override
                    public int compare(Import o1, Import o2) {
                        String n1 = o1.getName();
                        String n2 = o2.getName();
                        if (n1 == null) {
                            n1 = "";
                        }
                        if (n2 == null) {
                            n1 = "";
                        }
                        return n1.compareTo(n2);
                    }
                });
            }
            EAnnotation importAnnotation = null;
            URI ecoreURI = ((AS2Ecore)this.context).getEcoreURI();
            for (Import anImport : imports) {
                EObject eTarget;
                Namespace importedNamespace = anImport.getImportedNamespace();
                if (importedNamespace == null) continue;
                if (importAnnotation == null) {
                    importAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    importAnnotation.setSource("http://www.eclipse.org/OCL/Import");
                }
                if ((eTarget = importedNamespace.getESObject()) != null) {
                    String nsURI;
                    URI uri = null;
                    if (eTarget instanceof EPackage && ClassUtil.isRegistered(eTarget.eResource()) && (nsURI = ((EPackage)eTarget).getNsURI()) != null) {
                        uri = URI.createURI((String)nsURI);
                    }
                    if (uri == null) {
                        uri = EcoreUtil.getURI((EObject)eTarget);
                    }
                    URI uri2 = uri.deresolve(ecoreURI, true, true, true);
                    importAnnotation.getDetails().put((Object)anImport.getName(), (Object)uri2.toString());
                    continue;
                }
                if (importedNamespace instanceof Package) {
                    importAnnotation.getDetails().put((Object)anImport.getName(), (Object)((Package)importedNamespace).getURI());
                    continue;
                }
                importAnnotation.getDetails().put((Object)anImport.getName(), (Object)importedNamespace.toString());
            }
            if (firstElement != null && importAnnotation != null) {
                firstElement.getEAnnotations().add(importAnnotation);
            }
        }
        return outputObjects;
    }

    @Override
    public EObject visitOperation(@NonNull Operation pivotOperation) {
        if (pivotOperation.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        this.copyTypedElement((ETypedElement)eOperation, pivotOperation);
        @NonNull EList eTypeParameters = eOperation.getETypeParameters();
        this.copyTemplateSignature((List<ETypeParameter>)eTypeParameters, pivotOperation);
        @NonNull EList eParameters = eOperation.getEParameters();
        this.safeVisitAll((List)eParameters, (Iterable<? extends Element>)pivotOperation.getOwnedParameters());
        LanguageExpression bodyExpression = pivotOperation.getBodyExpression();
        if (bodyExpression != null) {
            EAnnotation eAnnotation = this.delegateInstaller.createOperationDelegate(eOperation, bodyExpression, ((AS2Ecore)this.context).getEcoreURI());
        }
        for (Constraint pivotConstraint : pivotOperation.getOwnedPreconditions()) {
            this.safeVisit(pivotConstraint);
        }
        for (Constraint pivotConstraint : pivotOperation.getOwnedPostconditions()) {
            this.safeVisit(pivotConstraint);
        }
        if (pivotOperation.isIsTransient()) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/OCL/Pivot/Operation");
            EMap details = eAnnotation.getDetails();
            details.put((Object)"isTransient", (Object)"true");
            eOperation.getEAnnotations().add((Object)eAnnotation);
        }
        return eOperation;
    }

    @Override
    public EObject visitPackage(@NonNull Package pivotPackage) {
        @NonNull EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.copyNamedElement((ENamedElement)ePackage, pivotPackage);
        ((AS2Ecore)this.context).defer(pivotPackage);
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_PREFIX)) {
            ePackage.setNsPrefix(pivotPackage.getNsPrefix());
        }
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__URI)) {
            ePackage.setNsURI(pivotPackage.getURI());
        }
        @NonNull EList eSubpackages = ePackage.getESubpackages();
        this.safeVisitAll((List)eSubpackages, (Iterable<? extends Element>)pivotPackage.getOwnedPackages());
        @NonNull EList eClassifiers = ePackage.getEClassifiers();
        this.safeVisitAll((List)eClassifiers, (Iterable<? extends Element>)pivotPackage.getOwnedClasses());
        return ePackage;
    }

    @Override
    public EObject visitParameter(@NonNull Parameter pivotParameter) {
        @NonNull EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        this.copyTypedElement((ETypedElement)eParameter, pivotParameter);
        return eParameter;
    }

    @Override
    public EObject visitPrimitiveType(@NonNull PrimitiveType pivotPrimitiveType) {
        if (pivotPrimitiveType.getOwnedBindings().size() > 0) {
            return null;
        }
        @NonNull EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.copyDataTypeOrEnum(eDataType, pivotPrimitiveType);
        return eDataType;
    }

    @Override
    public EObject visitProperty(@NonNull Property pivotProperty) {
        EAnnotation eAnnotation;
        EAttribute eStructuralFeature;
        if (pivotProperty.isIsImplicit()) {
            return null;
        }
        Type type = pivotProperty.getType();
        CollectionType ecoreCollectionType = ((AS2Ecore)this.context).isEcoreCollection(type);
        if (ecoreCollectionType != null) {
            type = ecoreCollectionType.getElementType();
        }
        if (type instanceof DataType) {
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            eAttribute.setID(pivotProperty.isIsID());
            eStructuralFeature = eAttribute;
        } else {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            if (pivotProperty.getOpposite() != null || !pivotProperty.getKeys().isEmpty()) {
                ((AS2Ecore)this.context).defer(pivotProperty);
            }
            eReference.setContainment(pivotProperty.isIsComposite());
            eReference.setResolveProxies(pivotProperty.isIsResolveProxies());
            eStructuralFeature = eReference;
        }
        Property opposite = pivotProperty.getOpposite();
        if (opposite != null && opposite.isIsImplicit() && (eAnnotation = this.createOppositeEAnnotation(opposite)) != null) {
            eStructuralFeature.getEAnnotations().add((Object)eAnnotation);
        }
        this.copyTypedElement((ETypedElement)eStructuralFeature, pivotProperty);
        eStructuralFeature.setChangeable(!pivotProperty.isIsReadOnly());
        eStructuralFeature.setDerived(pivotProperty.isIsDerived());
        eStructuralFeature.setTransient(pivotProperty.isIsTransient());
        eStructuralFeature.setUnsettable(pivotProperty.isIsUnsettable());
        eStructuralFeature.setVolatile(pivotProperty.isIsVolatile());
        String defaultValueLiteral = pivotProperty.getDefaultValueString();
        if (defaultValueLiteral != null) {
            eStructuralFeature.setDefaultValueLiteral(defaultValueLiteral);
        } else {
            eStructuralFeature.eUnset((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL);
        }
        LanguageExpression defaultExpression = pivotProperty.getOwnedExpression();
        if (defaultExpression != null) {
            this.delegateInstaller.createPropertyDelegate((EStructuralFeature)eStructuralFeature, defaultExpression, ((AS2Ecore)this.context).getEcoreURI());
        }
        return eStructuralFeature;
    }

    @Override
    public EObject visitTemplateParameter(@NonNull TemplateParameter pivotTemplateParameter) {
        ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
        eTypeParameter.setName(pivotTemplateParameter.getName());
        ((AS2Ecore)this.context).putCreated(pivotTemplateParameter, (EModelElement)eTypeParameter);
        if (!pivotTemplateParameter.getConstrainingClasses().isEmpty()) {
            ((AS2Ecore)this.context).defer(pivotTemplateParameter);
        }
        return eTypeParameter;
    }

    protected static class DuplicateConstraintsFilter
    implements Predicate<Constraint> {
        protected DuplicateConstraintsFilter() {
        }

        public boolean apply(@Nullable Constraint aConstraint) {
            if (aConstraint == null) {
                return false;
            }
            return aConstraint.getRedefinedConstraints().size() != 0;
        }
    }

    protected static class DuplicateOperationsFilter
    implements Predicate<Operation> {
        protected DuplicateOperationsFilter() {
        }

        public boolean apply(@Nullable Operation anOperation) {
            if (anOperation == null) {
                return false;
            }
            if (anOperation.getRedefinedOperations().size() == 0) {
                return false;
            }
            return !"containingActivity".equals(anOperation.getName()) || !"ActivityNode".equals(anOperation.getOwningClass().getName());
        }
    }

    protected static class DuplicatePropertiesFilter
    implements Predicate<Property> {
        protected DuplicatePropertiesFilter() {
        }

        public boolean apply(@Nullable Property aProperty) {
            if (aProperty == null) {
                return false;
            }
            if (aProperty.getRedefinedProperties().size() == 0) {
                return false;
            }
            return ClassUtil.safeEquals(aProperty.getName(), aProperty.getRedefinedProperties().get(0).getName());
        }
    }

    protected static class NonDuplicateConstraintsFilter
    implements Predicate<Constraint> {
        protected NonDuplicateConstraintsFilter() {
        }

        public boolean apply(@Nullable Constraint aConstraint) {
            if (aConstraint == null) {
                return false;
            }
            return aConstraint.getRedefinedConstraints().size() == 0;
        }
    }

    protected static class NonDuplicateOperationsFilter
    implements Predicate<Operation> {
        protected NonDuplicateOperationsFilter() {
        }

        public boolean apply(@Nullable Operation anOperation) {
            if (anOperation == null) {
                return false;
            }
            if (anOperation.getRedefinedOperations().size() == 0) {
                return true;
            }
            return "containingActivity".equals(anOperation.getName()) && "ActivityNode".equals(anOperation.getOwningClass().getName());
        }
    }

    protected static class NonDuplicatePropertiesFilter
    implements Predicate<Property> {
        protected NonDuplicatePropertiesFilter() {
        }

        public boolean apply(@Nullable Property aProperty) {
            if (aProperty == null) {
                return false;
            }
            if (aProperty.getRedefinedProperties().size() == 0) {
                return true;
            }
            return !ClassUtil.safeEquals(aProperty.getName(), aProperty.getRedefinedProperties().get(0).getName());
        }
    }
}

