/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.HashMap;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ObjectType;
import org.eclipse.objectteams.otre.bcel.DietClassLoaderRepository;

public class RepositoryAccess {
    private static HashMap<Object, DietClassLoaderRepository> repositories = new HashMap();
    private static ThreadLocal<DietClassLoaderRepository> currentRepository = new ThreadLocal();

    public static synchronized DietClassLoaderRepository setClassLoader(Object loader) {
        DietClassLoaderRepository clr = null;
        if (loader != null && (clr = repositories.get(loader)) == null) {
            clr = new DietClassLoaderRepository(loader);
            repositories.put(loader, clr);
        }
        DietClassLoaderRepository prev = currentRepository.get();
        currentRepository.set(clr);
        return prev;
    }

    public static synchronized void resetRepository(DietClassLoaderRepository repository) {
        currentRepository.set(repository);
    }

    public static JavaClass lookupClass(String className) throws ClassNotFoundException {
        DietClassLoaderRepository clr = currentRepository.get();
        if (clr != null) {
            return clr.loadClass(className);
        }
        return Repository.lookupClass((String)className);
    }

    public static JavaClass lookupClassFully(String className) throws ClassNotFoundException {
        DietClassLoaderRepository clr = currentRepository.get();
        if (clr != null) {
            return clr.loadClassFully(className);
        }
        return Repository.lookupClass((String)className);
    }

    public static JavaClass[] getSuperClasses(String className) throws ClassNotFoundException {
        DietClassLoaderRepository clr = currentRepository.get();
        JavaClass jc = clr != null ? clr.loadClass(className) : Repository.lookupClass((String)className);
        return jc.getSuperClasses();
    }

    public static boolean implementationOf(String className, String ifcName) throws ClassNotFoundException {
        JavaClass ifc;
        JavaClass jc;
        DietClassLoaderRepository clr = currentRepository.get();
        if (clr != null) {
            jc = clr.loadClass(className);
            ifc = clr.loadClass(ifcName);
        } else {
            jc = Repository.lookupClass((String)className);
            ifc = Repository.lookupClass((String)ifcName);
        }
        return jc.implementationOf(ifc);
    }

    public static boolean safeSubclassOf(ObjectType subClass, ObjectType superClass) {
        try {
            String subClassName = subClass.getClassName();
            String superClassName = superClass.getClassName();
            return RepositoryAccess.instanceOf(subClassName, superClassName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (ClassCircularityError e) {
            return false;
        }
    }

    protected static boolean instanceOf(String subClassName, String superClassName) throws ClassNotFoundException {
        JavaClass superJClass;
        JavaClass subJClass;
        DietClassLoaderRepository clr = currentRepository.get();
        if (clr != null) {
            subJClass = clr.loadClass(subClassName);
            superJClass = clr.loadClass(superClassName);
        } else {
            subJClass = Repository.lookupClass((String)subClassName);
            superJClass = Repository.lookupClass((String)superClassName);
        }
        if (subJClass == null) {
            return false;
        }
        return subJClass.instanceOf(superJClass);
    }
}

