/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class FieldSizedCollectionExtractor
implements ICollectionExtractor {
    private final String sizeField;

    public FieldSizedCollectionExtractor(String sizeField) {
        this.sizeField = sizeField;
    }

    public boolean hasSize() {
        return this.sizeField != null;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        return ExtractionUtils.toInteger(coll.resolveValue(this.sizeField));
    }

    public boolean hasCapacity() {
        return false;
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public boolean hasExtractableContents() {
        return false;
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public boolean hasExtractableArray() {
        return false;
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public boolean hasFillRatio() {
        return false;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        return null;
    }
}

