/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.ISessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExtentHelper {
    private final OperationalTransformation fTransformation;
    private final List<URI> fModelExtentURIs;
    private final LinkedHashMap<ModelParameter, ExtentEntry> fExtentMap;
    private final ResourceSet fResourceSet;

    public ModelExtentHelper(OperationalTransformation transformation, List<URI> modelExtentURIs, ResourceSet resSet) {
        if (transformation == null || modelExtentURIs == null || modelExtentURIs.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.fTransformation = transformation;
        this.fModelExtentURIs = modelExtentURIs;
        this.fExtentMap = new LinkedHashMap();
        this.fResourceSet = resSet;
    }

    public ResourceSet getResourceSet() {
        return this.fResourceSet;
    }

    public Diagnostic saveExtents(Boolean isQvtoUnparseEnabled) {
        BasicDiagnostic diagnostic = QvtPlugin.createDiagnostic("Save model param extents diagnostic");
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ExtentEntry nextEntry : this.fExtentMap.values()) {
            URI saveAsURI = nextEntry.saveAsURI;
            if (saveAsURI == null) continue;
            resources.addAll(ModelExtentHelper.addExtentContentsToResources(nextEntry.extent.getContents(), this.fResourceSet, saveAsURI));
        }
        LinkedHashMap<ISessionData.SimpleEntry<Boolean>, Boolean> options = new LinkedHashMap<ISessionData.SimpleEntry<Boolean>, Boolean>(EmfUtil.DEFAULT_SAVE_OPTIONS);
        options.put(QVTEvaluationOptions.FLAG_QVTO_UNPARSE_ENABLED, isQvtoUnparseEnabled);
        for (Resource outExtent : resources) {
            try {
                EmfUtil.saveModel((Resource)outExtent, options);
            }
            catch (EmfException e) {
                diagnostic.add(QvtPlugin.createErrorDiagnostic("Failed to save model extent uri=" + outExtent.getURI(), e));
            }
            URIUtils.refresh((URI)outExtent.getURI());
        }
        return diagnostic;
    }

    public List<ModelExtent> loadExtents() throws DiagnosticException {
        EList<ModelParameter> params = this.fTransformation.getModelParameter();
        if (params.size() > this.fModelExtentURIs.size()) {
            throw new DiagnosticException(QvtPlugin.createErrorDiagnostic(NLS.bind(Messages.InvalidModelParameterCountError, this.fModelExtentURIs.size(), params.size()), null));
        }
        int i = 0;
        for (ModelParameter nextParam : params) {
            URI uri = this.fModelExtentURIs.get(i++);
            DirectionKind kind = nextParam.getKind();
            URI saveAsURI = kind != DirectionKind.IN ? uri : null;
            URI loadURI = kind != DirectionKind.OUT ? uri : null;
            ModelExtent extent = loadURI != null ? this.loadExtent(nextParam, loadURI, this.fResourceSet) : new BasicModelExtent();
            ExtentEntry entry = new ExtentEntry(extent, saveAsURI);
            this.fExtentMap.put(nextParam, entry);
        }
        return this.getExtents();
    }

    private ModelExtent loadExtent(ModelParameter modelParameter, URI uri, ResourceSet rs) throws DiagnosticException {
        Throwable error;
        try {
            Iterator iterator;
            Resource res = rs.getResource(uri, true);
            EList contents = res.getContents();
            if (!res.getErrors().isEmpty() && (iterator = res.getErrors().iterator()).hasNext()) {
                Resource.Diagnostic d = (Resource.Diagnostic)iterator.next();
                throw new DiagnosticException(QvtPlugin.createErrorDiagnostic(d.getMessage(), null));
            }
            return new BasicModelExtent((List<? extends EObject>)contents);
        }
        catch (WrappedException e) {
            error = e.getCause() != null ? e.getCause() : e;
        }
        catch (RuntimeException e) {
            error = e;
        }
        throw new DiagnosticException(QvtPlugin.createErrorDiagnostic("Failed to load model extent uri=" + uri, error));
    }

    private List<ModelExtent> getExtents() {
        ArrayList<ModelExtent> result = new ArrayList<ModelExtent>(this.fExtentMap.size());
        for (ExtentEntry extentEntry : this.fExtentMap.values()) {
            result.add(extentEntry.extent);
        }
        return result;
    }

    private static Set<Resource> addExtentContentsToResources(List<EObject> rootContents, ResourceSet resSet, URI outUri) {
        URI modelUri = outUri.trimFragment();
        Resource outExtent = resSet.getResource(modelUri, false);
        if (outExtent == null) {
            outExtent = EmfUtil.createResource((URI)modelUri, (ResourceSet)resSet);
            resSet.getResources().add((Object)outExtent);
        }
        LinkedHashMap<Resource, List<EObject>> linkedExtents = new LinkedHashMap<Resource, List<EObject>>();
        linkedExtents.put(outExtent, rootContents);
        TreeIterator allContents = EcoreUtil.getAllContents(rootContents, (boolean)false);
        while (allContents.hasNext()) {
            Resource eResource;
            EObject eObject = (EObject)allContents.next();
            if (rootContents.contains(eObject) || (eResource = eObject.eResource()) == null || eResource == outExtent) continue;
            ArrayList<EObject> content = (ArrayList<EObject>)linkedExtents.get(eResource);
            if (content == null) {
                content = new ArrayList<EObject>();
                linkedExtents.put(eResource, content);
            }
            content.add(eObject);
        }
        for (Map.Entry nextExtent : linkedExtents.entrySet()) {
            Resource rs = (Resource)nextExtent.getKey();
            ModelExtentHelper.mergeExtentToResource(rs, (List)nextExtent.getValue());
        }
        return linkedExtents.keySet();
    }

    public static void mergeExtentToResource(Resource outExtent, List<? extends EObject> extentContent) {
        Set<EObject> essentialRootElements = ModelExtentHelper.getEssentialRootElements(extentContent);
        if (essentialRootElements.isEmpty()) {
            TreeIterator it = outExtent.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                eObject.eAdapters().clear();
            }
            outExtent.getContents().clear();
        } else if (outExtent.getContents().isEmpty()) {
            ModelExtentHelper.addAllContents((EList<EObject>)outExtent.getContents(), essentialRootElements);
        } else {
            Set resolvedRootElements = EmfUtil.getResolvedContent(essentialRootElements, (EObject)((EObject)outExtent.getContents().get(0)));
            TreeIterator it = outExtent.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (resolvedRootElements.contains(eObject)) continue;
                eObject.eAdapters().clear();
            }
            outExtent.getContents().retainAll((Collection)resolvedRootElements);
            for (EObject eObject : outExtent.getContents()) {
                InternalEObject internalEObject = (InternalEObject)eObject;
                if (internalEObject.eDirectResource() != null) continue;
                internalEObject.eSetResource((Resource.Internal)outExtent, null);
            }
            resolvedRootElements.removeAll((Collection<?>)outExtent.getContents());
            ModelExtentHelper.addAllContents((EList<EObject>)outExtent.getContents(), resolvedRootElements);
        }
    }

    private static Set<EObject> getEssentialRootElements(List<? extends EObject> allRootElements) {
        LinkedHashSet<EObject> roots = new LinkedHashSet<EObject>();
        Iterator<? extends EObject> iterator = allRootElements.iterator();
        while (iterator.hasNext()) {
            EObject e;
            EObject nextRoot = e = iterator.next();
            while (nextRoot.eContainer() instanceof EObject && nextRoot.eContainer().eResource() == e.eResource()) {
                nextRoot = nextRoot.eContainer();
            }
            roots.add(nextRoot);
        }
        return roots;
    }

    private static void addAllContents(EList<EObject> contents, Set<EObject> elements) {
        if (contents instanceof AbstractEList) {
            ((AbstractEList)contents).addAllUnique(elements);
        } else {
            contents.addAll(elements);
        }
    }

    private static class ExtentEntry {
        final ModelExtent extent;
        final URI saveAsURI;

        ExtentEntry(ModelExtent extent, URI saveAsURI) {
            assert (extent != null);
            this.extent = extent;
            this.saveAsURI = saveAsURI;
        }
    }
}

