/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;

public class LineComparator
implements IRangeComparator {
    private String[] fLines;

    public static LineComparator create(IStorage storage, String outputEncoding) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream is = new BufferedInputStream(storage.getContents());){
                String encoding = LineComparator.getEncoding(storage, outputEncoding);
                return new LineComparator(is, encoding);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getEncoding(IStorage storage, String outputEncoding) throws CoreException {
        IEncodedStorage es;
        String charset;
        if (storage instanceof IEncodedStorage && (charset = (es = (IEncodedStorage)storage).getCharset()) != null) {
            return charset;
        }
        return outputEncoding;
    }

    public LineComparator(InputStream is, String encoding) throws UnsupportedEncodingException {
        TrailingLineFeedDetector trailingLineFeedDetector = new TrailingLineFeedDetector(is);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)trailingLineFeedDetector, encoding));
        ArrayList<String> ar = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ar.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (trailingLineFeedDetector.hadTrailingLineFeed()) {
            ar.add("");
        }
        this.fLines = ar.toArray(new String[ar.size()]);
    }

    public int getRangeCount() {
        return this.fLines.length;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        String s1 = this.fLines[thisIndex];
        String s2 = ((LineComparator)other).fLines[otherIndex];
        return s1.equals(s2);
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private static class TrailingLineFeedDetector
    extends FilterInputStream {
        boolean trailingLF = false;

        protected TrailingLineFeedDetector(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            this.trailingLF = this.isLineFeed(c);
            return c;
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            int length = super.read(buffer, off, len);
            if (length != -1) {
                int index = off + length - 1;
                if (index >= buffer.length) {
                    index = buffer.length - 1;
                }
                this.trailingLF = this.isLineFeed(buffer[index]);
            }
            return length;
        }

        private boolean isLineFeed(int c) {
            return c != -1 && c == 10;
        }

        public boolean hadTrailingLineFeed() {
            return this.trailingLF;
        }
    }
}

