/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.ast.parser;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.ByteOrderMark;

public class OffsetFixer {
    private final TreeMap<Integer, Integer> cache;
    private final int charactersLength;
    private boolean hasBOM = false;
    private int bomShift = 0;

    public OffsetFixer(String src) {
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        if (src.startsWith("\ufeff")) {
            this.hasBOM = true;
            this.bomShift = ByteOrderMark.UTF_8.length();
        }
        CharBuffer source = CharBuffer.wrap(src);
        this.cache = new TreeMap();
        this.charactersLength = source.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(Math.round(encoder.maxBytesPerChar()));
        int averageBytesPerChar = Math.round(encoder.averageBytesPerChar());
        int bytePosition = 0;
        int delta = 0;
        source.limit(0);
        while (source.position() < this.charactersLength) {
            source.limit(source.limit() + 1);
            encoder.encode(source, byteBuffer, false);
            int bytesForCurrentChar = byteBuffer.position();
            bytePosition += bytesForCurrentChar;
            if (bytesForCurrentChar > averageBytesPerChar) {
                this.cache.put(bytePosition, delta += bytesForCurrentChar - averageBytesPerChar);
            }
            byteBuffer.clear();
        }
    }

    public int getCharacterPosition(int bytePosition) {
        Map.Entry<Integer, Integer> floorEntry = this.cache.floorEntry(bytePosition);
        if (floorEntry != null) {
            return bytePosition - floorEntry.getValue() + this.bomShift;
        }
        return bytePosition + this.bomShift;
    }

    public int getCharactersLength() {
        return this.charactersLength;
    }

    public boolean hasBom() {
        return this.hasBOM;
    }
}

