/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views.imageview;

import java.text.SimpleDateFormat;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.utils.ImageUtils;
import org.eclipse.jubula.client.ui.views.imageview.ImageProvider;
import org.eclipse.jubula.client.ui.views.imageview.ImageViewData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class TestResultNodeImageProvider
implements ImageProvider {
    private TestResultNode m_testResultNode;

    public TestResultNodeImageProvider(TestResultNode testresultnode) {
        this.m_testResultNode = testresultnode;
    }

    public ImageViewData getImageViewData(Device target) {
        byte[] screenshot = this.m_testResultNode.getScreenshot();
        if (screenshot != null) {
            Image img = new Image(target, ImageUtils.getImageData(screenshot));
            return new ImageViewData(img, this.generateImageName(), this.generateImageDate());
        }
        return null;
    }

    private String generateImageName() {
        TestResultNode parent = this.m_testResultNode;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        String imgName = "ErrorInTest_" + parent.getName() + "_" + this.m_testResultNode.getNode().getName();
        imgName = imgName.replaceAll("[\\s\\?\\\\/:|<>\\*\"]", "");
        return imgName;
    }

    private String generateImageDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
        String date = format.format(this.m_testResultNode.getTimeStamp());
        return date;
    }
}

