/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.model.AbstractGuidNamePO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@Table(name="COMPONENT_NAMES", uniqueConstraints={@UniqueConstraint(columnNames={"PARENT_PROJ", "GUID"})})
@AttributeOverride(name="hbmGuid", column=@Column(name="GUID"))
class ComponentNamePO
extends AbstractGuidNamePO
implements IComponentNamePO,
PersistenceWeaved,
PersistenceObject {
    private Long m_parentProjectId = null;
    private transient String m_componentType = null;
    private String m_referencedGuid = null;
    private String m_creationContext = null;
    private transient Integer m_version;
    private transient IProblem m_typeProblem;
    private transient String m_usageType;
    static final long serialVersionUID = 1926190850693364985L;

    ComponentNamePO() {
    }

    ComponentNamePO(String guid, String name, String type, ComponentNamesBP.CompNameCreationContext creationContext) {
        this.setHbmGuid(guid);
        this.setHbmName(name);
        this.setHbmCreationContext(creationContext.toString());
        this.setComponentType(type);
    }

    ComponentNamePO(ComponentNamePO toClone) {
        this.setHbmGuid(toClone.getHbmGuid());
        this.setHbmName(toClone.getHbmName());
        this.m_parentProjectId = toClone.getHbmParentProjectId();
        this.m_referencedGuid = toClone.getHbmReferencedGuid();
        this.m_creationContext = toClone.getHbmCreationContext();
        this.m_version = toClone.getVersion();
        this.m_typeProblem = toClone.getTypeProblem();
        this.setId(toClone.getId());
    }

    @Basic
    @Column(name="REF_GUID")
    String getHbmReferencedGuid() {
        return this.m_referencedGuid;
    }

    void setHbmReferencedGuid(String referencedGuid) {
        this.m_referencedGuid = referencedGuid;
    }

    @Override
    @Transient
    public String getComponentType() {
        return this.m_componentType;
    }

    @Override
    public void setComponentType(String componentType) {
        this.m_componentType = componentType;
    }

    @Override
    @Transient
    public String getReferencedGuid() {
        return this.getHbmReferencedGuid();
    }

    @Override
    public void setReferencedGuid(String referencedGuid) {
        this.setHbmReferencedGuid(referencedGuid);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    void setHbmParentProjectId(Long parentProjectId) {
        this.m_parentProjectId = parentProjectId;
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="CREATION_CONTEXT")
    String getHbmCreationContext() {
        return this.m_creationContext;
    }

    @Override
    @Transient
    public ComponentNamesBP.CompNameCreationContext getCreationContext() {
        return ComponentNamesBP.CompNameCreationContext.forName(this.getHbmCreationContext());
    }

    void setHbmCreationContext(String creationContext) {
        this.m_creationContext = creationContext;
    }

    @Override
    public final boolean isNameEqual(ComponentNamePO compNamePO) {
        return this.getHbmGuid().equals(compNamePO.getHbmGuid());
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getHbmParentProjectId() == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof ComponentNamePO)) {
            return false;
        }
        ComponentNamePO c = (ComponentNamePO)obj;
        return new EqualsBuilder().append((Object)this.getHbmParentProjectId(), (Object)c.getHbmParentProjectId()).append((Object)this.getHbmGuid(), (Object)c.getHbmGuid()).isEquals();
    }

    @Override
    public int hashCode() {
        Long hbmParentProjectId = this.getHbmParentProjectId();
        String hbmGuid = this.getHbmGuid();
        if (hbmParentProjectId == null || hbmGuid == null) {
            return super.hashCode();
        }
        return hbmParentProjectId.hashCode() + hbmGuid.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("type", (Object)this.getComponentType()).append("guid", (Object)this.getGuid()).append("parentProjectId", (Object)this.getParentProjectId()).toString();
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    public void setId(Long id) {
        super.setId(id);
    }

    @Override
    @Transient
    public IProblem getTypeProblem() {
        return this.m_typeProblem;
    }

    @Override
    public void setTypeProblem(IProblem problem) {
        this.m_typeProblem = problem;
    }

    @Override
    public void setUsageType(String type) {
        this.m_usageType = type;
    }

    @Override
    @Transient
    public String getUsageType() {
        return this.m_usageType;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ComponentNamePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmCreationContext") {
            return this.hbmCreationContext;
        }
        if (string == "hbmReferencedGuid") {
            return this.hbmReferencedGuid;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmCreationContext") {
            this.hbmCreationContext = (String)object;
            return;
        }
        if (string == "hbmReferencedGuid") {
            this.hbmReferencedGuid = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

