/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.remote.dialogs;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jubula.autagent.remote.dialogs.ObservationConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationConsoleBP {
    private static final Logger LOG = LoggerFactory.getLogger(ObservationConsoleBP.class);
    private static ObservationConsole shell = null;
    private static ObservationConsoleBP instance = null;

    private ObservationConsoleBP() {
    }

    public void create() {
        if (shell == null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        shell = new ObservationConsole();
                        ObservationConsoleBP.this.initialize();
                        Toolkit screen = Toolkit.getDefaultToolkit();
                        Dimension screenSize = screen.getScreenSize();
                        shell.setLocation(screenSize.width - shell.getWidth(), screenSize.height - shell.getHeight() - 30);
                        shell.setVisible(true);
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error("Error while closing RecordConsole", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("Error while closing RecordConsole", (Throwable)e);
            }
        }
    }

    private void initialize() {
        shell.setSize(480, 235);
        shell.setResizable(true);
        shell.setDefaultCloseOperation(2);
    }

    public void setCheckLabel(boolean check) {
        if (shell != null) {
            shell.setCheckLabel(check);
        }
    }

    public void setRecordedAction(String recAction) {
        if (shell != null) {
            shell.appendTextArea(" - " + recAction);
        }
    }

    public void setRecordedActionFailed() {
        if (shell != null) {
            shell.appendTextArea("Info: UserAction not Recorded...");
        }
    }

    public void setExtraMessage(String extraMsg) {
        if (shell != null) {
            shell.appendTextArea("Info: " + extraMsg);
        }
    }

    public void closeShell() {
        if (shell != null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        shell.dispose();
                        shell = null;
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error("Error while closing RecordConsole", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("Error while closing RecordConsole", (Throwable)e);
            }
        }
    }

    public static ObservationConsoleBP getInstance() {
        if (instance == null) {
            instance = new ObservationConsoleBP();
        }
        return instance;
    }
}

