/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.monitoring.IMonitoring;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.RestartAutMessage;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartAutCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(RestartAutCommand.class);
    private RestartAutMessage m_message;
    private MonitoringDataStore m_cm = MonitoringDataStore.getInstance();

    public Message execute() {
        AutIdentifier autId = this.m_message.getAutId();
        String monitoringId = this.m_cm.getConfigValue(autId.getExecutableName(), "MONITORING_AGENT_ID");
        if (!StringUtils.isEmpty((String)monitoringId)) {
            this.invokeMonitoringRestartMethod();
        }
        AutStarter.getInstance().getAgent().restartAut(autId, this.m_message.getTimeout());
        return null;
    }

    private void invokeMonitoringRestartMethod() {
        IMonitoring agent = this.m_cm.getMonitoringAgent(this.m_message.getAutId().getExecutableName());
        agent.autRestartOccurred();
    }

    public RestartAutMessage getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (RestartAutMessage)message;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + "timeout() called");
    }
}

