/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.contentassist.AutoImportProposal;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProposal;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPMethodCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class JSPProposalCollector
extends CompletionProposalCollector {
    private JSPTranslation fTranslation;
    private Comparator fComparator;
    private IImportContainer fImportContainer;

    public JSPProposalCollector(ICompilationUnit cu, JSPTranslation translation) {
        super(cu);
        if (translation == null) {
            throw new IllegalArgumentException("JSPTranslation cannot be null");
        }
        this.fTranslation = translation;
        this.fImportContainer = cu.getImportContainer();
    }

    public JSPCompletionProposal[] getJSPCompletionProposals() {
        ArrayList<IJavaCompletionProposal> results = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] javaProposals = this.getJavaCompletionProposals();
        int i = 0;
        while (i < javaProposals.length) {
            if (javaProposals[i] instanceof JSPCompletionProposal) {
                results.add(javaProposals[i]);
            }
            ++i;
        }
        Collections.sort(results, this.getComparator());
        return results.toArray(new JSPCompletionProposal[results.size()]);
    }

    private Comparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new CompletionProposalComparator();
        }
        return this.fComparator;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        JSPCompletionProposal jspProposal = null;
        if (!proposal.isConstructor()) {
            int kind = proposal.getKind();
            if (proposal.getKind() == 9 && JSPUIPlugin.getDefault().getPreferenceStore().getBoolean("autoImportinsertion")) {
                String signature = String.valueOf(proposal.getDeclarationSignature());
                String completion = String.valueOf(proposal.getCompletion());
                if (completion.indexOf(String.valueOf(signature) + ".") != -1) {
                    jspProposal = this.createAutoImportProposal(proposal);
                }
            } else if (kind == 6) {
                jspProposal = this.createMethodProposal(proposal);
            }
            if (jspProposal == null) {
                jspProposal = this.createJspProposal(proposal);
            }
        }
        return jspProposal;
    }

    private String getTypeName(String fullName) {
        int index = fullName.lastIndexOf(46);
        return index != -1 ? fullName.substring(index + 1) : fullName;
    }

    private JSPCompletionProposal createAutoImportProposal(CompletionProposal proposal) {
        AutoImportProposal jspProposal = null;
        String completion = new String(proposal.getCompletion());
        String newCompletion = this.getTypeName(completion);
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        offset = this.fTranslation.getJspOffset(offset);
        int positionAfter = this.calculatePositionAfter(proposal, newCompletion, offset);
        IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
        proposal.getDeclarationSignature();
        Image image = javaProposal.getImage();
        String displayString = javaProposal.getDisplayString();
        displayString = this.getTranslation().fixupMangledName(displayString);
        IContextInformation contextInformation = javaProposal.getContextInformation();
        int relevance = javaProposal.getRelevance();
        boolean updateLengthOnValidate = true;
        jspProposal = new AutoImportProposal(completion, this.fImportContainer, newCompletion, offset, length, positionAfter, image, displayString, contextInformation, null, relevance, updateLengthOnValidate);
        jspProposal.setJavaCompletionProposal((ICompletionProposal)javaProposal);
        return jspProposal;
    }

    private JSPCompletionProposal createJspProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        offset = this.fTranslation.getJspOffset(offset);
        int positionAfter = this.calculatePositionAfter(proposal, completion, offset);
        IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
        proposal.getDeclarationSignature();
        Image image = javaProposal.getImage();
        String displayString = javaProposal.getDisplayString();
        displayString = this.getTranslation().fixupMangledName(displayString);
        IContextInformation contextInformation = javaProposal.getContextInformation();
        if (contextInformation instanceof IContextInformationExtension) {
            contextInformation = new JavaContextInformationWrapper(contextInformation);
        }
        int relevance = javaProposal.getRelevance();
        boolean updateLengthOnValidate = true;
        JSPCompletionProposal jspProposal = new JSPCompletionProposal(completion, offset, length, positionAfter, image, displayString, contextInformation, null, relevance, updateLengthOnValidate);
        jspProposal.setJavaCompletionProposal((ICompletionProposal)javaProposal);
        return jspProposal;
    }

    private JSPCompletionProposal createMethodProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        offset = this.fTranslation.getJspOffset(offset);
        int positionAfter = this.calculatePositionAfter(proposal, completion, offset);
        IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
        proposal.getDeclarationSignature();
        Image image = javaProposal.getImage();
        String displayString = javaProposal.getDisplayString();
        displayString = this.getTranslation().fixupMangledName(displayString);
        IContextInformation contextInformation = javaProposal.getContextInformation();
        if (contextInformation instanceof IContextInformationExtension) {
            contextInformation = new JavaContextInformationWrapper(contextInformation);
        }
        int relevance = javaProposal.getRelevance();
        boolean updateLengthOnValidate = true;
        JSPMethodCompletionProposal jspProposal = new JSPMethodCompletionProposal(proposal, this.fTranslation.getJavaProject(), completion, offset, length, positionAfter, image, displayString, contextInformation, null, relevance, updateLengthOnValidate);
        jspProposal.setJavaCompletionProposal((ICompletionProposal)javaProposal);
        return jspProposal;
    }

    private int calculatePositionAfter(CompletionProposal proposal, String completion, int currentCursorOffset) {
        int positionAfter = completion.length();
        int kind = proposal.getKind();
        if (kind == 1 || kind == 7 || kind == 11 || kind == 6) {
            String[] params = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
            if (completion.length() > 0 && params.length > 0) {
                --positionAfter;
            }
        }
        return positionAfter;
    }

    static char[] getTypeTriggers() {
        return TYPE_TRIGGERS;
    }

    public JSPTranslation getTranslation() {
        return this.fTranslation;
    }

    private class JavaContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private IContextInformation contextInformation;

        public JavaContextInformationWrapper(IContextInformation contextInformation) {
            this.contextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.contextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.contextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.contextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return JSPProposalCollector.this.fTranslation.getJspOffset(((IContextInformationExtension)this.contextInformation).getContextInformationPosition());
        }
    }
}

