/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.java.NullJavaCacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheIsolationType2_2;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTimeOfDay;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaNonEmbeddableTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaTimeOfDay;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ExistenceCheckingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.TimeOfDayAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.validation.JptJpaEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class EclipseLinkJavaCachingImpl
extends AbstractJavaContextModel<EclipseLinkJavaNonEmbeddableTypeMapping>
implements EclipseLinkJavaCaching,
JavaCacheableReference2_0 {
    protected EclipseLinkCacheType specifiedType;
    protected Integer specifiedSize;
    protected Boolean specifiedShared;
    protected Boolean specifiedAlwaysRefresh;
    protected Boolean specifiedRefreshOnlyIfNewer;
    protected Boolean specifiedDisableHits;
    protected EclipseLinkCacheCoordinationType specifiedCoordinationType;
    protected Integer expiry;
    protected EclipseLinkJavaTimeOfDay expiryTimeOfDay;
    protected boolean existenceChecking;
    protected EclipseLinkExistenceType specifiedExistenceType;
    protected EclipseLinkExistenceType defaultExistenceType;
    protected final Cacheable2_0 cacheable;
    protected EclipseLinkCacheIsolationType2_2 specifiedIsolation;

    public EclipseLinkJavaCachingImpl(EclipseLinkJavaNonEmbeddableTypeMapping parent) {
        super((JpaContextModel)parent);
        CacheAnnotation cacheAnnotation = this.getCacheAnnotation();
        this.specifiedType = EclipseLinkCacheType.fromJavaResourceModel(cacheAnnotation.getType());
        this.specifiedSize = cacheAnnotation.getSize();
        this.specifiedShared = cacheAnnotation.getShared();
        this.specifiedAlwaysRefresh = cacheAnnotation.getAlwaysRefresh();
        this.specifiedRefreshOnlyIfNewer = cacheAnnotation.getRefreshOnlyIfNewer();
        this.specifiedDisableHits = cacheAnnotation.getDisableHits();
        this.specifiedCoordinationType = EclipseLinkCacheCoordinationType.fromJavaResourceModel(cacheAnnotation.getCoordinationType());
        this.expiry = cacheAnnotation.getExpiry();
        this.expiryTimeOfDay = this.buildExpiryTimeOfDay(cacheAnnotation.getExpiryTimeOfDay());
        ExistenceCheckingAnnotation ecAnnotation = this.getExistenceCheckingAnnotation();
        this.existenceChecking = ecAnnotation != null;
        this.specifiedExistenceType = this.buildSpecifiedExistenceType(ecAnnotation);
        this.cacheable = this.buildCacheable();
        this.specifiedIsolation = EclipseLinkCacheIsolationType2_2.fromJavaResourceModel(cacheAnnotation.getIsolation());
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        CacheAnnotation cacheAnnotation = this.getCacheAnnotation();
        this.setSpecifiedType_(EclipseLinkCacheType.fromJavaResourceModel(cacheAnnotation.getType()));
        this.setSpecifiedSize_(cacheAnnotation.getSize());
        this.setSpecifiedShared_(cacheAnnotation.getShared());
        this.setSpecifiedAlwaysRefresh_(cacheAnnotation.getAlwaysRefresh());
        this.setSpecifiedRefreshOnlyIfNewer_(cacheAnnotation.getRefreshOnlyIfNewer());
        this.setSpecifiedDisableHits_(cacheAnnotation.getDisableHits());
        this.setSpecifiedCoordinationType_(EclipseLinkCacheCoordinationType.fromJavaResourceModel(cacheAnnotation.getCoordinationType()));
        this.setExpiry_(cacheAnnotation.getExpiry());
        this.syncExpiryTimeOfDay(cacheAnnotation.getExpiryTimeOfDay(), monitor);
        ExistenceCheckingAnnotation ecAnnotation = this.getExistenceCheckingAnnotation();
        this.setExistenceChecking_(ecAnnotation != null);
        this.setSpecifiedExistenceType_(this.buildSpecifiedExistenceType(ecAnnotation));
        this.cacheable.synchronizeWithResourceModel(monitor);
        this.setSpecifiedIsolation_(EclipseLinkCacheIsolationType2_2.fromJavaResourceModel(cacheAnnotation.getIsolation()));
    }

    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        if (this.expiryTimeOfDay != null) {
            this.expiryTimeOfDay.update(monitor);
        }
        this.setDefaultExistenceType(this.buildDefaultExistenceType());
        this.cacheable.update(monitor);
    }

    @Override
    public EclipseLinkCacheType getType() {
        return this.specifiedType != null ? this.specifiedType : this.getDefaultType();
    }

    @Override
    public EclipseLinkCacheType getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(EclipseLinkCacheType type) {
        this.getCacheAnnotation().setType(EclipseLinkCacheType.toJavaResourceModel(type));
        this.setSpecifiedType_(type);
        if (type != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedType_(EclipseLinkCacheType type) {
        EclipseLinkCacheType old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", (Object)old, (Object)type);
    }

    @Override
    public EclipseLinkCacheType getDefaultType() {
        String puDefaultCacheTypeName = ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getDefaultCacheTypePropertyValue();
        if (!StringTools.isBlank((String)puDefaultCacheTypeName)) {
            try {
                return EclipseLinkCacheType.valueOf(StringTools.convertCamelCaseToAllCaps((String)puDefaultCacheTypeName));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return DEFAULT_TYPE;
    }

    @Override
    public int getSize() {
        return this.specifiedSize != null ? this.specifiedSize.intValue() : this.getDefaultSize();
    }

    @Override
    public Integer getSpecifiedSize() {
        return this.specifiedSize;
    }

    @Override
    public void setSpecifiedSize(Integer size) {
        this.getCacheAnnotation().setSize(size);
        this.setSpecifiedSize_(size);
        if (size != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedSize_(Integer size) {
        Integer old = this.specifiedSize;
        this.specifiedSize = size;
        this.firePropertyChanged("specifiedSize", old, size);
    }

    @Override
    public int getDefaultSize() {
        String puDefaultCacheSize = ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getDefaultCacheSizePropertyValue();
        if (!StringTools.isBlank((String)puDefaultCacheSize)) {
            try {
                return Integer.valueOf(puDefaultCacheSize);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 100;
    }

    @Override
    public boolean isShared() {
        return this.specifiedShared != null ? this.specifiedShared.booleanValue() : this.isDefaultShared();
    }

    @Override
    public Boolean getSpecifiedShared() {
        return this.specifiedShared;
    }

    @Override
    public void setSpecifiedShared(Boolean shared) {
        this.getCacheAnnotation().setShared(shared);
        this.setSpecifiedShared_(shared);
        if (shared != null && !shared.booleanValue()) {
            this.setSpecifiedType(null);
            this.setSpecifiedSize(null);
            this.setSpecifiedAlwaysRefresh(null);
            this.setSpecifiedRefreshOnlyIfNewer(null);
            this.setSpecifiedDisableHits(null);
            this.setSpecifiedCoordinationType(null);
            this.setExpiry(null);
            this.removeExpiryTimeOfDayIfNecessary();
        }
    }

    protected void setSpecifiedShared_(Boolean shared) {
        Boolean old = this.specifiedShared;
        this.specifiedShared = shared;
        this.firePropertyChanged("specifiedShared", old, shared);
    }

    @Override
    public boolean isDefaultShared() {
        String puDefaultSharedCache = ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getDefaultCacheSharedPropertyValue();
        return !StringTools.isBlank((String)puDefaultSharedCache) ? Boolean.valueOf(puDefaultSharedCache) : true;
    }

    @Override
    public boolean isAlwaysRefresh() {
        return this.specifiedAlwaysRefresh != null ? this.specifiedAlwaysRefresh.booleanValue() : this.isDefaultAlwaysRefresh();
    }

    @Override
    public Boolean getSpecifiedAlwaysRefresh() {
        return this.specifiedAlwaysRefresh;
    }

    @Override
    public void setSpecifiedAlwaysRefresh(Boolean alwaysRefresh) {
        this.getCacheAnnotation().setAlwaysRefresh(alwaysRefresh);
        this.setSpecifiedAlwaysRefresh_(alwaysRefresh);
        if (alwaysRefresh != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedAlwaysRefresh_(Boolean alwaysRefresh) {
        Boolean old = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = alwaysRefresh;
        this.firePropertyChanged("specifiedAlwaysRefresh", old, alwaysRefresh);
    }

    @Override
    public boolean isDefaultAlwaysRefresh() {
        return false;
    }

    @Override
    public boolean isRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer != null ? this.specifiedRefreshOnlyIfNewer.booleanValue() : this.isDefaultRefreshOnlyIfNewer();
    }

    @Override
    public Boolean getSpecifiedRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer;
    }

    @Override
    public void setSpecifiedRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        this.getCacheAnnotation().setRefreshOnlyIfNewer(refreshOnlyIfNewer);
        this.setSpecifiedRefreshOnlyIfNewer_(refreshOnlyIfNewer);
        if (refreshOnlyIfNewer != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedRefreshOnlyIfNewer_(Boolean refreshOnlyIfNewer) {
        Boolean old = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = refreshOnlyIfNewer;
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", old, refreshOnlyIfNewer);
    }

    @Override
    public boolean isDefaultRefreshOnlyIfNewer() {
        return false;
    }

    @Override
    public boolean isDisableHits() {
        return this.specifiedDisableHits != null ? this.specifiedDisableHits.booleanValue() : this.isDefaultDisableHits();
    }

    @Override
    public Boolean getSpecifiedDisableHits() {
        return this.specifiedDisableHits;
    }

    @Override
    public void setSpecifiedDisableHits(Boolean disableHits) {
        this.getCacheAnnotation().setDisableHits(disableHits);
        this.setSpecifiedDisableHits_(disableHits);
        if (disableHits != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedDisableHits_(Boolean disableHits) {
        Boolean old = this.specifiedDisableHits;
        this.specifiedDisableHits = disableHits;
        this.firePropertyChanged("specifiedDisableHits", old, disableHits);
    }

    @Override
    public boolean isDefaultDisableHits() {
        return false;
    }

    @Override
    public EclipseLinkCacheCoordinationType getCoordinationType() {
        return this.specifiedCoordinationType != null ? this.specifiedCoordinationType : this.getDefaultCoordinationType();
    }

    @Override
    public EclipseLinkCacheCoordinationType getSpecifiedCoordinationType() {
        return this.specifiedCoordinationType;
    }

    @Override
    public void setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType type) {
        this.getCacheAnnotation().setCoordinationType(EclipseLinkCacheCoordinationType.toJavaResourceModel(type));
        this.setSpecifiedCoordinationType_(type);
        if (type != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedCoordinationType_(EclipseLinkCacheCoordinationType type) {
        EclipseLinkCacheCoordinationType old = this.specifiedCoordinationType;
        this.specifiedCoordinationType = type;
        this.firePropertyChanged("specifiedCoordinationType", (Object)old, (Object)type);
    }

    @Override
    public EclipseLinkCacheCoordinationType getDefaultCoordinationType() {
        return DEFAULT_COORDINATION_TYPE;
    }

    @Override
    public Integer getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(Integer expiry) {
        this.getCacheAnnotation().setExpiry(expiry);
        this.setExpiry_(expiry);
        if (expiry != null) {
            this.removeExpiryTimeOfDayIfNecessary();
            this.setSpecifiedShared(null);
        }
    }

    protected void setExpiry_(Integer expiry) {
        Integer old = this.expiry;
        this.expiry = expiry;
        this.firePropertyChanged("expiry", old, expiry);
    }

    @Override
    public EclipseLinkTimeOfDay getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    @Override
    public EclipseLinkTimeOfDay addExpiryTimeOfDay() {
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("expiry time of day already exists: " + this.expiryTimeOfDay);
        }
        TimeOfDayAnnotation timeOfDayAnnotation = this.getCacheAnnotation().addExpiryTimeOfDay();
        EclipseLinkJavaTimeOfDay timeOfDay = this.buildExpiryTimeOfDay(timeOfDayAnnotation);
        this.setExpiryTimeOfDay(timeOfDay);
        this.setExpiry(null);
        this.setSpecifiedShared(null);
        return timeOfDay;
    }

    @Override
    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("expiry time of day does not exist");
        }
        this.removeExpiryTimeOfDay_();
    }

    protected void removeExpiryTimeOfDayIfNecessary() {
        if (this.expiryTimeOfDay != null) {
            this.removeExpiryTimeOfDay_();
        }
    }

    protected void removeExpiryTimeOfDay_() {
        this.getCacheAnnotation().removeExpiryTimeOfDay();
        this.setExpiryTimeOfDay(null);
    }

    public void setExpiryTimeOfDay(EclipseLinkJavaTimeOfDay timeOfDay) {
        EclipseLinkJavaTimeOfDay old = this.expiryTimeOfDay;
        this.expiryTimeOfDay = timeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", old, timeOfDay);
    }

    protected void syncExpiryTimeOfDay(TimeOfDayAnnotation timeOfDayAnnotation, IProgressMonitor monitor) {
        if (timeOfDayAnnotation == null) {
            if (this.expiryTimeOfDay != null) {
                this.setExpiryTimeOfDay(null);
            }
        } else if (this.expiryTimeOfDay != null && this.expiryTimeOfDay.getTimeOfDayAnnotation() == timeOfDayAnnotation) {
            this.expiryTimeOfDay.synchronizeWithResourceModel(monitor);
        } else {
            this.setExpiryTimeOfDay(this.buildExpiryTimeOfDay(timeOfDayAnnotation));
        }
    }

    protected EclipseLinkJavaTimeOfDay buildExpiryTimeOfDay(TimeOfDayAnnotation timeOfDayAnnotation) {
        return timeOfDayAnnotation == null ? null : new EclipseLinkJavaTimeOfDay(this, timeOfDayAnnotation);
    }

    @Override
    public boolean isExistenceChecking() {
        return this.existenceChecking;
    }

    @Override
    public void setExistenceChecking(boolean existenceChecking) {
        if (existenceChecking != this.existenceChecking) {
            if (existenceChecking) {
                this.addExistenceCheckingAnnotation();
            } else {
                this.setSpecifiedExistenceType(null);
                this.removeExistenceCheckingAnnotation();
            }
            this.setExistenceChecking_(existenceChecking);
        }
    }

    protected void setExistenceChecking_(boolean existenceChecking) {
        boolean old = this.existenceChecking;
        this.existenceChecking = existenceChecking;
        this.firePropertyChanged("existenceChecking", old, existenceChecking);
    }

    @Override
    public EclipseLinkExistenceType getExistenceType() {
        return this.specifiedExistenceType != null ? this.specifiedExistenceType : this.defaultExistenceType;
    }

    @Override
    public EclipseLinkExistenceType getSpecifiedExistenceType() {
        return this.specifiedExistenceType;
    }

    @Override
    public void setSpecifiedExistenceType(EclipseLinkExistenceType type) {
        if (ObjectTools.notEquals((Object)((Object)type), (Object)((Object)this.specifiedExistenceType))) {
            if (type != null) {
                this.setExistenceChecking(true);
            }
            this.getExistenceCheckingAnnotation().setValue(EclipseLinkExistenceType.toJavaResourceModel(type));
            this.setSpecifiedExistenceType_(type);
        }
    }

    protected void setSpecifiedExistenceType_(EclipseLinkExistenceType type) {
        EclipseLinkExistenceType old = this.specifiedExistenceType;
        this.specifiedExistenceType = type;
        this.firePropertyChanged("specifiedExistenceType", (Object)old, (Object)type);
    }

    protected EclipseLinkExistenceType buildSpecifiedExistenceType(ExistenceCheckingAnnotation ecAnnotation) {
        return ecAnnotation == null ? null : EclipseLinkExistenceType.fromJavaResourceModel(ecAnnotation.getValue());
    }

    @Override
    public EclipseLinkExistenceType getDefaultExistenceType() {
        return this.defaultExistenceType;
    }

    protected void setDefaultExistenceType(EclipseLinkExistenceType type) {
        EclipseLinkExistenceType old = this.defaultExistenceType;
        this.defaultExistenceType = type;
        this.firePropertyChanged("defaultExistenceType", (Object)old, (Object)type);
    }

    protected EclipseLinkExistenceType buildDefaultExistenceType() {
        return this.existenceChecking ? EclipseLinkExistenceType.CHECK_CACHE : DEFAULT_EXISTENCE_TYPE;
    }

    public Cacheable2_0 getCacheable() {
        return this.cacheable;
    }

    public boolean calculateDefaultCacheable() {
        CacheableReference2_0 superCacheableHolder = this.getCacheableSuperPersistentType((PersistentType)this.getPersistentType());
        return superCacheableHolder != null ? superCacheableHolder.getCacheable().isCacheable() : ((PersistenceUnit2_0)this.getPersistenceUnit()).calculateDefaultCacheable();
    }

    protected CacheableReference2_0 getCacheableSuperPersistentType(PersistentType persistentType) {
        PersistentType superPersistentType = persistentType.getSuperPersistentType();
        if (superPersistentType == null) {
            return null;
        }
        TypeMapping superMapping = superPersistentType.getMapping();
        return superMapping instanceof CacheableReference2_0 ? (CacheableReference2_0)superMapping : this.getCacheableSuperPersistentType(superPersistentType);
    }

    protected Cacheable2_0 buildCacheable() {
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildJavaCacheable((JavaCacheableReference2_0)this) : new NullJavaCacheable2_0((JavaCacheableReference2_0)this);
    }

    @Override
    public EclipseLinkCacheIsolationType2_2 getIsolation() {
        return this.specifiedIsolation != null ? this.specifiedIsolation : this.getDefaultIsolation();
    }

    @Override
    public EclipseLinkCacheIsolationType2_2 getSpecifiedIsolation() {
        return this.specifiedIsolation;
    }

    @Override
    public void setSpecifiedIsolation(EclipseLinkCacheIsolationType2_2 isolation) {
        this.getCacheAnnotation().setIsolation(EclipseLinkCacheIsolationType2_2.toJavaResourceModel(isolation));
        this.setSpecifiedIsolation_(isolation);
        if (isolation != null) {
            this.setSpecifiedShared(null);
        }
    }

    protected void setSpecifiedIsolation_(EclipseLinkCacheIsolationType2_2 isolation) {
        EclipseLinkCacheIsolationType2_2 old = this.specifiedIsolation;
        this.specifiedIsolation = isolation;
        this.firePropertyChanged("specifiedIsolation", (Object)old, (Object)isolation);
    }

    @Override
    public EclipseLinkCacheIsolationType2_2 getDefaultIsolation() {
        return DEFAULT_ISOLATION;
    }

    protected CacheAnnotation getCacheAnnotation() {
        return (CacheAnnotation)this.getJavaResourceType().getNonNullAnnotation(this.getCacheAnnotationName());
    }

    protected String getCacheAnnotationName() {
        return "org.eclipse.persistence.annotations.Cache";
    }

    protected ExistenceCheckingAnnotation getExistenceCheckingAnnotation() {
        return (ExistenceCheckingAnnotation)this.getJavaResourceType().getAnnotation(this.getExistenceCheckingAnnotationName());
    }

    protected ExistenceCheckingAnnotation addExistenceCheckingAnnotation() {
        return (ExistenceCheckingAnnotation)this.getJavaResourceType().addAnnotation(this.getExistenceCheckingAnnotationName());
    }

    protected void removeExistenceCheckingAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getExistenceCheckingAnnotationName());
    }

    protected String getExistenceCheckingAnnotationName() {
        return "org.eclipse.persistence.annotations.ExistenceChecking";
    }

    protected EclipseLinkJavaNonEmbeddableTypeMapping getTypeMapping() {
        return (EclipseLinkJavaNonEmbeddableTypeMapping)this.parent;
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    public JavaResourceType getJavaResourceType() {
        return this.getTypeMapping().getJavaResourceType();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateExpiry(messages);
    }

    protected void validateExpiry(List<IMessage> messages) {
        if (this.expiry != null && this.expiryTimeOfDay != null) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaEclipseLinkCoreValidationMessages.CACHE_EXPIRY_AND_EXPIRY_TIME_OF_DAY_BOTH_SPECIFIED, new Object[]{this.getPersistentType().getName()}));
        }
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getCacheAnnotation().getTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }
}

