/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToManyAnnotation2_0;

public final class SourceOneToManyAnnotation
extends SourceRelationshipMappingAnnotation
implements OneToManyAnnotation2_0 {
    protected static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OneToMany");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceOneToManyAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceOneToManyAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceOneToManyAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = SourceOneToManyAnnotation.buildMappedByAdapter();
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private String mappedBy;
    private TextRange mappedByTextRange;
    private static final DeclarationAnnotationElementAdapter<Boolean> ORPHAN_REMOVAL_ADAPTER = SourceOneToManyAnnotation.buildOrphanRemovalAdapter();
    private final AnnotationElementAdapter<Boolean> orphanRemovalAdapter = this.buildBooleanAnnotationElementAdapter(ORPHAN_REMOVAL_ADAPTER);
    private Boolean orphanRemoval;
    private TextRange orphanRemovalTextRange;

    public SourceOneToManyAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.OneToMany";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.mappedBy = this.buildMappedBy(astAnnotation);
        this.mappedByTextRange = this.buildMappedByTextRange(astAnnotation);
        this.orphanRemoval = this.buildOrphanRemoval(astAnnotation);
        this.orphanRemovalTextRange = this.buildOrphanRemovalTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncMappedBy(this.buildMappedBy(astAnnotation));
        this.mappedByTextRange = this.buildMappedByTextRange(astAnnotation);
        this.syncOrphanRemoval(this.buildOrphanRemoval(astAnnotation));
        this.orphanRemovalTextRange = this.buildOrphanRemovalTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.mappedBy == null && this.orphanRemoval == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        if (ObjectTools.notEquals((Object)this.mappedBy, (Object)mappedBy)) {
            this.mappedBy = mappedBy;
            this.mappedByAdapter.setValue((Object)mappedBy);
        }
    }

    private void syncMappedBy(String astMappedBy) {
        String old = this.mappedBy;
        this.mappedBy = astMappedBy;
        this.firePropertyChanged("mappedBy", old, astMappedBy);
    }

    private String buildMappedBy(Annotation astAnnotation) {
        return (String)this.mappedByAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getMappedByTextRange() {
        return this.mappedByTextRange;
    }

    private TextRange buildMappedByTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astAnnotation);
    }

    @Override
    public boolean mappedByTouches(int pos) {
        return this.textRangeTouches(this.mappedByTextRange, pos);
    }

    @Override
    public Boolean getOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public void setOrphanRemoval(Boolean orphanRemoval) {
        if (ObjectTools.notEquals((Object)this.orphanRemoval, (Object)orphanRemoval)) {
            this.orphanRemoval = orphanRemoval;
            this.orphanRemovalAdapter.setValue((Object)orphanRemoval);
        }
    }

    private void syncOrphanRemoval(Boolean astOrphanRemoval) {
        Boolean old = this.orphanRemoval;
        this.orphanRemoval = astOrphanRemoval;
        this.firePropertyChanged("orphanRemoval", old, astOrphanRemoval);
    }

    @Override
    public TextRange getOrphanRemovalTextRange() {
        return this.orphanRemovalTextRange;
    }

    private TextRange buildOrphanRemovalTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(ORPHAN_REMOVAL_ADAPTER, astAnnotation);
    }

    private Boolean buildOrphanRemoval(Annotation astAnnotation) {
        return (Boolean)this.orphanRemovalAdapter.getValue(astAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceOneToManyAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"mappedBy");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceOneToManyAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceOneToManyAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter() {
        return SourceOneToManyAnnotation.buildOrphanRemovalAdapter(DECLARATION_ANNOTATION_ADAPTER, "orphanRemoval");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }
}

