/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.VirtualBaseColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedBaseColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.jpa.core.resource.java.BaseColumnAnnotation;

public abstract class AbstractJavaBaseColumn<PA extends TableColumn.ParentAdapter, A extends BaseColumnAnnotation>
extends AbstractJavaNamedColumn<PA, A>
implements JavaSpecifiedBaseColumn {
    protected String specifiedTableName;
    protected String defaultTableName = this.buildDefaultTableName();
    protected Boolean specifiedUnique;
    protected boolean defaultUnique = this.buildDefaultUnique();
    protected Boolean specifiedNullable;
    protected boolean defaultNullable = this.buildDefaultNullable();
    protected Boolean specifiedInsertable;
    protected boolean defaultInsertable = this.buildDefaultInsertable();
    protected Boolean specifiedUpdatable;
    protected boolean defaultUpdatable = this.buildDefaultUpdatable();

    protected AbstractJavaBaseColumn(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractJavaBaseColumn(PA parentAdapter, A columnAnnotation) {
        super(parentAdapter, columnAnnotation);
    }

    @Override
    protected void initialize(A columnAnnotation) {
        super.initialize(columnAnnotation);
        this.specifiedTableName = this.buildSpecifiedTableName(columnAnnotation);
        this.specifiedUnique = this.buildSpecifiedUnique(columnAnnotation);
        this.specifiedNullable = this.buildSpecifiedNullable(columnAnnotation);
        this.specifiedInsertable = this.buildSpecifiedInsertable(columnAnnotation);
        this.specifiedUpdatable = this.buildSpecifiedUpdatable(columnAnnotation);
    }

    @Override
    protected void synchronizeWithResourceModel(A columnAnnotation) {
        super.synchronizeWithResourceModel(columnAnnotation);
        this.setSpecifiedTableName_(this.buildSpecifiedTableName(columnAnnotation));
        this.setSpecifiedUnique_(this.buildSpecifiedUnique(columnAnnotation));
        this.setSpecifiedNullable_(this.buildSpecifiedNullable(columnAnnotation));
        this.setSpecifiedInsertable_(this.buildSpecifiedInsertable(columnAnnotation));
        this.setSpecifiedUpdatable_(this.buildSpecifiedUpdatable(columnAnnotation));
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultTableName(this.buildDefaultTableName());
        this.setDefaultUnique(this.buildDefaultUnique());
        this.setDefaultNullable(this.buildDefaultNullable());
        this.setDefaultInsertable(this.buildDefaultInsertable());
        this.setDefaultUpdatable(this.buildDefaultUpdatable());
    }

    @Override
    public String getTableName() {
        return this.specifiedTableName != null ? this.specifiedTableName : this.defaultTableName;
    }

    @Override
    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    @Override
    public void setSpecifiedTableName(String tableName) {
        if (ObjectTools.notEquals((Object)this.specifiedTableName, (Object)tableName)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setTable(tableName);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedTableName_(tableName);
        }
    }

    protected void setSpecifiedTableName_(String tableName) {
        String old = this.specifiedTableName;
        this.specifiedTableName = tableName;
        this.firePropertyChanged("specifiedTableName", old, tableName);
    }

    protected String buildSpecifiedTableName(A columnAnnotation) {
        return columnAnnotation.getTable();
    }

    @Override
    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    protected void setDefaultTableName(String tableName) {
        String old = this.defaultTableName;
        this.defaultTableName = tableName;
        this.firePropertyChanged("defaultTable", old, tableName);
    }

    protected String buildDefaultTableName() {
        return ((TableColumn.ParentAdapter)this.parentAdapter).getDefaultTableName();
    }

    @Override
    public TextRange getTableNameValidationTextRange() {
        return this.getValidationTextRange(((BaseColumnAnnotation)this.getColumnAnnotation()).getTableTextRange());
    }

    @Override
    public boolean isUnique() {
        return this.specifiedUnique != null ? this.specifiedUnique.booleanValue() : this.isDefaultUnique();
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean unique) {
        if (ObjectTools.notEquals((Object)this.specifiedUnique, (Object)unique)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setUnique(unique);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedUnique_(unique);
        }
    }

    protected void setSpecifiedUnique_(Boolean unique) {
        Boolean old = this.specifiedUnique;
        this.specifiedUnique = unique;
        this.firePropertyChanged("specifiedUnique", old, unique);
    }

    protected Boolean buildSpecifiedUnique(A columnAnnotation) {
        return columnAnnotation.getUnique();
    }

    @Override
    public boolean isDefaultUnique() {
        return this.defaultUnique;
    }

    protected void setDefaultUnique(boolean unique) {
        boolean old = this.defaultUnique;
        this.defaultUnique = unique;
        this.firePropertyChanged("defaultUnique", old, unique);
    }

    protected boolean buildDefaultUnique() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.specifiedNullable != null ? this.specifiedNullable.booleanValue() : this.isDefaultNullable();
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean nullable) {
        if (ObjectTools.notEquals((Object)this.specifiedNullable, (Object)nullable)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setNullable(nullable);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedNullable_(nullable);
        }
    }

    protected void setSpecifiedNullable_(Boolean nullable) {
        Boolean old = this.specifiedNullable;
        this.specifiedNullable = nullable;
        this.firePropertyChanged("specifiedNullable", old, nullable);
    }

    protected Boolean buildSpecifiedNullable(A columnAnnotation) {
        return columnAnnotation.getNullable();
    }

    @Override
    public boolean isDefaultNullable() {
        return this.defaultNullable;
    }

    protected void setDefaultNullable(boolean nullable) {
        boolean old = this.defaultNullable;
        this.defaultNullable = nullable;
        this.firePropertyChanged("defaultNullable", old, nullable);
    }

    protected boolean buildDefaultNullable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return this.specifiedInsertable != null ? this.specifiedInsertable.booleanValue() : this.isDefaultInsertable();
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean insertable) {
        if (ObjectTools.notEquals((Object)this.specifiedInsertable, (Object)insertable)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setInsertable(insertable);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedInsertable_(insertable);
        }
    }

    protected void setSpecifiedInsertable_(Boolean insertable) {
        Boolean old = this.specifiedInsertable;
        this.specifiedInsertable = insertable;
        this.firePropertyChanged("specifiedInsertable", old, insertable);
    }

    protected Boolean buildSpecifiedInsertable(A columnAnnotation) {
        return columnAnnotation.getInsertable();
    }

    @Override
    public boolean isDefaultInsertable() {
        return this.defaultInsertable;
    }

    protected void setDefaultInsertable(boolean insertable) {
        boolean old = this.defaultInsertable;
        this.defaultInsertable = insertable;
        this.firePropertyChanged("defaultInsertable", old, insertable);
    }

    protected boolean buildDefaultInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return this.specifiedUpdatable != null ? this.specifiedUpdatable.booleanValue() : this.isDefaultUpdatable();
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean updatable) {
        if (ObjectTools.notEquals((Object)this.specifiedUpdatable, (Object)updatable)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setUpdatable(updatable);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedUpdatable_(updatable);
        }
    }

    protected void setSpecifiedUpdatable_(Boolean updatable) {
        Boolean old = this.specifiedUpdatable;
        this.specifiedUpdatable = updatable;
        this.firePropertyChanged("specifiedUpdatable", old, updatable);
    }

    protected Boolean buildSpecifiedUpdatable(A columnAnnotation) {
        return columnAnnotation.getUpdatable();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return this.defaultUpdatable;
    }

    protected void setDefaultUpdatable(boolean updatable) {
        boolean old = this.defaultUpdatable;
        this.defaultUpdatable = updatable;
        this.firePropertyChanged("defaultUpdatable", old, updatable);
    }

    protected boolean buildDefaultUpdatable() {
        return true;
    }

    protected void initializeFrom(VirtualBaseColumn virtualColumn) {
        super.initializeFrom(virtualColumn);
        this.setSpecifiedTableName(virtualColumn.getTableName());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getJavaCandidateTableNames();
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).tableTouches(pos);
    }

    protected Iterable<String> getJavaCandidateTableNames() {
        return new TransformationIterable(this.getCandidateTableNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return ((TableColumn.ParentAdapter)this.parentAdapter).getCandidateTableNames();
    }

    @Override
    public boolean tableNameIsInvalid() {
        return ((TableColumn.ParentAdapter)this.parentAdapter).tableNameIsInvalid(this.getTableName());
    }
}

