/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;

@Command
class ReadReftable
extends TextBuiltin {
    @Argument(index=0)
    private String input;
    @Argument(index=1, required=false)
    private String ref;

    ReadReftable() {
    }

    @Override
    protected void run() throws Exception {
        try (FileInputStream in = new FileInputStream(this.input);
             BlockSource src = BlockSource.from((FileInputStream)in);
             ReftableReader reader = new ReftableReader(src);
             RefCursor rc = this.ref != null ? reader.seekRef(this.ref) : reader.allRefs();){
            while (rc.next()) {
                this.write(rc.getRef());
            }
        }
    }

    private void write(Ref r) throws IOException {
        ObjectId id2;
        if (r.isSymbolic()) {
            this.outw.println(r.getTarget().getName() + '\t' + r.getName());
            return;
        }
        ObjectId id1 = r.getObjectId();
        if (id1 != null) {
            this.outw.println(id1.name() + '\t' + r.getName());
        }
        if ((id2 = r.getPeeledObjectId()) != null) {
            this.outw.println('^' + id2.name());
        }
    }
}

