/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.lib;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.jgit.lfs.errors.InvalidLongObjectIdException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public final class AbbreviatedLongObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    final int nibbles;
    final long w1;
    final long w2;
    final long w3;
    final long w4;

    public static final boolean isId(String id) {
        if (id.length() < 2 || 64 < id.length()) {
            return false;
        }
        try {
            for (int i = 0; i < id.length(); ++i) {
                RawParseUtils.parseHexInt4((byte)((byte)id.charAt(i)));
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static final AbbreviatedLongObjectId fromString(byte[] buf, int offset, int end) {
        if (end - offset > 64) {
            throw new IllegalArgumentException(MessageFormat.format(LfsText.get().invalidLongIdLength, end - offset, 64));
        }
        return AbbreviatedLongObjectId.fromHexString(buf, offset, end);
    }

    public static final AbbreviatedLongObjectId fromLongObjectId(AnyLongObjectId id) {
        return new AbbreviatedLongObjectId(64, id.w1, id.w2, id.w3, id.w4);
    }

    public static final AbbreviatedLongObjectId fromString(String str) {
        if (str.length() > 64) {
            throw new IllegalArgumentException(MessageFormat.format(LfsText.get().invalidLongId, str));
        }
        byte[] b = Constants.encodeASCII((String)str);
        return AbbreviatedLongObjectId.fromHexString(b, 0, b.length);
    }

    private static final AbbreviatedLongObjectId fromHexString(byte[] bs, int ptr, int end) {
        try {
            long a = AbbreviatedLongObjectId.hexUInt64(bs, ptr, end);
            long b = AbbreviatedLongObjectId.hexUInt64(bs, ptr + 16, end);
            long c = AbbreviatedLongObjectId.hexUInt64(bs, ptr + 32, end);
            long d = AbbreviatedLongObjectId.hexUInt64(bs, ptr + 48, end);
            return new AbbreviatedLongObjectId(end - ptr, a, b, c, d);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new InvalidLongObjectIdException(bs, ptr, end - ptr);
        }
    }

    private static final long hexUInt64(byte[] bs, int p, int end) {
        int n;
        if (16 <= end - p) {
            return RawParseUtils.parseHexInt64((byte[])bs, (int)p);
        }
        long r = 0L;
        for (n = 0; n < 16 && p < end; ++n) {
            r <<= 4;
            r |= (long)RawParseUtils.parseHexInt4((byte)bs[p++]);
        }
        return r << (16 - n) * 4;
    }

    static long mask(int nibbles, long word, long v) {
        long b = (word - 1L) * 16L;
        if (b + 16L <= (long)nibbles) {
            return v;
        }
        if ((long)nibbles <= b) {
            return 0L;
        }
        long s = 64L - ((long)nibbles - b) * 4L;
        return v >>> (int)s << (int)s;
    }

    AbbreviatedLongObjectId(int n, long new_1, long new_2, long new_3, long new_4) {
        this.nibbles = n;
        this.w1 = new_1;
        this.w2 = new_2;
        this.w3 = new_3;
        this.w4 = new_4;
    }

    public int length() {
        return this.nibbles;
    }

    public boolean isComplete() {
        return this.length() == 64;
    }

    public LongObjectId toLongObjectId() {
        return this.isComplete() ? new LongObjectId(this.w1, this.w2, this.w3, this.w4) : null;
    }

    public final int prefixCompare(AnyLongObjectId other) {
        int cmp = NB.compareUInt64((long)this.w1, (long)this.mask(1L, other.w1));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w2, (long)this.mask(2L, other.w2));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w3, (long)this.mask(3L, other.w3));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt64((long)this.w4, (long)this.mask(4L, other.w4));
    }

    public final int prefixCompare(byte[] bs, int p) {
        int cmp = NB.compareUInt64((long)this.w1, (long)this.mask(1L, NB.decodeInt64((byte[])bs, (int)p)));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w2, (long)this.mask(2L, NB.decodeInt64((byte[])bs, (int)(p + 8))));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w3, (long)this.mask(3L, NB.decodeInt64((byte[])bs, (int)(p + 16))));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt64((long)this.w4, (long)this.mask(4L, NB.decodeInt64((byte[])bs, (int)(p + 24))));
    }

    public final int prefixCompare(long[] bs, int p) {
        int cmp = NB.compareUInt64((long)this.w1, (long)this.mask(1L, bs[p]));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w2, (long)this.mask(2L, bs[p + 1]));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w3, (long)this.mask(3L, bs[p + 2]));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt64((long)this.w4, (long)this.mask(4L, bs[p + 3]));
    }

    public final int getFirstByte() {
        return (int)(this.w1 >>> 56);
    }

    private long mask(long word, long v) {
        return AbbreviatedLongObjectId.mask(this.nibbles, word, v);
    }

    public int hashCode() {
        return (int)(this.w1 >> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof AbbreviatedLongObjectId) {
            AbbreviatedLongObjectId b = (AbbreviatedLongObjectId)o;
            return this.nibbles == b.nibbles && this.w1 == b.w1 && this.w2 == b.w2 && this.w3 == b.w3 && this.w4 == b.w4;
        }
        return false;
    }

    public final String name() {
        char[] b = new char[64];
        AnyLongObjectId.formatHexChar(b, 0, this.w1);
        if (this.nibbles <= 16) {
            return new String(b, 0, this.nibbles);
        }
        AnyLongObjectId.formatHexChar(b, 16, this.w2);
        if (this.nibbles <= 32) {
            return new String(b, 0, this.nibbles);
        }
        AnyLongObjectId.formatHexChar(b, 32, this.w3);
        if (this.nibbles <= 48) {
            return new String(b, 0, this.nibbles);
        }
        AnyLongObjectId.formatHexChar(b, 48, this.w4);
        return new String(b, 0, this.nibbles);
    }

    public String toString() {
        return "AbbreviatedLongObjectId[" + this.name() + "]";
    }
}

