/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.BaseFormat;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;

public final class TxzFormat
extends BaseFormat
implements ArchiveCommand.Format<ArchiveOutputStream> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".tar.xz", ".txz"));
    private final ArchiveCommand.Format<ArchiveOutputStream> tarFormat = new TarFormat();

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) throws IOException {
        return this.createArchiveOutputStream(s, Collections.emptyMap());
    }

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s, Map<String, Object> o) throws IOException {
        XZCompressorOutputStream out = new XZCompressorOutputStream(s);
        return (ArchiveOutputStream)this.tarFormat.createArchiveOutputStream((OutputStream)out, o);
    }

    @Deprecated
    public void putEntry(ArchiveOutputStream out, String path, FileMode mode, ObjectLoader loader) throws IOException {
        this.putEntry(out, null, path, mode, loader);
    }

    public void putEntry(ArchiveOutputStream out, ObjectId tree, String path, FileMode mode, ObjectLoader loader) throws IOException {
        this.tarFormat.putEntry((Closeable)out, tree, path, mode, loader);
    }

    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof TxzFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

