/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class JavaNavigatorActionProvider
extends CommonActionProvider {
    private OpenViewActionGroup fOpenViewGroup;
    private CCPActionGroup fCCPGroup;
    private JavaSearchActionGroup fSearchGroup;
    private GenerateBuildPathActionGroup fBuildPathGroup;
    private GenerateActionGroup fGenerateGroup;
    private boolean fInViewPart = false;

    public void fillActionBars(IActionBars actionBars) {
        if (this.fInViewPart) {
            this.fOpenViewGroup.fillActionBars(actionBars);
            this.fCCPGroup.fillActionBars(actionBars);
            this.fBuildPathGroup.fillActionBars(actionBars);
            this.fGenerateGroup.fillActionBars(actionBars);
            this.fSearchGroup.fillActionBars(actionBars);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fInViewPart) {
            this.fOpenViewGroup.fillContextMenu(menu);
            this.fCCPGroup.fillContextMenu(menu);
            this.fBuildPathGroup.fillContextMenu(menu);
            this.fGenerateGroup.fillContextMenu(menu);
            this.fSearchGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.fOpenViewGroup = new OpenViewActionGroup(viewPart, (ISelectionProvider)site.getStructuredViewer());
            this.fOpenViewGroup.containsOpenPropertiesAction(false);
            this.fCCPGroup = new CCPActionGroup(viewPart);
            this.fGenerateGroup = new GenerateActionGroup(viewPart);
            this.fSearchGroup = new JavaSearchActionGroup(viewPart);
            this.fBuildPathGroup = new GenerateBuildPathActionGroup(viewPart);
            this.fInViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.fInViewPart) {
            this.fOpenViewGroup.setContext(context);
            this.fCCPGroup.setContext(context);
            this.fGenerateGroup.setContext(context);
            this.fSearchGroup.setContext(context);
            this.fBuildPathGroup.setContext(context);
        }
    }

    public void dispose() {
        if (this.fInViewPart) {
            this.fOpenViewGroup.dispose();
            this.fCCPGroup.dispose();
            this.fSearchGroup.dispose();
            this.fBuildPathGroup.dispose();
            this.fGenerateGroup.dispose();
        }
        super.dispose();
    }
}

