/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.mpc.ui.operations.Messages;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeProfileChangeOperation
extends InstallOperation {
    private final ProvisioningSession session;
    private final List<ProfileChangeOperation> operations = new ArrayList<ProfileChangeOperation>();

    CompositeProfileChangeOperation(ProvisioningSession session) {
        super(session, null);
        this.session = session;
    }

    public CompositeProfileChangeOperation add(ProfileChangeOperation operation) {
        this.operations.add(operation);
        return this;
    }

    public List<ProfileChangeOperation> getOperations() {
        return this.operations;
    }

    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)this.session.getProvisioningAgent(), (String)this.getProfileId());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1000 * this.operations.size()));
        for (ProfileChangeOperation operation : this.operations) {
            this.updateRequest(request, operation, status, (IProgressMonitor)progress.newChild(1000));
        }
        try {
            Field requestField = ProfileChangeOperation.class.getDeclaredField("request");
            boolean accessible = requestField.isAccessible();
            try {
                requestField.setAccessible(true);
                requestField.set((Object)this, request);
            }
            finally {
                requestField.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(4, "org.eclipse.epp.mpc.ui", Messages.CompositeProfileChangeOperation_ChangeRequestError, (Throwable)e));
        }
    }

    private void updateRequest(ProfileChangeRequest request, ProfileChangeOperation operation, MultiStatus status, IProgressMonitor monitor) {
        IStatus result = operation.resolveModal(monitor);
        status.merge(result);
        if (status.getSeverity() != 4) {
            IProfileChangeRequest operationChangeRequest = operation.getProfileChangeRequest();
            Collection additions = operationChangeRequest.getAdditions();
            Collection removals = operationChangeRequest.getRemovals();
            Collection extraRequirements = operationChangeRequest.getExtraRequirements();
            request.removeAll(removals);
            request.addAll(additions);
            if (extraRequirements != null) {
                request.addExtraRequirements(extraRequirements);
            }
            if (operationChangeRequest instanceof ProfileChangeRequest) {
                Object object;
                ProfileChangeRequest internalRequest = (ProfileChangeRequest)operationChangeRequest;
                Map installableUnitProfilePropertiesToRemove = internalRequest.getInstallableUnitProfilePropertiesToRemove();
                for (Map.Entry entry : installableUnitProfilePropertiesToRemove.entrySet()) {
                    List properties = (List)entry.getValue();
                    if (properties == null || properties.isEmpty()) continue;
                    IInstallableUnit iu = (IInstallableUnit)entry.getKey();
                    object = properties.iterator();
                    while (object.hasNext()) {
                        String property = (String)object.next();
                        request.removeInstallableUnitProfileProperty(iu, property);
                    }
                }
                Map installableUnitProfilePropertiesToAdd = internalRequest.getInstallableUnitProfilePropertiesToAdd();
                for (Map.Entry entry : installableUnitProfilePropertiesToAdd.entrySet()) {
                    Map properties = (Map)entry.getValue();
                    if (properties == null || properties.isEmpty()) continue;
                    IInstallableUnit iu = (IInstallableUnit)entry.getKey();
                    for (Map.Entry property : properties.entrySet()) {
                        request.setInstallableUnitProfileProperty(iu, (String)property.getKey(), (String)property.getValue());
                    }
                }
                String[] stringArray = internalRequest.getPropertiesToRemove();
                object = stringArray;
                int n = stringArray.length;
                int properties = 0;
                while (properties < n) {
                    Object property = object[properties];
                    request.removeProfileProperty((String)property);
                    ++properties;
                }
                Map propertiesToAdd = internalRequest.getPropertiesToAdd();
                for (Map.Entry property : propertiesToAdd.entrySet()) {
                    request.setProfileProperty((String)property.getKey(), (String)property.getValue());
                }
            }
        }
    }
}

