/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableWidget;
import org.eclipse.swt.widgets.Display;

public class TableChangedListener
extends AdapterImpl {
    private static final boolean DEBUG = TableWidget.DEBUG_EVENTS;
    private final Runnable runnable;
    private final Table table;

    public TableChangedListener(Table table, Runnable runnable) {
        this.table = table;
        this.runnable = runnable;
        table.eAdapters().add((Object)this);
        this.addListenerOnResource();
    }

    private void addListenerOnResource() {
        Resource resource = this.table.eResource();
        resource.setTrackingModification(true);
        resource.eAdapters().add((Object)this);
    }

    public void notifyChanged(Notification msg) {
        int eventType = msg.getEventType();
        if (eventType != 8 && eventType != 9) {
            DebugUtils.debug((boolean)DEBUG, (String)"tableInstanceAdapter called");
            Display.getDefault().asyncExec(this.runnable);
        }
    }

    public void dispose() {
        this.table.eAdapters().remove((Object)this);
        Resource resource = this.table.eResource();
        resource.eAdapters().remove((Object)this);
    }
}

