/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.storage.GitBlobStorage;
import org.eclipse.emf.compare.egit.internal.storage.WorkspaceGitBlobStorage;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider2;

public class BlobStoragePathProvider
implements IStoragePathProvider2 {
    public IPath computeFixedPath(IStorage storage) {
        Object fixedPath;
        if (storage instanceof WorkspaceGitBlobStorage) {
            fixedPath = ((WorkspaceGitBlobStorage)storage).getWorkspacePath();
        } else if (storage instanceof GitBlobStorage) {
            IPath absolutePath = ((GitBlobStorage)storage).getAbsolutePath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile fileForLocation = root.getFileForLocation(absolutePath);
            fixedPath = fileForLocation != null ? fileForLocation.getFullPath() : null;
        } else {
            fixedPath = null;
        }
        return fixedPath;
    }

    public IPath computeAbsolutePath(IStorage storage) {
        if (storage instanceof GitBlobStorage) {
            GitBlobStorage gitStorage = (GitBlobStorage)storage;
            IPath absolutePath = gitStorage.getAbsolutePath();
            return absolutePath;
        }
        return null;
    }
}

