/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.dependency;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.util.ModelExtensionUtil;
import org.eclipse.emf.compare.ide.ui.dependency.IDependencyProvider;
import org.eclipse.emf.ecore.resource.URIConverter;

public class PapyrusDependencyProvider
implements IDependencyProvider {
    private List<String> fileExtensions = new ArrayList<String>(ModelExtensionUtil.getRegisteredFileExtensions());

    public boolean apply(URI uri) {
        return this.fileExtensions.contains(uri.fileExtension());
    }

    public Set<URI> getDependencies(URI uri, URIConverter uriConverter) {
        LinkedHashSet<URI> dependencies = new LinkedHashSet<URI>();
        URI baseURI = uri.trimFileExtension();
        for (String fileExtension : this.fileExtensions) {
            URI dependencyURI = baseURI.appendFileExtension(fileExtension);
            if (!uriConverter.exists(dependencyURI, null)) continue;
            dependencies.add(dependencyURI);
        }
        return dependencies;
    }
}

