/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.internal.ui.util.ResourceBasedPermissionFilter;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityUIUtil {
    private static final IFilter[] RESOURCE_BASED_PERMISSION_FILTERS = new IFilter[]{new ResourceBasedPermissionFilter()};
    private static final IFilter[] NO_FILTERS = new IFilter[0];

    private SecurityUIUtil() {
    }

    public static Directory getDirectory(Realm realm, EClass itemType) {
        Directory explicitDefault = SecurityUIUtil.getDefaultDirectory(realm, itemType);
        if (explicitDefault != null) {
            return explicitDefault;
        }
        String preferredName = itemType == SecurityPackage.Literals.GROUP ? "Groups" : (itemType == SecurityPackage.Literals.USER ? "Users" : (itemType == SecurityPackage.Literals.ROLE ? "Roles" : ""));
        for (SecurityItem next : realm.getItems()) {
            Directory directory;
            if (!(next instanceof Directory) || !preferredName.equals((directory = (Directory)next).getName())) continue;
            return directory;
        }
        return null;
    }

    private static Directory getDefaultDirectory(Realm realm, EClass itemType) {
        if (itemType.getEPackage() == SecurityPackage.eINSTANCE) {
            switch (itemType.getClassifierID()) {
                case 4: {
                    return realm.getDefaultRoleDirectory();
                }
                case 6: {
                    return realm.getDefaultGroupDirectory();
                }
                case 7: {
                    return realm.getDefaultUserDirectory();
                }
            }
        }
        return null;
    }

    public static void applySupportedElementFilter(StructuredViewer viewer, EClass itemType) {
        ViewerFilter filter = SecurityUIUtil.getSupportedElementViewerFilter(itemType);
        if (filter != null) {
            viewer.addFilter(filter);
        }
    }

    private static IFilter[] getSupportedElementFilters(EClass itemType) {
        if (itemType == SecurityPackage.Literals.FILTER_PERMISSION) {
            return RESOURCE_BASED_PERMISSION_FILTERS;
        }
        return NO_FILTERS;
    }

    public static IFilter getSupportedElementFilter(EClass itemType) {
        final IFilter[] filters = SecurityUIUtil.getSupportedElementFilters(itemType);
        return filters.length == 0 ? null : new IFilter(){

            public boolean select(Object toTest) {
                int i = 0;
                while (i < filters.length) {
                    if (!filters[i].select(toTest)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
    }

    public static ViewerFilter getSupportedElementViewerFilter(EClass itemType) {
        IFilter filter = SecurityUIUtil.getSupportedElementFilter(itemType);
        return filter == null ? null : SecurityUIUtil.getViewerFilter(filter);
    }

    public static ViewerFilter getViewerFilter(final IFilter filter) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return filter.select(element);
            }
        };
    }

    public static void applySupportedElementFilter(Collection<?> elements, EClass itemType) {
        IFilter filter = SecurityUIUtil.getSupportedElementFilter(itemType);
        if (filter != null) {
            Iterator<?> iter = elements.iterator();
            while (iter.hasNext()) {
                if (filter.select(iter.next())) continue;
                iter.remove();
            }
        }
    }

    public static IFilter getTypeFilter(final EClass itemType) {
        return new IFilter(){

            public boolean select(Object toTest) {
                return itemType.isInstance(toTest);
            }
        };
    }

    public static void applyTypeFilter(StructuredViewer viewer, final EClass itemType) {
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return itemType.isInstance(element);
            }
        });
    }

    public static boolean isEditable(Object object) {
        return !(object instanceof EObject) || CDOUtil.isWritableObject((EObject)((EObject)object));
    }
}

