/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;

public interface CDOLobStore {
    public File getBinaryFile(byte[] var1);

    public InputStream getBinary(CDOLobInfo var1) throws IOException;

    public CDOLobInfo putBinary(InputStream var1) throws IOException;

    public File getCharacterFile(byte[] var1);

    public Reader getCharacter(CDOLobInfo var1) throws IOException;

    public CDOLobInfo putCharacter(Reader var1) throws IOException;

    public static abstract class Delegating
    implements CDOLobStore {
        public File getBinaryFile(byte[] id) {
            return this.getDelegate().getBinaryFile(id);
        }

        public InputStream getBinary(CDOLobInfo info) throws IOException {
            return this.getDelegate().getBinary(info);
        }

        public CDOLobInfo putBinary(InputStream contents) throws IOException {
            return this.getDelegate().putBinary(contents);
        }

        public File getCharacterFile(byte[] id) {
            return this.getDelegate().getCharacterFile(id);
        }

        public Reader getCharacter(CDOLobInfo info) throws IOException {
            return this.getDelegate().getCharacter(info);
        }

        public CDOLobInfo putCharacter(Reader contents) throws IOException {
            return this.getDelegate().putCharacter(contents);
        }

        public String toString() {
            return this.getDelegate().toString();
        }

        protected abstract CDOLobStore getDelegate();
    }
}

