/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class SourceDialect
extends AbstractEnumerator {
    public static final int UNKNOWN = 0;
    public static final int PLSQL = 1;
    public static final int DB2SQLPL = 2;
    public static final SourceDialect UNKNOWN_LITERAL = new SourceDialect(0, "UNKNOWN", "UNKNOWN");
    public static final SourceDialect PLSQL_LITERAL = new SourceDialect(1, "PLSQL", "PLSQL");
    public static final SourceDialect DB2SQLPL_LITERAL = new SourceDialect(2, "DB2SQLPL", "DB2SQLPL");
    private static final SourceDialect[] VALUES_ARRAY = new SourceDialect[]{UNKNOWN_LITERAL, PLSQL_LITERAL, DB2SQLPL_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static SourceDialect get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SourceDialect result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SourceDialect getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SourceDialect result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SourceDialect get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN_LITERAL;
            }
            case 1: {
                return PLSQL_LITERAL;
            }
            case 2: {
                return DB2SQLPL_LITERAL;
            }
        }
        return null;
    }

    private SourceDialect(int value, String name, String literal) {
        super(value, name, literal);
    }
}

