/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.BreakpointActionManager;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDsfBreakpointExtension;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIBreakpointPathAdjuster;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIRunControl;
import org.eclipse.cdt.dsf.mi.service.Messages;
import org.eclipse.cdt.dsf.mi.service.breakpoint.actions.BreakpointActionAdapter;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.gdb.internal.eventbkpts.GdbCatchpoints;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

public class MIBreakpointsManager
extends AbstractDsfService
implements IBreakpointManagerListener,
IBreakpointListener {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.cdt.dsf.gdb";
    private static final String ATTR_DEBUGGER_PATH = "org.eclipse.cdt.dsf.gdb.debuggerPath";
    private static final String ATTR_THREAD_FILTER = "org.eclipse.cdt.dsf.gdb.threadFilter";
    private static final String ATTR_THREAD_ID = "org.eclipse.cdt.dsf.gdb.threadID";
    private ICommandControlService fConnection;
    private ISourceLookup fSourceLookup;
    private IProcesses fProcesses;
    private IBreakpoints fBreakpoints;
    private IBreakpointManager fBreakpointManager;
    private BreakpointActionManager fBreakpointActionManager;
    private String fDebugModelId;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>> fPlatformToAttributesMaps = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint>> fBPToPlatformMaps = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>>> fPlatformToBPsMaps = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Set<String>>> fPlatformToBPThreadsMaps = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Set<String>>>();
    private Set<IBreakpoint> fPendingRequests = new HashSet<IBreakpoint>();
    private Set<IBreakpoint> fPendingBreakpoints = new HashSet<IBreakpoint>();
    private Map<ICBreakpoint, IMarker> fBreakpointMarkerProblems = new HashMap<ICBreakpoint, IMarker>();
    private ListenerList fTrackingListeners = new ListenerList();
    private static final String NULL_STRING = "";
    static final String CONTEXT_ALREADY_INITIALIZED = "Context already initialized";
    static final String INVALID_CONTEXT_TYPE = "Invalid context type";
    static final String INVALID_CONTEXT = "Invalid context";
    static final String UNABLE_TO_READ_BREAKPOINT = "Unable to read initial breakpoint attributes";
    static final String BREAKPOINT_NOT_INSTALLED = "Breakpoints not installed for given context";
    static final String BREAKPOINT_ALREADY_INSTALLED = "Breakpoint already installed";
    static final String BREAKPOINT_ALREADY_REMOVED = "Breakpoint already removed";
    static final String INVALID_BREAKPOINT = "Invalid breakpoint";
    static final String UNKNOWN_BREAKPOINT = "Unknown breakpoint";
    static final String INVALID_PARAMETER = "Invalid breakpoint parameter(s)";
    static final String NO_DEBUGGER_PATH = "No debugger path for breakpoint";
    static final String NO_MARKER_FOR_BREAKPOINT = "No marker associated with breakpoint";

    protected Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>> getPlatformToAttributesMaps() {
        return this.fPlatformToAttributesMaps;
    }

    protected Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint>> getBPToPlatformMaps() {
        return this.fBPToPlatformMaps;
    }

    protected Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>>> getPlatformToBPsMaps() {
        return this.fPlatformToBPsMaps;
    }

    protected Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Set<String>>> getPlatformToBPThreadsMaps() {
        return this.fPlatformToBPThreadsMaps;
    }

    public MIBreakpointsManager(DsfSession session, String debugModelId) {
        super(session);
        this.fDebugModelId = debugModelId;
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIBreakpointsManager.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fSourceLookup = (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class);
        this.fBreakpoints = (IBreakpoints)this.getServicesTracker().getService(IBreakpoints.class);
        this.fProcesses = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fBreakpointActionManager = CDebugCorePlugin.getDefault().getBreakpointActionManager();
        this.getSession().addServiceEventListener((Object)this, null);
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.register(new String[]{MIBreakpointsManager.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(final RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fBreakpointManager.removeBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fTrackingListeners.clear();
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                MIBreakpointsManager.super.shutdown(rm);
            }
        };
        ArrayList<IBreakpoints.IBreakpointsTargetDMContext> targetBPKeys = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>(this.fBPToPlatformMaps.size());
        targetBPKeys.addAll(0, this.fBPToPlatformMaps.keySet());
        for (IBreakpoints.IBreakpointsTargetDMContext dmc : targetBPKeys) {
            this.stopTrackingBreakpoints(dmc, (RequestMonitor)countingRm);
        }
        countingRm.setDoneCount(targetBPKeys.size());
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void startTrackingBpForProcess(IRunControl.IContainerDMContext containerDmc, RequestMonitor rm) {
        IBreakpoint[] breakpoints;
        IBreakpoints.IBreakpointsTargetDMContext targetBpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        IBreakpoint[] iBreakpointArray = breakpoints = this.fBreakpointManager.getBreakpoints(this.fDebugModelId);
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof ICBreakpoint && this.supportsBreakpoint(breakpoint)) {
                this.setTargetFilter((ICBreakpoint)breakpoint, containerDmc);
            }
            ++n2;
        }
        this.startTrackingBreakpoints(targetBpDmc, rm);
    }

    public void startTrackingBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10004, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformToAttributesMaps.get(dmc);
        Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fPlatformToBPsMaps.get(dmc);
        Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetIDs = this.fBPToPlatformMaps.get(dmc);
        Map<ICBreakpoint, Set<String>> threadIDs = this.fPlatformToBPThreadsMaps.get(dmc);
        if (platformBPs != null || breakpointIDs != null || targetIDs != null || threadIDs != null) {
            assert (platformBPs != null && breakpointIDs != null && targetIDs != null && threadIDs != null);
            rm.done();
            return;
        }
        this.fPlatformToAttributesMaps.put(dmc, new HashMap());
        this.fPlatformToBPsMaps.put(dmc, new HashMap());
        this.fBPToPlatformMaps.put(dmc, new HashMap());
        this.fPlatformToBPThreadsMaps.put(dmc, new HashMap());
        new Job("DSF BreakpointsManager: Install initial breakpoints on target"){

            protected IStatus run(IProgressMonitor monitor) {
                MIBreakpointsManager.this.getExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        MIBreakpointsManager.this.installInitialBreakpoints(dmc, new RequestMonitor(ImmediateExecutor.getInstance(), rm){

                            protected void handleSuccess() {
                                Object[] objectArray = MIBreakpointsManager.this.fTrackingListeners.getListeners();
                                int n = objectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object o = objectArray[n2];
                                    ((IMIBreakpointsTrackingListener)o).breakpointTrackingStarted(dmc);
                                    ++n2;
                                }
                                rm.done();
                            }
                        });
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void installInitialBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, RequestMonitor rm) {
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformToAttributesMaps.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10005, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        try {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = this.fBreakpointManager.getBreakpoints(this.fDebugModelId);
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                boolean filtered;
                IBreakpoint iBreakpoint = iBreakpointArray[n2];
                if (this.supportsBreakpoint(iBreakpoint) && !(filtered = this.isBreakpointEntirelyFiltered(dmc, (ICBreakpoint)iBreakpoint))) {
                    Map attributes = iBreakpoint.getMarker().getAttributes();
                    attributes.put(ATTR_DEBUGGER_PATH, NULL_STRING);
                    attributes.put(ATTR_THREAD_FILTER, this.extractThreads(dmc, (ICBreakpoint)iBreakpoint));
                    attributes.put(ATTR_THREAD_ID, NULL_STRING);
                    platformBPs.put((ICBreakpoint)iBreakpoint, attributes);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, GDB_DEBUG_MODEL_ID, 10004, UNABLE_TO_READ_BREAKPOINT, (Throwable)e);
            rm.setStatus((IStatus)status);
            rm.done();
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRm.setDoneCount(platformBPs.size());
        for (final ICBreakpoint iCBreakpoint : platformBPs.keySet()) {
            final Map<String, Object> attributes = platformBPs.get(iCBreakpoint);
            this.determineDebuggerPath(dmc, attributes, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleSuccess() {
                    MIBreakpointsManager.this.installBreakpoint(dmc, iCBreakpoint, attributes, (RequestMonitor)countingRm);
                }
            });
        }
    }

    public void stopTrackingBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10005, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformToAttributesMaps.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10005, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                MIBreakpointsManager.this.fPlatformToAttributesMaps.remove(dmc);
                MIBreakpointsManager.this.fPlatformToBPsMaps.remove(dmc);
                MIBreakpointsManager.this.fBPToPlatformMaps.remove(dmc);
                MIBreakpointsManager.this.fPlatformToBPThreadsMaps.remove(dmc);
                Object[] objectArray = MIBreakpointsManager.this.fTrackingListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((IMIBreakpointsTrackingListener)o).breakpointTrackingStopped(dmc);
                    ++n2;
                }
                rm.done();
            }
        };
        countingRm.setDoneCount(platformBPs.size());
        for (ICBreakpoint breakpoint : platformBPs.keySet()) {
            this.uninstallBreakpoint(dmc, breakpoint, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    countingRm.done();
                }
            });
        }
    }

    private void installBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final Map<String, Object> attributes, final RequestMonitor rm) {
        String debuggerPath;
        final Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformToAttributesMaps.get(dmc);
        assert (platformBPs != null);
        final Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fPlatformToBPsMaps.get(dmc);
        assert (breakpointIDs != null);
        final Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetBPs = this.fBPToPlatformMaps.get(dmc);
        assert (targetBPs != null);
        final Map<ICBreakpoint, Set<String>> threadsIDs = this.fPlatformToBPThreadsMaps.get(dmc);
        assert (threadsIDs != null);
        if (breakpoint instanceof ICLineBreakpoint && !(breakpoint instanceof ICAddressBreakpoint) && !(breakpoint instanceof ICFunctionBreakpoint) && ((debuggerPath = (String)attributes.get(ATTR_DEBUGGER_PATH)) == null || debuggerPath.equals(NULL_STRING))) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10004, NO_DEBUGGER_PATH, null));
            rm.done();
            return;
        }
        Set<String> threads = this.getThreads(attributes);
        final CountingRequestMonitor installRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                platformBPs.put(breakpoint, attributes);
                rm.done();
            }
        };
        installRM.setDoneCount(threads.size());
        for (final String thread : threads) {
            DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm = new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                protected void handleSuccess() {
                    Vector<IBreakpoints.IBreakpointDMContext> list = (Vector<IBreakpoints.IBreakpointDMContext>)breakpointIDs.get(breakpoint);
                    if (list == null) {
                        list = new Vector<IBreakpoints.IBreakpointDMContext>();
                    }
                    IBreakpoints.IBreakpointDMContext targetBP = (IBreakpoints.IBreakpointDMContext)this.getData();
                    list.add(targetBP);
                    breakpointIDs.put(breakpoint, list);
                    targetBPs.put(targetBP, breakpoint);
                    HashSet<String> thrds = (HashSet<String>)threadsIDs.get(breakpoint);
                    if (thrds == null) {
                        thrds = new HashSet<String>();
                    }
                    thrds.add(thread);
                    threadsIDs.put(breakpoint, thrds);
                    attributes.put(MIBreakpointsManager.ATTR_THREAD_ID, MIBreakpointsManager.NULL_STRING);
                    MIBreakpointsManager.this.removeBreakpointProblemMarker(breakpoint);
                    MIBreakpointsManager.this.fBreakpoints.getBreakpointDMData(targetBP, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMData>((Executor)MIBreakpointsManager.this.getExecutor(), null){

                        protected void handleCompleted() {
                            IBreakpoints.IBreakpointDMData data;
                            boolean pending = false;
                            if (this.isSuccess() && (data = (IBreakpoints.IBreakpointDMData)this.getData()) instanceof MIBreakpointDMData) {
                                pending = ((MIBreakpointDMData)data).isPending();
                            }
                            if (!pending) {
                                try {
                                    breakpoint.incrementInstallCount();
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                            }
                            installRM.done();
                        }
                    });
                }

                protected void handleError() {
                    String detailedMessage = this.getStatus().getException() != null && this.getStatus().getException().getMessage() != null ? this.getStatus().getException().getMessage() : this.getStatus().getMessage();
                    String description = detailedMessage == null ? Messages.Breakpoint_attribute_problem : MessageFormat.format((String)Messages.Breakpoint_attribute_detailed_problem, (Object[])new Object[]{detailedMessage});
                    MIBreakpointsManager.this.addBreakpointProblemMarker(breakpoint, description, 1);
                    installRM.done();
                }
            };
            attributes.put(ATTR_THREAD_ID, thread);
            Map<String, Object> targetAttributes = this.convertToTargetBreakpoint(breakpoint, attributes);
            this.fBreakpoints.insertBreakpoint(dmc, targetAttributes, (DataRequestMonitor)drm);
        }
    }

    private void addBreakpointProblemMarker(final ICBreakpoint breakpoint, final String description, final int severity) {
        new Job("Add Breakpoint Problem Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                if (breakpoint instanceof ICLineBreakpoint) {
                    IMarker marker = (IMarker)MIBreakpointsManager.this.fBreakpointMarkerProblems.remove(breakpoint);
                    if (marker != null) {
                        try {
                            marker.delete();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ICLineBreakpoint lineBreakpoint = (ICLineBreakpoint)breakpoint;
                    try {
                        IMarker breakpointMarker = lineBreakpoint.getMarker();
                        IResource resource = breakpointMarker.getResource();
                        IMarker problemMarker = resource.createMarker("org.eclipse.cdt.debug.core.breakpointproblem");
                        int lineNumber = lineBreakpoint.getLineNumber();
                        String sourceHandle = lineBreakpoint.getSourceHandle();
                        problemMarker.setAttribute("location", (Object)String.valueOf(lineNumber));
                        problemMarker.setAttribute("message", (Object)description);
                        problemMarker.setAttribute("severity", severity);
                        problemMarker.setAttribute("lineNumber", lineNumber);
                        if (sourceHandle != null) {
                            problemMarker.setAttribute("problem.externalLocation", (Object)sourceHandle);
                        }
                        MIBreakpointsManager.this.fBreakpointMarkerProblems.put(breakpoint, problemMarker);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void removeBreakpointProblemMarker(final ICBreakpoint breakpoint) {
        new Job("Remove Breakpoint Problem Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                IMarker marker = (IMarker)MIBreakpointsManager.this.fBreakpointMarkerProblems.remove(breakpoint);
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void uninstallBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, RequestMonitor rm) {
        this.removeAllTargetFilters(dmc, breakpoint);
        this.removeBreakpointProblemMarker(breakpoint);
        this.doUninstallBreakpoint(dmc, breakpoint, (RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                Map platformBPs = (Map)MIBreakpointsManager.this.fPlatformToAttributesMaps.get(dmc);
                if (platformBPs != null) {
                    platformBPs.remove(breakpoint);
                }
                super.handleSuccess();
            }
        });
    }

    private void doUninstallBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final RequestMonitor rm) {
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformToAttributesMaps.get(dmc);
        assert (platformBPs != null);
        Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fPlatformToBPsMaps.get(dmc);
        assert (breakpointIDs != null);
        Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetBPs = this.fBPToPlatformMaps.get(dmc);
        assert (targetBPs != null);
        final Map<ICBreakpoint, Set<String>> threadsIDs = this.fPlatformToBPThreadsMaps.get(dmc);
        assert (threadsIDs != null);
        if (!(platformBPs.containsKey(breakpoint) && breakpointIDs.containsKey(breakpoint) && targetBPs.containsValue(breakpoint))) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10005, BREAKPOINT_ALREADY_REMOVED, null));
            rm.done();
            return;
        }
        final CountingRequestMonitor removeRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                threadsIDs.remove(breakpoint);
                MIBreakpointsManager.this.fPendingRequests.remove(breakpoint);
                rm.done();
            }
        };
        Vector<IBreakpoints.IBreakpointDMContext> list = breakpointIDs.remove(breakpoint);
        int count = 0;
        if (list != null) {
            for (final IBreakpoints.IBreakpointDMContext bp : list) {
                targetBPs.remove(bp);
                this.decrementInstallCount(bp, breakpoint, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)removeRM){

                    protected void handleCompleted() {
                        MIBreakpointsManager.this.fBreakpoints.removeBreakpoint(bp, (RequestMonitor)removeRM);
                    }
                });
            }
            count = list.size();
            list.clear();
        }
        removeRM.setDoneCount(count);
    }

    private void decrementInstallCount(IBreakpoints.IBreakpointDMContext targetDmc, final ICBreakpoint breakpoint, final RequestMonitor rm) {
        this.fBreakpoints.getBreakpointDMData(targetDmc, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMData>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                IBreakpoints.IBreakpointDMData data;
                boolean pending = false;
                if (this.isSuccess() && (data = (IBreakpoints.IBreakpointDMData)this.getData()) instanceof MIBreakpointDMData) {
                    pending = ((MIBreakpointDMData)data).isPending();
                }
                if (!pending) {
                    try {
                        breakpoint.decrementInstallCount();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                rm.done();
            }
        });
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final Map<String, Object> attributes, final IMarkerDelta oldValues, final RequestMonitor rm) {
        final Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformToAttributesMaps.get(dmc);
        assert (platformBPs != null);
        Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fPlatformToBPsMaps.get(dmc);
        assert (breakpointIDs != null);
        final Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetBPs = this.fBPToPlatformMaps.get(dmc);
        assert (targetBPs != null);
        final Map<ICBreakpoint, Set<String>> threadsIDs = this.fPlatformToBPThreadsMaps.get(dmc);
        assert (threadsIDs != null);
        boolean filtered = this.isBreakpointEntirelyFiltered(dmc, breakpoint);
        if (filtered && !platformBPs.containsKey(breakpoint)) {
            rm.done();
            return;
        }
        if (!breakpointIDs.containsKey(breakpoint) && !targetBPs.containsValue(breakpoint)) {
            if (!filtered) {
                String[] diff = this.compareAttributes(oldValues.getAttributes(), attributes, new String[]{ATTR_DEBUGGER_PATH});
                if (diff.length != 1 || !diff[0].equals("org.eclipse.cdt.debug.core.installCount")) {
                    attributes.put(ATTR_DEBUGGER_PATH, NULL_STRING);
                    attributes.put(ATTR_THREAD_FILTER, this.extractThreads(dmc, breakpoint));
                    attributes.put(ATTR_THREAD_ID, NULL_STRING);
                    this.determineDebuggerPath(dmc, attributes, new RequestMonitor((Executor)this.getExecutor(), rm){

                        protected void handleSuccess() {
                            MIBreakpointsManager.this.installBreakpoint(dmc, breakpoint, attributes, rm);
                        }
                    });
                } else {
                    rm.done();
                }
            } else {
                rm.done();
            }
            return;
        }
        if (filtered) {
            this.uninstallBreakpoint(dmc, breakpoint, rm);
            return;
        }
        Map<String, Object> originalAttributes = platformBPs.get(breakpoint);
        if (originalAttributes == null) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10002, INVALID_BREAKPOINT, null));
            rm.done();
            return;
        }
        HashMap<String, Object> oldAttributes = new HashMap<String, Object>(originalAttributes);
        oldAttributes.put(ATTR_THREAD_FILTER, threadsIDs.get(breakpoint));
        final Set<String> newThreads = this.extractThreads(dmc, breakpoint);
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(attributes);
        newAttributes.put(ATTR_THREAD_FILTER, newThreads);
        final Map<String, Object> attributesDelta = this.determineAttributesDelta(oldAttributes, newAttributes);
        final Vector oldTargetBPs = new Vector(breakpointIDs.get(breakpoint));
        if (oldTargetBPs.isEmpty()) {
            rm.setStatus((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 10002, INVALID_BREAKPOINT, null));
            rm.done();
            return;
        }
        final CountingRequestMonitor updateRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                platformBPs.put(breakpoint, attributes);
                rm.done();
            }

            protected void handleError() {
                final String errorMessage = this.getStatus().getException() != null ? this.getStatus().getException().getLocalizedMessage() : this.getStatus().getMessage();
                MIBreakpointsManager.this.doUninstallBreakpoint(dmc, breakpoint, (RequestMonitor)new ImmediateRequestMonitor(rm){

                    protected void handleSuccess() {
                        MIBreakpointsManager.this.addBreakpointProblemMarker(breakpoint, errorMessage, 1);
                        rm.done();
                    }

                    protected void handleError() {
                        MIBreakpointsManager.this.rollbackAttributes(breakpoint, oldValues);
                        platformBPs.put(breakpoint, attributes);
                        rm.setStatus((IStatus)new Status(4, MIBreakpointsManager.GDB_DEBUG_MODEL_ID, 10004, MIBreakpointsManager.INVALID_PARAMETER, this.getStatus().getException()));
                        rm.done();
                    }
                });
            }
        };
        final Vector newTargetBPs = new Vector();
        final CountingRequestMonitor removeRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                Map breakpointIDs = (Map)MIBreakpointsManager.this.fPlatformToBPsMaps.get(dmc);
                if (breakpointIDs == null) {
                    rm.setStatus((IStatus)new Status(4, MIBreakpointsManager.GDB_DEBUG_MODEL_ID, 10004, MIBreakpointsManager.INVALID_BREAKPOINT, null));
                    rm.done();
                    return;
                }
                breakpointIDs.put(breakpoint, newTargetBPs);
                for (IBreakpoints.IBreakpointDMContext ref : newTargetBPs) {
                    MIBreakpointsManager.this.fBreakpoints.updateBreakpoint(ref, attributesDelta, (RequestMonitor)updateRM);
                }
                updateRM.setDoneCount(newTargetBPs.size());
            }
        };
        DataRequestMonitor<Vector<IBreakpoints.IBreakpointDMContext>> insertRM = new DataRequestMonitor<Vector<IBreakpoints.IBreakpointDMContext>>((Executor)this.getExecutor(), null){

            protected void handleSuccess() {
                newTargetBPs.addAll((Collection)this.getData());
                for (IBreakpoints.IBreakpointDMContext newRef : newTargetBPs) {
                    targetBPs.put(newRef, breakpoint);
                }
                threadsIDs.put(breakpoint, newThreads);
                for (final IBreakpoints.IBreakpointDMContext ref : oldTargetBPs) {
                    targetBPs.remove(ref);
                    MIBreakpointsManager.this.decrementInstallCount(ref, breakpoint, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)removeRM){

                        protected void handleCompleted() {
                            MIBreakpointsManager.this.fBreakpoints.removeBreakpoint(ref, (RequestMonitor)removeRM);
                        }
                    });
                }
                removeRM.setDoneCount(oldTargetBPs.size());
            }

            protected void handleError() {
                final String errorMessage = this.getStatus().getException() != null ? this.getStatus().getException().getLocalizedMessage() : this.getStatus().getMessage();
                MIBreakpointsManager.this.doUninstallBreakpoint(dmc, breakpoint, (RequestMonitor)new ImmediateRequestMonitor((RequestMonitor)updateRM){

                    protected void handleSuccess() {
                        MIBreakpointsManager.this.addBreakpointProblemMarker(breakpoint, errorMessage, 1);
                        updateRM.setDoneCount(0);
                    }
                });
            }
        };
        if (this.needsResinstallation(attributesDelta)) {
            this.reinstallBreakpoint(dmc, breakpoint, attributes, newThreads, insertRM);
        } else {
            for (IBreakpoints.IBreakpointDMContext ref : oldTargetBPs) {
                this.fBreakpoints.updateBreakpoint(ref, attributesDelta, (RequestMonitor)updateRM);
            }
            updateRM.setDoneCount(oldTargetBPs.size());
        }
    }

    private void reinstallBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, final ICBreakpoint breakpoint, Map<String, Object> attributes, Set<String> threads, DataRequestMonitor<Vector<IBreakpoints.IBreakpointDMContext>> drm) {
        final Vector breakpointList = new Vector();
        final CountingRequestMonitor installRM = new CountingRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)drm, (DataRequestMonitor)drm, breakpointList){
            private final /* synthetic */ DataRequestMonitor val$drm;
            private final /* synthetic */ Vector val$breakpointList;
            {
                this.val$drm = dataRequestMonitor;
                this.val$breakpointList = vector;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$drm.setData((Object)this.val$breakpointList);
                this.val$drm.done();
            }
        };
        installRM.setDoneCount(threads.size());
        for (String thread : threads) {
            Map<String, Object> attrs = this.convertToTargetBreakpoint(breakpoint, attributes);
            if (!(breakpoint instanceof ICTracepoint || breakpoint instanceof ICDynamicPrintf || this.fBreakpointManager.isEnabled())) {
                attrs.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", false);
            }
            attrs.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", thread);
            this.fBreakpoints.insertBreakpoint(context, attrs, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                protected void handleSuccess() {
                    breakpointList.add((IBreakpoints.IBreakpointDMContext)this.getData());
                    MIBreakpointsManager.this.fBreakpoints.getBreakpointDMData((IBreakpoints.IBreakpointDMContext)this.getData(), (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMData>((Executor)MIBreakpointsManager.this.getExecutor(), null){

                        protected void handleCompleted() {
                            IBreakpoints.IBreakpointDMData data;
                            boolean pending = false;
                            if (this.isSuccess() && (data = (IBreakpoints.IBreakpointDMData)this.getData()) instanceof MIBreakpointDMData) {
                                pending = ((MIBreakpointDMData)data).isPending();
                            }
                            if (!pending) {
                                try {
                                    breakpoint.incrementInstallCount();
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                            }
                            installRM.done();
                        }
                    });
                }

                protected void handleError() {
                    String detailedMessage = this.getStatus().getException() != null && this.getStatus().getException().getMessage() != null ? this.getStatus().getException().getMessage() : this.getStatus().getMessage();
                    String description = detailedMessage == null ? Messages.Breakpoint_attribute_problem : MessageFormat.format((String)Messages.Breakpoint_attribute_detailed_problem, (Object[])new Object[]{detailedMessage});
                    installRM.setStatus((IStatus)new Status(4, MIBreakpointsManager.GDB_DEBUG_MODEL_ID, 10004, description, this.getStatus().getException()));
                    installRM.done();
                }
            });
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        for (IBreakpoints.IBreakpointsTargetDMContext context : this.fPlatformToBPsMaps.keySet()) {
            for (ICBreakpoint breakpoint : this.fPlatformToBPsMaps.get(context).keySet()) {
                try {
                    if (breakpoint instanceof ICTracepoint || breakpoint instanceof ICDynamicPrintf || !breakpoint.isEnabled()) continue;
                    for (IBreakpoints.IBreakpointDMContext ref : this.fPlatformToBPsMaps.get(context).get(breakpoint)) {
                        HashMap<String, Boolean> delta = new HashMap<String, Boolean>();
                        delta.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", enabled);
                        this.fBreakpoints.updateBreakpoint(ref, delta, new RequestMonitor((Executor)this.getExecutor(), null));
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    @ThreadSafe
    public void breakpointAdded(IBreakpoint breakpoint) {
        this.breakpointAdded(breakpoint, null);
    }

    @ThreadSafe
    public void breakpointAdded(final IBreakpoint breakpoint, MIBreakpoint miBpt) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                final Map attrs = breakpoint.getMarker().getAttributes();
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        MIBreakpointsManager.this.fProcesses.getProcessesBeingDebugged((IDMContext)MIBreakpointsManager.this.fConnection.getContext(), (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(){

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    try {
                                        IDsfBreakpointExtension filterExtension = MIBreakpointsManager.this.getFilterExtension((ICBreakpoint)breakpoint);
                                        IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                                        int n = iDMContextArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IDMContext dmc = iDMContextArray[n2];
                                            IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                                            if (!$assertionsDisabled && containerDmc == null) {
                                                throw new AssertionError();
                                            }
                                            if (filterExtension.getThreadFilters(containerDmc) == null) {
                                                filterExtension.setTargetFilter(containerDmc);
                                            }
                                            ++n2;
                                        }
                                    }
                                    catch (CoreException filterExtension) {
                                        // empty catch block
                                    }
                                }
                                CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                                    protected void handleCompleted() {
                                        if (this.getStatus().getSeverity() == 4) {
                                            GdbPlugin.getDefault().getLog().log(this.getStatus());
                                        }
                                    }
                                };
                                countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformToAttributesMaps.size());
                                for (IDMContext dmc : MIBreakpointsManager.this.fPlatformToAttributesMaps.keySet()) {
                                    boolean filtered = MIBreakpointsManager.this.isBreakpointEntirelyFiltered((IBreakpoints.IBreakpointsTargetDMContext)dmc, (ICBreakpoint)breakpoint);
                                    if (!filtered) {
                                        MIBreakpointsManager.this.determineDebuggerPath((IBreakpoints.IBreakpointsTargetDMContext)dmc, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm, (IBreakpoints.IBreakpointsTargetDMContext)dmc, breakpoint, attrs, countingRm){
                                            private final /* synthetic */ IBreakpoints.IBreakpointsTargetDMContext val$dmc;
                                            private final /* synthetic */ IBreakpoint val$breakpoint;
                                            private final /* synthetic */ Map val$attrs;
                                            private final /* synthetic */ CountingRequestMonitor val$countingRm;
                                            {
                                                this.val$dmc = iBreakpointsTargetDMContext;
                                                this.val$breakpoint = iBreakpoint;
                                                this.val$attrs = map;
                                                this.val$countingRm = countingRequestMonitor;
                                                super($anonymous0, $anonymous1);
                                            }

                                            protected void handleSuccess() {
                                                MIBreakpointsManager.this.installBreakpoint(this.val$dmc, (ICBreakpoint)this.val$breakpoint, this.val$attrs, (RequestMonitor)this.val$countingRm);
                                            }
                                        });
                                        continue;
                                    }
                                    countingRm.done();
                                }
                            }
                        });
                    }
                });
            }
            catch (CoreException coreException) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    protected IDsfBreakpointExtension getFilterExtension(ICBreakpoint bp) throws CoreException {
        return (IDsfBreakpointExtension)bp.getExtension(GDB_DEBUG_MODEL_ID, ICBreakpointExtension.class);
    }

    public void breakpointChanged(final IBreakpoint breakpoint, final IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                final Map attrs = breakpoint.getMarker().getAttributes();
                if (!(breakpoint instanceof ICTracepoint || breakpoint instanceof ICDynamicPrintf || this.fBreakpointManager.isEnabled())) {
                    attrs.put("org.eclipse.debug.core.enabled", false);
                }
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (MIBreakpointsManager.this.fPendingRequests.contains(breakpoint)) {
                            MIBreakpointsManager.this.fPendingBreakpoints.add(breakpoint);
                            return;
                        }
                        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleCompleted() {
                                if (!this.isSuccess() && this.getStatus().getSeverity() == 4) {
                                    GdbPlugin.getDefault().getLog().log(this.getStatus());
                                }
                                MIBreakpointsManager.this.fPendingRequests.remove(breakpoint);
                                if (MIBreakpointsManager.this.fPendingBreakpoints.contains(breakpoint)) {
                                    MIBreakpointsManager.this.fPendingBreakpoints.remove(breakpoint);
                                    MIBreakpointsManager.this.breakpointChanged(breakpoint, delta);
                                }
                            }
                        };
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformToAttributesMaps.size());
                        MIBreakpointsManager.this.fPendingRequests.add(breakpoint);
                        for (final IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformToAttributesMaps.keySet()) {
                            MIBreakpointsManager.this.determineDebuggerPath(dmc, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm){

                                protected void handleSuccess() {
                                    MIBreakpointsManager.this.modifyBreakpoint(dmc, (ICBreakpoint)breakpoint, attrs, delta, (RequestMonitor)countingRm);
                                }
                            });
                        }
                    }
                });
            }
            catch (CoreException coreException) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    GdbPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformToAttributesMaps.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformToAttributesMaps.keySet()) {
                            if (!((Map)MIBreakpointsManager.this.fPlatformToAttributesMaps.get(dmc)).containsKey(breakpoint)) continue;
                            MIBreakpointsManager.this.uninstallBreakpoint(dmc, (ICBreakpoint)breakpoint, (RequestMonitor)countingRm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpoints.BreakpointAddedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpoints.BreakpointUpdatedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpoints.BreakpointRemovedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointScopeEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        assert (e instanceof IMIDMEvent);
        if (e instanceof IMIDMEvent) {
            Object miEvent = ((IMIDMEvent)e).getMIEvent();
            if (miEvent instanceof MIBreakpointHitEvent) {
                MIBreakpointHitEvent evt = (MIBreakpointHitEvent)((Object)miEvent);
                this.performBreakpointAction(evt.getDMContext(), evt.getNumber());
                return;
            }
            if (miEvent instanceof MIWatchpointTriggerEvent) {
                MIWatchpointTriggerEvent evt = (MIWatchpointTriggerEvent)((Object)miEvent);
                this.performBreakpointAction(evt.getDMContext(), evt.getNumber());
                return;
            }
        }
    }

    @Deprecated
    @DsfServiceEventHandler
    public void eventDispatched(MIRunControl.SuspendedEvent e) {
    }

    private void performBreakpointAction(final IDMContext context, String number) {
        final ICBreakpoint breakpoint = this.findPlatformBreakpoint(number);
        if (breakpoint != null) {
            new Job("Breakpoint action"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    MIBreakpointsManager.this.fBreakpointActionManager.executeActions((IBreakpoint)breakpoint, (IAdaptable)new BreakpointActionAdapter(MIBreakpointsManager.this.getExecutor(), MIBreakpointsManager.this.getServicesTracker(), context));
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private ICBreakpoint findPlatformBreakpoint(String targetBreakpointID) {
        Set<IBreakpoints.IBreakpointsTargetDMContext> targets = this.fBPToPlatformMaps.keySet();
        for (IBreakpoints.IBreakpointsTargetDMContext target : targets) {
            Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> bps = this.fBPToPlatformMaps.get(target);
            Set<IBreakpoints.IBreakpointDMContext> contexts = bps.keySet();
            for (IBreakpoints.IBreakpointDMContext context : contexts) {
                MIBreakpoints.MIBreakpointDMContext ctx;
                if (!(context instanceof MIBreakpoints.MIBreakpointDMContext) || !(ctx = (MIBreakpoints.MIBreakpointDMContext)context).getReference().equals(targetBreakpointID)) continue;
                return bps.get(context);
            }
        }
        return null;
    }

    public IBreakpoint findPlatformBreakpoint(IBreakpoints.IBreakpointDMContext bpContext) {
        Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> bps;
        IBreakpoints.IBreakpointsTargetDMContext targetCtx;
        if (bpContext instanceof MIBreakpoints.MIBreakpointDMContext && (targetCtx = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)bpContext, IBreakpoints.IBreakpointsTargetDMContext.class)) != null && (bps = this.fBPToPlatformMaps.get(targetCtx)) != null) {
            return (IBreakpoint)bps.get(bpContext);
        }
        return null;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
    }

    private void setTargetFilter(ICBreakpoint breakpoint, IRunControl.IContainerDMContext containerDmc) {
        try {
            IDsfBreakpointExtension filterExt = this.getFilterExtension(breakpoint);
            if (filterExt.getThreadFilters(containerDmc) == null) {
                filterExt.setTargetFilter(containerDmc);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
    }

    public void removeTargetFilter(IRunControl.IContainerDMContext containerDMC) {
        IBreakpoint[] allBreakpoints;
        IBreakpoint[] iBreakpointArray = allBreakpoints = this.fBreakpointManager.getBreakpoints(this.fDebugModelId);
        int n = allBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (this.supportsBreakpoint(bp)) {
                this.removeTargetFilter((ICBreakpoint)bp, containerDMC);
            }
            ++n2;
        }
    }

    private void removeTargetFilter(ICBreakpoint breakpoint, IRunControl.IContainerDMContext containerDmc) {
        try {
            IDsfBreakpointExtension filterExt = this.getFilterExtension(breakpoint);
            filterExt.removeTargetFilter(containerDmc);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void removeAllTargetFilters(IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc, ICBreakpoint breakpoint) {
        try {
            IRunControl.IContainerDMContext[] targets;
            IDsfBreakpointExtension filterExt = this.getFilterExtension(breakpoint);
            IRunControl.IContainerDMContext[] iContainerDMContextArray = targets = filterExt.getTargetFilters();
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.IContainerDMContext target = iContainerDMContextArray[n2];
                if (bpTargetDmc.equals(target) || DMContexts.isAncestorOf((IDMContext)target, (IDMContext)bpTargetDmc)) {
                    filterExt.removeTargetFilter(target);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.terminated();
    }

    private void terminated() {
        for (IBreakpoints.IBreakpointsTargetDMContext ctx : this.fPlatformToAttributesMaps.keySet()) {
            Map<ICBreakpoint, Map<String, Object>> breakpoints = this.fPlatformToAttributesMaps.get(ctx);
            this.clearBreakpointStatus(breakpoints.keySet().toArray(new ICBreakpoint[breakpoints.size()]), ctx);
        }
        this.fPlatformToAttributesMaps.clear();
    }

    private void clearBreakpointStatus(ICBreakpoint[] bps, final IBreakpoints.IBreakpointsTargetDMContext ctx) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Map breakpoints = (Map)MIBreakpointsManager.this.fPlatformToBPsMaps.get(ctx);
                for (ICBreakpoint breakpoint : breakpoints.keySet()) {
                    Vector targetBps = (Vector)breakpoints.get(breakpoint);
                    for (IBreakpoints.IBreakpointDMContext targetBp : targetBps) {
                        MIBreakpointsManager.this.decrementInstallCount(targetBp, breakpoint, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null));
                    }
                }
            }
        };
        ISchedulingRule rule = null;
        ArrayList<ISchedulingRule> markerRules = new ArrayList<ISchedulingRule>();
        ICBreakpoint[] iCBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            ICBreakpoint bp = iCBreakpointArray[n2];
            IMarker marker = bp.getMarker();
            if (marker != null) {
                ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(marker.getResource());
                if (markerRule == null) {
                    markerRules = null;
                    break;
                }
                markerRules.add(markerRule);
            }
            ++n2;
        }
        if (markerRules != null) {
            rule = MultiRule.combine((ISchedulingRule[])markerRules.toArray(new ISchedulingRule[markerRules.size()]));
        }
        try {
            ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
        }
        catch (CoreException e) {
            GdbPlugin.getDefault().getLog().log(e.getStatus());
        }
        new Job("Clear Breakpoints Status"){

            protected IStatus run(IProgressMonitor monitor) {
                for (IMarker marker : MIBreakpointsManager.this.fBreakpointMarkerProblems.values()) {
                    if (marker == null) continue;
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                MIBreakpointsManager.this.fBreakpointMarkerProblems.clear();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected boolean supportsBreakpoint(IBreakpoint bp) {
        IMarker marker;
        return bp instanceof ICBreakpoint && bp.getModelIdentifier().equals(this.fDebugModelId) && (marker = bp.getMarker()) != null;
    }

    private void determineDebuggerPath(IBreakpoints.IBreakpointsTargetDMContext dmc, final Map<String, Object> attributes, final RequestMonitor rm) {
        String hostPath = (String)attributes.get("org.eclipse.cdt.debug.core.sourceHandle");
        if (hostPath != null) {
            ISourceLookup.ISourceLookupDMContext srcDmc = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISourceLookup.ISourceLookupDMContext.class);
            if (srcDmc != null) {
                this.fSourceLookup.getDebuggerPath(srcDmc, (Object)hostPath, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

                    protected void handleSuccess() {
                        attributes.put(MIBreakpointsManager.ATTR_DEBUGGER_PATH, MIBreakpointsManager.this.adjustDebuggerPath((String)this.getData()));
                        rm.done();
                    }
                });
            } else {
                attributes.put(ATTR_DEBUGGER_PATH, this.adjustDebuggerPath(hostPath));
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    String adjustDebuggerPath(String path) {
        return this.fBreakpoints instanceof IMIBreakpointPathAdjuster ? ((IMIBreakpointPathAdjuster)this.fBreakpoints).adjustDebuggerPath(path) : path;
    }

    private Map<String, Object> determineAttributesDelta(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        HashMap<String, Object> delta = new HashMap<String, Object>();
        Set<String> oldKeySet = oldAttributes.keySet();
        Set<String> newKeySet = newAttributes.keySet();
        HashSet<String> commonKeys = new HashSet<String>(newKeySet);
        commonKeys.retainAll(oldKeySet);
        HashSet<String> addedKeys = new HashSet<String>(newKeySet);
        addedKeys.removeAll(oldKeySet);
        HashSet<String> removedKeys = new HashSet<String>(oldKeySet);
        removedKeys.removeAll(newKeySet);
        for (String key : commonKeys) {
            if (oldAttributes.get(key).equals(newAttributes.get(key))) continue;
            delta.put(key, newAttributes.get(key));
        }
        for (String key : addedKeys) {
            delta.put(key, newAttributes.get(key));
        }
        for (String key : removedKeys) {
            delta.put(key, null);
        }
        return this.convertToPlatformAttributes(delta);
    }

    protected Map<String, Object> convertToPlatformAttributes(Map<String, Object> cdtAttributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cdtAttributes.containsKey(ATTR_DEBUGGER_PATH)) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", cdtAttributes.get(ATTR_DEBUGGER_PATH));
        }
        if (cdtAttributes.containsKey("lineNumber")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", cdtAttributes.get("lineNumber"));
        }
        if (cdtAttributes.containsKey("BREAKPOINT_ACTIONS")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", cdtAttributes.get("BREAKPOINT_ACTIONS"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.function")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.function", cdtAttributes.get("org.eclipse.cdt.debug.core.function"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.address")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.address", cdtAttributes.get("org.eclipse.cdt.debug.core.address"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.condition")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.condition", cdtAttributes.get("org.eclipse.cdt.debug.core.condition"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.ignoreCount")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount", cdtAttributes.get("org.eclipse.cdt.debug.core.ignoreCount"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.passCount")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.passCount", cdtAttributes.get("org.eclipse.cdt.debug.core.passCount"));
        }
        if (cdtAttributes.containsKey("org.eclipse.debug.core.enabled")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", cdtAttributes.get("org.eclipse.debug.core.enabled"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.breakpointType")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.type", cdtAttributes.get("org.eclipse.cdt.debug.core.breakpointType"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.expression")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.expression", cdtAttributes.get("org.eclipse.cdt.debug.core.expression"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.read")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.read", cdtAttributes.get("org.eclipse.cdt.debug.core.read"));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.write")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.write", cdtAttributes.get("org.eclipse.cdt.debug.core.write"));
        }
        if (cdtAttributes.containsKey(ATTR_THREAD_FILTER)) {
            result.put(ATTR_THREAD_FILTER, cdtAttributes.get(ATTR_THREAD_FILTER));
        }
        if (cdtAttributes.containsKey("org.eclipse.cdt.debug.core.printf_string")) {
            result.put("org.eclipse.cdt.dsf.debug.breakpoint.printf_string", cdtAttributes.get("org.eclipse.cdt.debug.core.printf_string"));
        }
        return result;
    }

    private Set<String> getThreads(Map<String, Object> attributes) {
        HashSet<String> threads = (HashSet<String>)attributes.get(ATTR_THREAD_FILTER);
        if (threads == null) {
            threads = new HashSet<String>();
            threads.add("0");
        }
        return threads;
    }

    private Set<String> extractThreads(IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc, ICBreakpoint breakpoint) {
        HashSet<String> results = new HashSet<String>();
        if (this.supportsThreads(breakpoint)) {
            int n;
            int n2;
            IRunControl.IContainerDMContext[] iContainerDMContextArray;
            ArrayList<IRunControl.IExecutionDMContext[]> threads = new ArrayList<IRunControl.IExecutionDMContext[]>(1);
            try {
                IRunControl.IContainerDMContext[] procTargets;
                IDsfBreakpointExtension filterExtension = this.getFilterExtension(breakpoint);
                iContainerDMContextArray = procTargets = filterExtension.getTargetFilters();
                n2 = procTargets.length;
                n = 0;
                while (n < n2) {
                    IRunControl.IContainerDMContext procDmc = iContainerDMContextArray[n];
                    if (procDmc.equals(bpTargetDmc) || DMContexts.isAncestorOf((IDMContext)procDmc, (IDMContext)bpTargetDmc)) {
                        IRunControl.IExecutionDMContext[] threadFilters = filterExtension.getThreadFilters(procDmc);
                        if (threadFilters == null) {
                            results.add("0");
                            return results;
                        }
                        threads.add(threadFilters);
                    }
                    ++n;
                }
            }
            catch (CoreException e) {
                results.add("0");
                return results;
            }
            if (threads.isEmpty()) {
                results.add("0");
                return results;
            }
            for (IRunControl.IExecutionDMContext[] targetThreads : threads) {
                if (targetThreads != null) {
                    iContainerDMContextArray = targetThreads;
                    n2 = targetThreads.length;
                    n = 0;
                    while (n < n2) {
                        IRunControl.IContainerDMContext thread = iContainerDMContextArray[n];
                        if (!(thread instanceof IMIExecutionDMContext)) {
                            results.clear();
                            results.add("0");
                            return results;
                        }
                        results.add(((IMIExecutionDMContext)thread).getThreadId());
                        ++n;
                    }
                    continue;
                }
                assert (false);
            }
        } else {
            results.add("0");
        }
        return results;
    }

    protected Map<String, Object> convertToTargetBreakpoint(ICBreakpoint breakpoint, Map<String, Object> attributes) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (breakpoint instanceof ICWatchpoint) {
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "watchpoint");
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.expression", attributes.get("org.eclipse.cdt.debug.core.expression"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.read", attributes.get("org.eclipse.cdt.debug.core.read"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.write", attributes.get("org.eclipse.cdt.debug.core.write"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.range", attributes.get("org.eclipse.cdt.debug.core.range"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.memoryspace", attributes.get("org.eclipse.cdt.debug.core.memoryspace"));
        } else if (breakpoint instanceof ICLineBreakpoint) {
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "breakpoint");
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", attributes.get(ATTR_DEBUGGER_PATH));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", attributes.get("lineNumber"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.function", attributes.get("org.eclipse.cdt.debug.core.function"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.address", attributes.get("org.eclipse.cdt.debug.core.address"));
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", attributes.get("BREAKPOINT_ACTIONS"));
            if (breakpoint instanceof ICTracepoint) {
                properties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "tracepoint");
                properties.put("org.eclipse.cdt.dsf.debug.breakpoint.passCount", attributes.get("org.eclipse.cdt.debug.core.passCount"));
            } else if (breakpoint instanceof ICDynamicPrintf) {
                properties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "dynamicPrintf");
                properties.put("org.eclipse.cdt.dsf.debug.breakpoint.printf_string", attributes.get("org.eclipse.cdt.debug.core.printf_string"));
            }
        } else if (breakpoint instanceof ICEventBreakpoint) {
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "catchpoint");
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.catchpoint_type", GdbCatchpoints.eventToGdbCatchpointKeyword((String)((String)attributes.get("org.eclipse.cdt.debug.core.eventbreakpoint_event_id"))));
            String arg = (String)attributes.get("org.eclipse.cdt.debug.core.eventbreakpoint_event_arg");
            String[] args = arg != null && arg.length() != 0 ? new String[]{arg} : new String[]{};
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.catchpoint_args", args);
        } else assert (false) : "platform breakpoint is of an unexpected type: " + breakpoint.getClass().getName();
        properties.put("org.eclipse.cdt.dsf.debug.breakpoint.condition", attributes.get("org.eclipse.cdt.debug.core.condition"));
        properties.put("org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount", attributes.get("org.eclipse.cdt.debug.core.ignoreCount"));
        properties.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", attributes.get("org.eclipse.debug.core.enabled"));
        properties.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", attributes.get(ATTR_THREAD_ID));
        Object breakpointType = attributes.get("org.eclipse.cdt.debug.core.breakpointType");
        if (breakpointType instanceof Integer) {
            boolean isHardware = ((Integer)breakpointType & 2) == 2;
            boolean isTemporary = ((Integer)breakpointType & 1) == 1;
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware", isHardware);
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", isTemporary);
        }
        if (!(breakpoint instanceof ICTracepoint || breakpoint instanceof ICDynamicPrintf || this.fBreakpointManager.isEnabled())) {
            properties.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", false);
        }
        return properties;
    }

    protected boolean needsResinstallation(Map<String, Object> delta) {
        if (delta == null) {
            return false;
        }
        return delta.containsKey(ATTR_DEBUGGER_PATH) || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber") || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.type") || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.function") || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.address") || delta.containsKey(ATTR_THREAD_FILTER) || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.expression") || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.read") || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.write") || delta.containsKey("org.eclipse.cdt.dsf.debug.breakpoint.printf_string");
    }

    protected void rollbackAttributes(ICBreakpoint breakpoint, IMarkerDelta oldValues) {
        try {
            String oldCondition;
            String newCondition = breakpoint.getCondition();
            if (newCondition == null) {
                newCondition = NULL_STRING;
            }
            String string = oldCondition = oldValues != null ? oldValues.getAttribute("org.eclipse.cdt.debug.core.condition", NULL_STRING) : NULL_STRING;
            if (!oldCondition.equals(newCondition)) {
                breakpoint.setCondition(oldCondition);
            } else {
                breakpoint.setCondition(NULL_STRING);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected boolean supportsThreads(ICBreakpoint breakpoint) {
        return !(breakpoint instanceof ICWatchpoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBreakpointEntirelyFiltered(IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc, ICBreakpoint breakpoint) {
        try {
            IRunControl.IContainerDMContext[] procTargets;
            IRunControl.IContainerDMContext[] iContainerDMContextArray = procTargets = this.getFilterExtension(breakpoint).getTargetFilters();
            int n = procTargets.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IRunControl.IContainerDMContext procDmc = iContainerDMContextArray[n2];
                if (procDmc.equals(bpTargetDmc)) return false;
                if (DMContexts.isAncestorOf((IDMContext)procDmc, (IDMContext)bpTargetDmc)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    public void addBreakpointsTrackingListener(IMIBreakpointsTrackingListener listener) {
        this.fTrackingListeners.add((Object)listener);
    }

    public void removeBreakpointsTrackingListener(IMIBreakpointsTrackingListener listener) {
        this.fTrackingListeners.remove((Object)listener);
    }

    private String[] compareAttributes(Map<String, Object> oldAttr, Map<String, Object> newAttr, String[] exclude) {
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> names = new HashSet<String>(oldAttr.keySet());
        names.addAll(newAttr.keySet());
        for (String n : names) {
            if (exclude != null && Arrays.asList(exclude).contains(n)) continue;
            Object oldValue = oldAttr.get(n);
            if (oldValue != null && !oldValue.equals(newAttr.get(n))) {
                list.add(n);
                continue;
            }
            if (oldValue != null || newAttr.get(n) == null) continue;
            list.add(n);
        }
        return list.toArray(new String[list.size()]);
    }

    public static interface IMIBreakpointsTrackingListener {
        public void breakpointTrackingStarted(IBreakpoints.IBreakpointsTargetDMContext var1);

        public void breakpointTrackingStopped(IBreakpoints.IBreakpointsTargetDMContext var1);
    }
}

