/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.ICOwner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class COwnerConfiguration {
    final IConfigurationElement fElement;
    final String fOwnerID;
    final String fName;

    public COwnerConfiguration(IConfigurationElement element) {
        this.fElement = element;
        this.fOwnerID = this.fElement.getDeclaringExtension().getUniqueIdentifier();
        this.fName = this.fElement.getDeclaringExtension().getLabel();
    }

    public COwnerConfiguration(String id, String name) {
        this.fElement = null;
        this.fOwnerID = id;
        this.fName = name;
    }

    public String getOwnerID() {
        return this.fOwnerID;
    }

    public String getName() {
        return this.fName;
    }

    public String getPlatform() {
        String platform = null;
        if (this.fElement != null) {
            platform = this.fElement.getAttribute("platform");
        }
        return platform == null ? "*" : platform;
    }

    public ICOwner createOwner() throws CoreException {
        if (this.fElement != null) {
            return (ICOwner)this.fElement.createExecutableExtension("class");
        }
        return null;
    }

    public String getNature() {
        return this.fElement != null ? this.fElement.getAttribute("natureID") : null;
    }
}

