/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.ICommandLauncherFactory;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class CommandLauncherManager {
    private static CommandLauncherManager instance;
    private List<ICommandLauncherFactory> factories = new ArrayList<ICommandLauncherFactory>();
    private Map<ICommandLauncherFactory, Integer> priorityMapping = new HashMap<ICommandLauncherFactory, Integer>();

    private CommandLauncherManager() {
        this.loadCommandLauncherFactoryExtensions();
    }

    public static synchronized CommandLauncherManager getInstance() {
        if (instance == null) {
            instance = new CommandLauncherManager();
        }
        return instance;
    }

    public ICommandLauncher getCommandLauncher() {
        return new CommandLauncherWrapper(this);
    }

    public ICommandLauncher getCommandLauncher(IProject project) {
        int highestPriority = -1;
        ICommandLauncher bestLauncher = null;
        for (ICommandLauncherFactory factory : this.factories) {
            ICommandLauncher launcher = factory.getCommandLauncher(project);
            if (launcher == null || this.priorityMapping.get(factory) <= highestPriority) continue;
            bestLauncher = launcher;
        }
        if (bestLauncher != null) {
            return bestLauncher;
        }
        return new CommandLauncher();
    }

    public ICommandLauncher getCommandLauncher(ICConfigurationDescription cfgd) {
        int highestPriority = -1;
        ICommandLauncher bestLauncher = null;
        for (ICommandLauncherFactory factory : this.factories) {
            ICommandLauncher launcher = factory.getCommandLauncher(cfgd);
            if (launcher == null || this.priorityMapping.get(factory) <= highestPriority) continue;
            bestLauncher = launcher;
        }
        if (bestLauncher != null) {
            return bestLauncher;
        }
        return new CommandLauncher();
    }

    private void loadCommandLauncherFactoryExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", "CommandLauncherFactory");
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    IConfigurationElement[] element;
                    IConfigurationElement[] iConfigurationElementArray = element = ext.getConfigurationElements();
                    int n3 = element.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element2 = iConfigurationElementArray[n4];
                        if (element2.getName().equalsIgnoreCase("factory")) {
                            ICommandLauncherFactory factory = (ICommandLauncherFactory)element2.createExecutableExtension("class");
                            String priorityAttr = element2.getAttribute("priority");
                            int priority = 0;
                            if (priorityAttr != null) {
                                try {
                                    priority = Integer.valueOf(priorityAttr);
                                }
                                catch (NumberFormatException e) {
                                    CCorePlugin.log(e);
                                }
                            }
                            this.factories.add(factory);
                            this.priorityMapping.put(factory, priority);
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log("Cannot load CommandLauncherFactory extension " + ext.getUniqueIdentifier(), e);
                }
                ++n2;
            }
        }
    }

    private ICommandLauncherFactory getBestFactory(IProject project) {
        int highestPriority = -1;
        ICommandLauncherFactory bestLauncherFactory = null;
        for (ICommandLauncherFactory factory : this.factories) {
            ICommandLauncher launcher = factory.getCommandLauncher(project);
            if (launcher == null || this.priorityMapping.get(factory) <= highestPriority) continue;
            bestLauncherFactory = factory;
        }
        return bestLauncherFactory;
    }

    public void setLanguageSettingEntries(IProject project, List<? extends ICLanguageSettingEntry> entries) {
        ICommandLauncherFactory factory = this.getBestFactory(project);
        if (factory != null) {
            factory.registerLanguageSettingEntries(project, entries);
        }
    }

    public List<ICLanguageSettingEntry> getLanguageSettingEntries(IProject project, List<ICLanguageSettingEntry> entries) {
        List<ICLanguageSettingEntry> verifiedEntries = entries;
        ICommandLauncherFactory factory = this.getBestFactory(project);
        if (factory != null) {
            verifiedEntries = factory.verifyLanguageSettingEntries(project, entries);
        }
        return verifiedEntries;
    }

    private class CommandLauncherWrapper
    implements ICommandLauncher {
        private ICommandLauncher launcher;
        private IProject fProject;
        private boolean fShowCommand;
        private String fErrorMessage;
        private CommandLauncherManager manager;

        public CommandLauncherWrapper(CommandLauncherManager manager) {
            this.manager = manager;
        }

        @Override
        public void setProject(IProject project) {
            this.fProject = project;
            this.launcher = null;
        }

        @Override
        public IProject getProject() {
            if (this.launcher != null) {
                return this.launcher.getProject();
            }
            return this.fProject;
        }

        @Override
        public void showCommand(boolean show) {
            if (this.launcher != null) {
                this.launcher.showCommand(show);
            }
            this.fShowCommand = show;
        }

        @Override
        public String getErrorMessage() {
            if (this.launcher != null) {
                return this.launcher.getErrorMessage();
            }
            return this.fErrorMessage;
        }

        @Override
        public void setErrorMessage(String error) {
            if (this.launcher != null) {
                this.launcher.setErrorMessage(error);
            }
            this.fErrorMessage = error;
        }

        @Override
        public String[] getCommandArgs() {
            if (this.launcher != null) {
                return this.launcher.getCommandArgs();
            }
            return new String[0];
        }

        @Override
        public Properties getEnvironment() {
            if (this.launcher != null) {
                return this.launcher.getEnvironment();
            }
            return null;
        }

        @Override
        public String getCommandLine() {
            if (this.launcher != null) {
                return this.launcher.getCommandLine();
            }
            return null;
        }

        @Override
        public Process execute(IPath commandPath, String[] args, String[] env, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
            if (this.launcher == null) {
                this.launcher = this.manager.getCommandLauncher(this.fProject);
                this.launcher.setProject(this.fProject);
                this.launcher.showCommand(this.fShowCommand);
                this.launcher.setErrorMessage(this.fErrorMessage);
            }
            return this.launcher.execute(commandPath, args, env, workingDirectory, monitor);
        }

        @Override
        public int waitAndRead(OutputStream out, OutputStream err) {
            if (this.launcher != null) {
                return this.launcher.waitAndRead(out, err);
            }
            return 0;
        }

        @Override
        public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
            if (this.launcher != null) {
                return this.launcher.waitAndRead(output, err, monitor);
            }
            return 0;
        }
    }
}

