/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.ui.CodanEditorUtility;
import org.eclipse.cdt.codan.ui.ICodanMarkerResolution;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractCodanCMarkerResolution
implements ICodanMarkerResolution {
    private boolean codanProblem;

    public int getOffset(IMarker marker, IDocument doc) {
        int position;
        int charStart = marker.getAttribute("charStart", -1);
        if (charStart > 0) {
            position = charStart;
        } else {
            int line = marker.getAttribute("lineNumber", -1) - 1;
            try {
                position = doc.getLineOffset(line);
            }
            catch (BadLocationException e) {
                return -1;
            }
        }
        return position;
    }

    public boolean isCodanProblem() {
        return this.codanProblem;
    }

    public String getProblemArgument(IMarker marker, int index) {
        return CodanProblemMarker.getProblemArgument((IMarker)marker, (int)index);
    }

    public void run(IMarker marker) {
        IDocument doc = this.openDocument(marker);
        if (doc != null) {
            this.codanProblem = this.getProblemId(marker) != null;
            this.apply(marker, doc);
        }
    }

    public abstract void apply(IMarker var1, IDocument var2);

    public boolean isApplicable(IMarker marker) {
        return true;
    }

    protected IEditorPart openEditor(IMarker marker) {
        IEditorPart editorPart;
        try {
            editorPart = CodanEditorUtility.openInEditor((IMarker)marker);
        }
        catch (PartInitException e) {
            CodanUIActivator.log((Throwable)e);
            return null;
        }
        return editorPart;
    }

    protected IDocument openDocument(IMarker marker) {
        return this.openDocument(this.openEditor(marker));
    }

    protected IDocument openDocument(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)editorPart;
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            return doc;
        }
        return null;
    }

    protected ITranslationUnit getTranslationUnitViaEditor(IMarker marker) {
        ITranslationUnit tu = (ITranslationUnit)CDTUITools.getEditorInputCElement((IEditorInput)this.openEditor(marker).getEditorInput());
        return tu;
    }

    protected ITranslationUnit getTranslationUnitViaWorkspace(IMarker marker) {
        IPath path = marker.getResource().getFullPath();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        ITranslationUnit tu = (ITranslationUnit)CoreModel.getDefault().create(file);
        return tu;
    }

    protected IASTName getASTNameFromMarker(IMarker marker, IASTTranslationUnit ast) {
        int charStart = marker.getAttribute("charStart", -1);
        int length = marker.getAttribute("charEnd", -1) - charStart;
        return this.getASTNameFromPositions(ast, charStart, length);
    }

    protected IASTName getASTNameFromPositions(IASTTranslationUnit ast, int charStart, int length) {
        IASTName name = ast.getNodeSelector(null).findEnclosingName(charStart, length);
        return name;
    }

    protected ICElement getCElementFromMarker(IMarker marker) {
        ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
        ICElement element = null;
        try {
            int charStart = marker.getAttribute("charStart", -1);
            if (charStart > 0) {
                element = tu.getElementAtOffset(charStart);
            } else {
                int lineNumber = marker.getAttribute("lineNumber", -1);
                element = tu.getElementAtLine(lineNumber);
            }
        }
        catch (CModelException e) {
            CodanUIActivator.log((Throwable)e);
        }
        return element;
    }

    protected IIndex getIndexFromMarker(IMarker marker) throws CoreException {
        IProject project = marker.getResource().getProject();
        ICProject cProject = CoreModel.getDefault().create(project);
        IIndex index = CCorePlugin.getIndexManager().getIndex(cProject);
        return index;
    }

    public String getProblemId(IMarker marker) {
        return CodanProblemMarker.getProblemId((IMarker)marker);
    }

    public IProblem getProblem(IMarker marker) {
        IResource resource = marker.getResource();
        IProblemProfile profile = CodanRuntime.getInstance().getCheckersRegistry().getResourceProfile(resource);
        String id = this.getProblemId(marker);
        return profile.findProblem(id);
    }

    public String getProblemMessage(IMarker marker) {
        return CodanProblemMarker.getMessage((IMarker)marker);
    }
}

