/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.codan.ui.ICodanMarkerResolutionExtension;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.InsertEdit;

public class QuickFixSuppressProblem
extends AbstractAstRewriteQuickFix
implements ICodanMarkerResolutionExtension {
    private static final String COMMENT_TEMPLATE = " // %s";
    private String problemName;

    public String getLabel() {
        return String.format(QuickFixMessages.QuickFixSuppressProblem_Label, this.problemName);
    }

    public void modifyAST(IIndex index, IMarker marker) {
        String supressionComment = this.getSupressionComment(this.getProblem(marker));
        if (supressionComment == null) {
            return;
        }
        try {
            int line = marker.getAttribute("lineNumber", 0);
            IRegion lineInformation = this.getDocument().getLineInformation(line - 1);
            int offset = lineInformation.getOffset() + lineInformation.getLength();
            String commentString = String.format(COMMENT_TEMPLATE, supressionComment);
            InsertEdit edit = new InsertEdit(offset, commentString);
            edit.apply(this.getDocument());
        }
        catch (BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }

    private String getSupressionComment(IProblem problem) {
        RootProblemPreference root;
        Object value;
        IProblemPreference preference = problem.getPreference();
        if (preference instanceof RootProblemPreference && (value = (root = (RootProblemPreference)preference).getChildValue("suppression_comment")) instanceof String && ((String)value).trim().length() > 0) {
            return (String)value;
        }
        return null;
    }

    public void prepareFor(IMarker marker) {
        this.problemName = this.getProblem(marker).getName();
    }

    public boolean isApplicable(IMarker marker) {
        return this.getProblem(marker) != null;
    }
}

