/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.tray.MainTrayEditPart;
import org.eclipse.bpel.common.ui.tray.TrayCategoryEditPart;
import org.eclipse.bpel.common.ui.tray.TrayCategoryEntryEditPart;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.swt.events.KeyEvent;

public class TrayKeyHandler
extends KeyHandler {
    protected EditPartViewer viewer;

    public TrayKeyHandler(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    public boolean keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 0x1000001: {
                return this.navigateNext(event, 1);
            }
            case 0x1000002: {
                return this.navigateNext(event, 4);
            }
            case 0x1000007: {
                return this.navigateJump(event, 8);
            }
            case 0x1000008: {
                return this.navigateJump(event, 32);
            }
            case 0x1000006: {
                return this.navigateJump(event, 4);
            }
            case 0x1000005: {
                return this.navigateJump(event, 1);
            }
            case 0x100000B: {
                return this.activateDirectEdit(event);
            }
        }
        return super.keyPressed(event);
    }

    protected boolean navigateNext(KeyEvent event, int direction) {
        GraphicalEditPart currentPart = (GraphicalEditPart)this.viewer.getFocusEditPart();
        ArrayList flatList = new ArrayList();
        this.buildFlatList(flatList, this.viewer.getContents());
        int currentPosition = flatList.indexOf(currentPart);
        switch (direction) {
            case 1: {
                --currentPosition;
                break;
            }
            case 4: {
                ++currentPosition;
            }
        }
        if (currentPosition >= 0 && currentPosition < flatList.size()) {
            currentPart = (GraphicalEditPart)flatList.get(currentPosition);
            this.navigateTo(currentPart, event);
            return true;
        }
        return false;
    }

    protected void buildFlatList(List result, EditPart container) {
        result.add(container);
        for (EditPart part : container.getChildren()) {
            this.buildFlatList(result, part);
        }
    }

    protected boolean navigateJump(KeyEvent event, int direction) {
        return true;
    }

    protected void navigateTo(GraphicalEditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            this.viewer.appendSelection((EditPart)part);
            this.viewer.setFocus((EditPart)part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.viewer.setFocus((EditPart)part);
        } else {
            this.viewer.select((EditPart)part);
        }
        this.reveal(part);
    }

    protected void reveal(GraphicalEditPart part) {
        if (part instanceof MainTrayEditPart) {
            return;
        }
        MainTrayEditPart mainPart = this.getMainTrayEditPart((EditPart)part);
        ScrollPane scrollpane = ((MainTrayEditPart.MainTrayContainerFigure)mainPart.getFigure()).getChildrenScrollPane();
        Viewport viewport = scrollpane.getViewport();
        Rectangle partBounds = part.getFigure().getBounds().getCopy();
        Rectangle portBounds = viewport.getBounds();
        if (!portBounds.contains(partBounds)) {
            Point topLocation = partBounds.getTopLeft();
            Point currentLocation = viewport.getViewLocation();
            int step = this.getScrollStep(part);
            if (currentLocation.getPosition(topLocation) == 1) {
                currentLocation.y -= step;
                currentLocation.y = currentLocation.y < step ? 0 : currentLocation.y;
            } else {
                currentLocation.y += step;
            }
            viewport.setViewLocation(currentLocation);
            ScrollBar scrollbar = scrollpane.getVerticalScrollBar();
            scrollbar.invalidate();
            scrollbar.validate();
        }
    }

    protected int getScrollStep(GraphicalEditPart part) {
        if (part instanceof TrayCategoryEntryEditPart) {
            return part.getFigure().getBounds().height;
        }
        if (part instanceof TrayCategoryEditPart) {
            return ((TrayCategoryEditPart)part).getTitleFigure().getBounds().height;
        }
        return 0;
    }

    protected MainTrayEditPart getMainTrayEditPart(EditPart part) {
        if (part instanceof MainTrayEditPart) {
            return (MainTrayEditPart)part;
        }
        return this.getMainTrayEditPart(part.getParent());
    }

    protected boolean activateDirectEdit(KeyEvent event) {
        GraphicalEditPart currentPart = (GraphicalEditPart)this.viewer.getFocusEditPart();
        currentPart.performRequest((Request)new DirectEditRequest());
        return true;
    }
}

