/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ResourceEntryWrapper;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class AddSelectedLibToCurrentReportDesignAction
extends Action {
    private StructuredViewer viewer;
    private static final String ACTION_TEXT = Messages.getString((String)"UseLibraryAction.Text");

    public AddSelectedLibToCurrentReportDesignAction(StructuredViewer viewer) {
        super(ACTION_TEXT);
        this.viewer = viewer;
    }

    public boolean isEnabled() {
        boolean enabled;
        LibraryHandle library = this.getSelectedLibrary();
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        boolean bl = enabled = library != null && moduleHandle != null && !moduleHandle.isInclude(library) && library.getFileName() != null && !library.getFileName().equals(moduleHandle.getFileName());
        if (enabled) {
            enabled = this.testRun(library);
        }
        if (library != null) {
            library.close();
        }
        return enabled;
    }

    public void run() {
        if (this.isEnabled()) {
            LibraryHandle library = this.getSelectedLibrary();
            try {
                UIUtil.includeLibrary((LibraryHandle)library);
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    @Deprecated
    private boolean testRun(LibraryHandle library) {
        boolean enabled = false;
        CommandStack commandStack = Utility.getCommandStack();
        commandStack.startTrans("");
        try {
            UIUtil.includeLibrary((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), (LibraryHandle)library, (boolean)true);
            enabled = true;
        }
        catch (Exception exception) {
            enabled = false;
        }
        commandStack.rollback();
        return enabled;
    }

    private LibraryHandle getSelectedLibrary() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null && selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof LibraryHandle) {
                return (LibraryHandle)selected;
            }
            if (selected instanceof ReportResourceEntry && ((ReportResourceEntry)selected).getReportElement() instanceof LibraryHandle) {
                return (LibraryHandle)((ReportResourceEntry)selected).getReportElement();
            }
            if (selected instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)selected).getType() == 0) {
                return (LibraryHandle)((ResourceEntryWrapper)selected).getAdapter(LibraryHandle.class);
            }
        }
        return null;
    }
}

