/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.outline;

import org.eclipse.birt.report.debug.internal.ui.script.actions.ScriptEditAction;
import org.eclipse.birt.report.debug.internal.ui.script.outline.ScriptOutlineTreeProvider;
import org.eclipse.birt.report.debug.internal.ui.script.outline.ScriptProviderFactory;
import org.eclipse.birt.report.debug.internal.ui.script.outline.ScriptViewContextMenuProvider;
import org.eclipse.birt.report.debug.internal.ui.script.outline.node.DebugScriptElementNode;
import org.eclipse.birt.report.debug.internal.ui.script.outline.node.DebugScriptObjectNode;
import org.eclipse.birt.report.designer.internal.ui.views.RenameListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ScriptOutlinePage
extends ContentOutlinePage {
    public static final int SHOW_LEVEL = 3;
    private ModuleHandle reportHandle;

    public ScriptOutlinePage(ModuleHandle reportHandle) {
        this.reportHandle = reportHandle;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createContextMenu();
        ScriptOutlineTreeProvider provider = new ScriptOutlineTreeProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)provider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection obj = event.getSelection();
                ScriptEditAction action = new ScriptEditAction(obj);
                if (action.isEnabled()) {
                    action.run();
                }
            }
        });
        new RenameListener(this.getTreeViewer()).apply();
        this.getTreeViewer().setSorter((ViewerSorter)new ItemSorter());
        this.init(this.reportHandle);
        this.getTreeViewer().expandToLevel(3);
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null || item.getData() == null) {
                        tree.setToolTipText(null);
                    } else {
                        tree.setToolTipText(ScriptOutlinePage.this.getTooltip(item.getData()));
                    }
                }
            }
        });
    }

    private void init(ModuleHandle reportHandle) {
        this.setTreeInput(reportHandle);
    }

    private void setTreeInput(ModuleHandle reportHandle) {
        this.getTreeViewer().setInput((Object)new Object[]{reportHandle});
    }

    private void createContextMenu() {
        ScriptViewContextMenuProvider menuManager = new ScriptViewContextMenuProvider((ISelectionProvider)this.getTreeViewer());
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("outlinemenu", (MenuManager)menuManager, this.getSite().getSelectionProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
    }

    private String getTooltip(Object element) {
        return ScriptProviderFactory.createProvider(element).getNodeTooltip(element);
    }

    public void selectionItem(String id) {
        if (this.getTreeViewer() == null || this.getTreeViewer().getTree() == null) {
            return;
        }
        Object obj = ModuleUtil.getScriptObject((ModuleHandle)this.reportHandle, (String)id);
        if (obj instanceof PropertyHandle) {
            PropertyHandle handle = (PropertyHandle)obj;
            DebugScriptObjectNode node = new DebugScriptObjectNode(handle);
            DebugScriptElementNode parent = new DebugScriptElementNode(handle.getElementHandle());
            node.setNodeParent((Object)parent);
            StructuredSelection selection = new StructuredSelection((Object)node);
            this.setSelection((ISelection)selection);
        }
    }
}

