/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ui.action;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.amalgam.explorer.contextual.core.provider.AbstractLabelProviderFactory;
import org.eclipse.amalgam.explorer.contextual.core.ui.action.ExplorerHistory;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.IExplorerContextualViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class ExplorerContextualHistoryAction
extends Action
implements IMenuCreator,
ActionFactory.IWorkbenchAction {
    public static final String FORWARD_ACTION_ID = "forward";
    public static final String BACKWARD_ACTION_ID = "backward";
    private boolean _forward;
    private IExplorerContextualViewPart _explorerContextualViewPart;
    private ExplorerHistory _explorerHistory;

    public ExplorerContextualHistoryAction(IWorkbenchWindow window_p, IExplorerContextualViewPart explorerContextualView_p, boolean forward_p) {
        this._explorerContextualViewPart = explorerContextualView_p;
        ISharedImages sharedImages = window_p.getWorkbench().getSharedImages();
        if (forward_p) {
            this.setText("&Forward");
            this.setToolTipText("Forward");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.setId(FORWARD_ACTION_ID);
        } else {
            this.setText("&Back");
            this.setToolTipText("Back");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.setId(BACKWARD_ACTION_ID);
        }
        this._explorerHistory = explorerContextualView_p.getHistory();
        this._explorerHistory.addActionAsListener(this);
        this._forward = forward_p;
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    private HistoryItemAction createHistoryAction(ExplorerHistory.ExplorerNavigationHistoryEntry navigationEntry_p) {
        if (!navigationEntry_p.isValid()) {
            return null;
        }
        Object realObject = navigationEntry_p.getRealObject();
        ILabelProvider labelProvider = AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider();
        Image image = labelProvider.getImage(realObject);
        ImageDescriptor imgDescriptor = null;
        if (image != null) {
            imgDescriptor = ImageDescriptor.createFromImage((Image)image);
        }
        HistoryItemAction goToAction = new HistoryItemAction(navigationEntry_p, labelProvider.getText(realObject), imgDescriptor);
        return goToAction;
    }

    private List<ExplorerHistory.ExplorerNavigationHistoryEntry> getAvailableNavigationEntries() {
        List<ExplorerHistory.ExplorerNavigationHistoryEntry> historyEntries = null;
        if (this._forward) {
            historyEntries = this._explorerHistory.getForwardNavigationEntries();
        } else {
            historyEntries = this._explorerHistory.getBackwardNavigationEntries();
            Collections.reverse(historyEntries);
        }
        return historyEntries;
    }

    public Menu getMenu(Control parent_p) {
        MenuManager menuManager = new MenuManager();
        final Menu menu = menuManager.createContextMenu(parent_p);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager_p) {
                List navigationEntries = ExplorerContextualHistoryAction.this.getAvailableNavigationEntries();
                for (ExplorerHistory.ExplorerNavigationHistoryEntry entry : navigationEntries) {
                    HistoryItemAction historyEntryAction = ExplorerContextualHistoryAction.this.createHistoryAction(entry);
                    if (historyEntryAction == null) continue;
                    manager_p.add((IAction)historyEntryAction);
                }
            }
        });
        final Display display = menu.getDisplay();
        menu.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!menu.isDisposed()) {
                                menu.dispose();
                            }
                        }
                    });
                }
            }
        });
        return menu;
    }

    public Menu getMenu(Menu parent_p) {
        return null;
    }

    public void run() {
        Iterator<ExplorerHistory.ExplorerNavigationHistoryEntry> availableHistoryEntries = this.getAvailableNavigationEntries().iterator();
        if (availableHistoryEntries.hasNext()) {
            HistoryItemAction historyAction = this.createHistoryAction(availableHistoryEntries.next());
            while (historyAction == null) {
                historyAction = this.createHistoryAction(availableHistoryEntries.next());
            }
            if (historyAction != null) {
                historyAction.run();
            }
        }
    }

    public void updateControlState() {
        boolean enabled = false;
        if (this._forward) {
            if (this._explorerHistory.getForwardNavigationEntries().size() > 0) {
                enabled = true;
            }
        } else if (this._explorerHistory.getBackwardNavigationEntries().size() > 0) {
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    public void dispose() {
    }

    protected class HistoryItemAction
    extends Action {
        protected ExplorerHistory.ExplorerNavigationHistoryEntry _navigationEntry;

        public HistoryItemAction(ExplorerHistory.ExplorerNavigationHistoryEntry navigationEntry_p, String text_p, ImageDescriptor imageDescriptor_p) {
            super(text_p, imageDescriptor_p);
            this._navigationEntry = navigationEntry_p;
        }

        public void run() {
            ExplorerContextualHistoryAction.this._explorerHistory.setDoUpdate(false);
            try {
                ExplorerContextualHistoryAction.this._explorerHistory.goTo(this._navigationEntry);
                ExplorerContextualHistoryAction.this._explorerContextualViewPart.setInput(this._navigationEntry.getRealObject());
                ExplorerContextualHistoryAction.this._explorerHistory.notifyActionListeners();
            }
            finally {
                ExplorerContextualHistoryAction.this._explorerHistory.setDoUpdate(true);
            }
        }
    }
}

