/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.NetworkAttachment;
import com.spotify.docker.client.messages.swarm.TaskSpec;
import com.spotify.docker.client.messages.swarm.TaskStatus;
import com.spotify.docker.client.messages.swarm.Version;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Task {
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="Version")
    private Version version;
    @JsonProperty(value="CreatedAt")
    private Date createdAt;
    @JsonProperty(value="UpdatedAt")
    private Date updatedAt;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Spec")
    private TaskSpec spec;
    @JsonProperty(value="ServiceID")
    private String serviceId;
    @JsonProperty(value="Slot")
    private Integer slot;
    @JsonProperty(value="NodeID")
    private String nodeId;
    @JsonProperty(value="Status")
    private TaskStatus status;
    @JsonProperty(value="DesiredState")
    private String desiredState;
    @JsonProperty(value="NetworksAttachments")
    private ImmutableList<NetworkAttachment> networkAttachments;

    public String id() {
        return this.id;
    }

    public Version version() {
        return this.version;
    }

    public Date createdAt() {
        return this.createdAt == null ? null : new Date(this.createdAt.getTime());
    }

    public Date updatedAt() {
        return this.updatedAt == null ? null : new Date(this.updatedAt.getTime());
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public TaskSpec spec() {
        return this.spec;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public Integer slot() {
        return this.slot;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public TaskStatus status() {
        return this.status;
    }

    public String desiredState() {
        return this.desiredState;
    }

    public List<NetworkAttachment> networkAttachments() {
        return this.networkAttachments;
    }

    public static Criteria.Builder find() {
        return Criteria.builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task that = (Task)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.name, that.name) && Objects.equals(this.labels, that.labels) && Objects.equals(this.spec, that.spec) && Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.slot, that.slot) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.status, that.status) && Objects.equals(this.desiredState, that.desiredState) && Objects.equals(this.networkAttachments, that.networkAttachments);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.createdAt, this.updatedAt, this.name, this.labels, this.spec, this.serviceId, this.slot, this.nodeId, this.status, this.desiredState, this.networkAttachments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("version", (Object)this.version).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("name", (Object)this.name).add("labels", this.labels).add("spec", (Object)this.spec).add("serviceId", (Object)this.serviceId).add("slot", (Object)this.slot).add("nodeId", (Object)this.nodeId).add("status", (Object)this.status).add("desiredState", (Object)this.desiredState).add("networkAttachments", this.networkAttachments).toString();
    }

    public static class Criteria {
        private String taskId;
        private String taskName;
        private String serviceName;
        private String nodeId;
        private String label;
        private String desiredState;

        private Criteria(Builder builder) {
            this.taskId = builder.taskId;
            this.taskName = builder.taskName;
            this.serviceName = builder.serviceName;
            this.nodeId = builder.nodeId;
            this.label = builder.label;
            this.desiredState = builder.desiredState;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDesiredState() {
            return this.desiredState;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String taskId;
            private String taskName;
            private String serviceName;
            private String nodeId;
            private String label;
            private String desiredState;

            public Builder withTaskId(String taskId) {
                this.taskId = taskId;
                return this;
            }

            public Builder withTaskName(String taskName) {
                this.taskName = taskName;
                return this;
            }

            public Builder withServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder withNodeId(String nodeId) {
                this.nodeId = nodeId;
                return this;
            }

            public Builder withLabel(String label) {
                this.label = label;
                return this;
            }

            public Builder withDesiredState(String desiredState) {
                this.desiredState = desiredState;
                return this;
            }

            public Criteria build() {
                return new Criteria(this);
            }
        }
    }
}

