/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogReader;
import com.spotify.docker.client.LogStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultLogStream
extends AbstractIterator<LogMessage>
implements LogStream {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogStream.class);
    private final LogReader reader;
    private volatile boolean closed;

    private DefaultLogStream(InputStream stream) {
        this(new LogReader(stream));
    }

    @VisibleForTesting
    DefaultLogStream(LogReader reader) {
        this.reader = reader;
    }

    static DefaultLogStream create(InputStream stream) {
        return new DefaultLogStream(stream);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    protected LogMessage computeNext() {
        LogMessage message;
        try {
            message = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (message == null) {
            return (LogMessage)this.endOfData();
        }
        return message;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String readFully() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNext()) {
            stringBuilder.append(Charsets.UTF_8.decode(((LogMessage)this.next()).content()));
        }
        return stringBuilder.toString();
    }

    @Override
    public void attach(OutputStream stdout, OutputStream stderr) throws IOException {
        this.attach(stdout, stderr, true);
    }

    @Override
    public void attach(OutputStream stdout, OutputStream stderr, boolean closeAtEOF) throws IOException {
        try (Closer closer = Closer.create();){
            if (closeAtEOF) {
                closer.register((Closeable)stdout);
                closer.register((Closeable)stderr);
            }
            while (this.hasNext()) {
                LogMessage message = (LogMessage)this.next();
                ByteBuffer content = message.content();
                switch (message.stream()) {
                    case STDOUT: {
                        DefaultLogStream.writeAndFlush(content, stdout);
                        break;
                    }
                    case STDERR: {
                        DefaultLogStream.writeAndFlush(content, stderr);
                        break;
                    }
                }
            }
        }
    }

    private static void writeAndFlush(ByteBuffer buffer, OutputStream outputStream) throws IOException {
        if (buffer.hasArray()) {
            outputStream.write(buffer.array(), buffer.position(), buffer.remaining());
        } else {
            while (buffer.hasRemaining()) {
                int size = Math.min(buffer.remaining(), 8192);
                byte[] chunk = new byte[size];
                buffer.get(chunk);
                outputStream.write(chunk);
            }
        }
        outputStream.flush();
    }
}

