/*
 * Decompiled with CFR 0.152.
 */
package com.mycorp.examples.timeservice.host;

import com.mycorp.examples.timeservice.ITimeService;
import com.mycorp.examples.timeservice.host.TimeServiceImpl;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DebugRemoteServiceAdminListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final boolean verbose = Boolean.valueOf(System.getProperty("verboseRemoteServiceAdmin", "true"));
    private ServiceRegistration<ITimeService> timeServiceRegistration;
    private static final String SERVICE_EXPORTED_CONFIGS = "service.exported.configs";
    private static final String DEFAULT_CONFIG = "ecf.generic.server";

    public void start(BundleContext context) throws Exception {
        if (verbose) {
            context.registerService(RemoteServiceAdminListener.class, (Object)new DebugRemoteServiceAdminListener(), null);
        }
        Dictionary<String, Object> props = this.createRemoteServiceProperties();
        this.timeServiceRegistration = context.registerService(ITimeService.class, (Object)new TimeServiceImpl(), props);
        System.out.println("TimeService host registered with registration=" + this.timeServiceRegistration);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.timeServiceRegistration != null) {
            this.timeServiceRegistration.unregister();
            this.timeServiceRegistration = null;
        }
    }

    private Dictionary<String, Object> createRemoteServiceProperties() {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("service.exported.interfaces", "*");
        result.put("ecf.exported.async.interfaces", "*");
        Properties props = System.getProperties();
        String config = props.getProperty(SERVICE_EXPORTED_CONFIGS);
        if (config == null) {
            config = DEFAULT_CONFIG;
            result.put("ecf.generic.server.port", "3288");
            result.put("ecf.generic.server.hostname", "localhost");
        }
        result.put(SERVICE_EXPORTED_CONFIGS, config);
        for (Object k : props.keySet()) {
            String key;
            if (!(k instanceof String) || !(key = (String)k).startsWith(config)) continue;
            result.put(key, props.get(key));
        }
        return result;
    }
}

